/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.fixedhistogram;

import com.facebook.presto.operator.aggregation.fixedhistogram.FixedDoubleHistogram;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFixedDoubleHistogram {
    @Test
    public void testGetters() {
        FixedDoubleHistogram histogram = new FixedDoubleHistogram(200, 3.0, 4.0);
        Assert.assertEquals((int)histogram.getBucketCount(), (int)200);
        Assert.assertEquals((double)histogram.getMin(), (double)3.0);
        Assert.assertEquals((double)histogram.getMax(), (double)4.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="bucketCount must be at least 2: -200")
    public void testIllegalBucketCount() {
        new FixedDoubleHistogram(-200, 3.0, 4.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="min must be smaller than max: 3.0 3.0")
    public void testIllegalMinMax() {
        new FixedDoubleHistogram(200, 3.0, 3.0);
    }

    @Test
    public void testBasicOps() {
        FixedDoubleHistogram histogram = new FixedDoubleHistogram(200, 3.0, 4.0);
        histogram.add(3.1, 100.0);
        histogram.add(3.8, 200.0);
        Assert.assertEquals((double)Streams.stream((Iterator)histogram.iterator()).mapToDouble(c -> c.getWeight()).sum(), (double)300.0);
    }

    @Test
    public void testMassive() {
        FixedDoubleHistogram histogram = new FixedDoubleHistogram(100, 0.0, 1.0);
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (int i = 0; i < 1000000; ++i) {
            double value = Math.random();
            double weight = (double)((int)(10.0 * Math.random())) / 10.0;
            values.add(value);
            weights.add(weight);
            histogram.add(value, weight);
        }
        Streams.stream((Iterator)histogram.iterator()).forEach(b -> {
            double weight = IntStream.range(0, values.size()).filter(i -> b.getLeft() < (Double)values.get(i) && (Double)values.get(i) <= b.getRight()).mapToDouble(i -> (Double)weights.get(i)).sum();
            Assert.assertEquals((double)b.getWeight(), (double)weight, (double)1.0E-4);
        });
    }

    @Test
    public void testMassiveMerge() {
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> weights = new ArrayList<Double>();
        FixedDoubleHistogram left = new FixedDoubleHistogram(100, 0.0, 1.0);
        for (int i = 0; i < 100; ++i) {
            double value = Math.random();
            double weight = Math.random();
            values.add(value);
            weights.add(weight);
            left.add(value, weight);
        }
        FixedDoubleHistogram right = new FixedDoubleHistogram(100, 0.0, 1.0);
        ArrayList<Double> rightValues = new ArrayList<Double>();
        ArrayList<Double> rightWeights = new ArrayList<Double>();
        for (int i = 0; i < 100; ++i) {
            double value = Math.random();
            double weight = Math.random();
            values.add(value);
            weights.add(weight);
            rightValues.add(value);
            rightWeights.add(weight);
            right.add(value, weight);
        }
        left.mergeWith(right.clone());
        Streams.stream((Iterator)left.iterator()).forEach(b -> {
            double weight = IntStream.range(0, values.size()).filter(i -> b.getLeft() < (Double)values.get(i) && (Double)values.get(i) <= b.getRight()).mapToDouble(i -> (Double)weights.get(i)).sum();
            Assert.assertEquals((double)b.getWeight(), (double)weight, (double)1.0E-4);
        });
        Streams.stream((Iterator)right.iterator()).forEach(b -> {
            double weight = IntStream.range(0, rightValues.size()).filter(i -> b.getLeft() < (Double)rightValues.get(i) && (Double)rightValues.get(i) <= b.getRight()).mapToDouble(i -> (Double)rightWeights.get(i)).sum();
            Assert.assertEquals((double)b.getWeight(), (double)weight, (double)1.0E-4);
        });
    }
}

