/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkRowToRowCast {
    private static final int POSITION_COUNT = 100000;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkRowToRowCast().benchmark(data);
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkRowToRowCast().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkRowToRowCast.class.getSimpleName() + ".*").warmupMode(WarmupMode.INDI).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final List<Type> fromFieldTypes = ImmutableList.of((Object)VarcharType.createVarcharType((int)20), (Object)BigintType.BIGINT);
        private static final List<Type> toFieldTypes = ImmutableList.of((Object)VarcharType.createVarcharType((int)30), (Object)BigintType.BIGINT);
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            FunctionHandle functionHandle = metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, (Type)RowType.anonymous(fromFieldTypes), (Type)RowType.anonymous(toFieldTypes));
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(CastType.CAST.name(), functionHandle, (Type)RowType.anonymous(fromFieldTypes), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)RowType.anonymous(toFieldTypes)))));
            this.pageProcessor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0)).compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
            Block[] fieldBlocks = (Block[])fromFieldTypes.stream().map(type -> BenchmarkData.createBlock(100000, type)).toArray(Block[]::new);
            Block rowBlock = RowBlock.fromFieldBlocks((int)100000, Optional.empty(), (Block[])fieldBlocks);
            this.page = new Page(new Block[]{rowBlock});
        }

        private static Block createBlock(int positionCount, Type type) {
            BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
            if (type instanceof VarcharType) {
                for (int i = 0; i < positionCount; ++i) {
                    type.writeSlice(blockBuilder, Slices.utf8Slice((String)String.valueOf(ThreadLocalRandom.current().nextInt())));
                }
            } else if (type == BigintType.BIGINT) {
                for (int i = 0; i < positionCount; ++i) {
                    type.writeLong(blockBuilder, ThreadLocalRandom.current().nextLong());
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

