/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestArrayFindFirstFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("find_first(ARRAY [5, 6], x -> x = 5)", (Type)IntegerType.INTEGER, 5);
        this.assertFunction("find_first(ARRAY [BIGINT '5', BIGINT '6'], x -> x = 5)", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("find_first(ARRAY [5, 6], x -> x > 5)", (Type)IntegerType.INTEGER, 6);
        this.assertFunction("find_first(ARRAY [null, false, true, false, true, false], x -> nullif(x, false))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("find_first(ARRAY [null, true, false, null, true, false, null], x -> not x)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("find_first(ARRAY [4.8E0, 6.2E0], x -> x > 5)", (Type)DoubleType.DOUBLE, 6.2);
        this.assertFunction("find_first(ARRAY ['abc', 'def', 'ayz'], x -> substr(x, 1, 1) = 'a')", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("find_first(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> x[2] IS NULL)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null, "123"));
    }

    @Test
    public void testPositiveOffset() {
        this.assertFunction("find_first(ARRAY [5, 6], 2, x -> x = 5)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("find_first(ARRAY [5, 6], 4, x -> x > 0)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("find_first(ARRAY [5, 6, 7, 8], 3, x -> x > 5)", (Type)IntegerType.INTEGER, 7);
        this.assertFunction("find_first(ARRAY [3, 4, 5, 6], 2, x -> x > 0)", (Type)IntegerType.INTEGER, 4);
        this.assertFunction("find_first(ARRAY [3, 4, 5, 6], 2, x -> x < 4)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("find_first(ARRAY [null, false, true, null, true, false], 4, x -> nullif(x, false))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("find_first(ARRAY [4.8E0, 6.2E0, 7.8E0], 3, x -> x > 5)", (Type)DoubleType.DOUBLE, 7.8);
        this.assertFunction("find_first(ARRAY ['abc', 'def', 'ayz'], 2, x -> substr(x, 1, 1) = 'a')", (Type)VarcharType.createVarcharType((int)3), "ayz");
        this.assertFunction("find_first(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', null, '456']], 2, x -> x[2] IS NULL)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("def", null, "456"));
    }

    @Test
    public void testNegativeOffset() {
        this.assertFunction("find_first(ARRAY [5, 6], -2, x -> x > 5)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("find_first(ARRAY [5, 6], -4, x -> x > 0)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("find_first(ARRAY [5, 6, 7, 8], -2, x -> x > 5)", (Type)IntegerType.INTEGER, 7);
        this.assertFunction("find_first(ARRAY [9, 6, 3, 8], -2, x -> x > 5)", (Type)IntegerType.INTEGER, 6);
        this.assertFunction("find_first(ARRAY [3, 4, 5, 6], -2, x -> x > 0)", (Type)IntegerType.INTEGER, 5);
        this.assertFunction("find_first(ARRAY [3, 4, 5, 6], -2, x -> x > 5)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("find_first(ARRAY [null, false, true, null, true, false], -3, x -> nullif(x, false))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("find_first(ARRAY [4.8E0, 6.2E0, 7.8E0], -2, x -> x > 5)", (Type)DoubleType.DOUBLE, 6.2);
        this.assertFunction("find_first(ARRAY ['abc', 'def', 'ayz'], -2, x -> substr(x, 1, 1) = 'a')", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("find_first(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', null, '456']], -2, x -> x[2] IS NULL)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null, "123"));
    }

    @Test
    public void testEmpty() {
        this.assertFunction("find_first(ARRAY [], x -> true)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("find_first(ARRAY [], x -> false)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("find_first(CAST (ARRAY [] AS ARRAY(INTEGER)), x -> true)", (Type)IntegerType.INTEGER, null);
    }

    @Test
    public void testNullArray() {
        this.assertInvalidFunction("find_first(ARRAY [NULL], x -> x IS NULL)", "FIND_FIRST finds NULL as match, which is not supported.");
        this.assertFunction("find_first(ARRAY [NULL], x -> x IS NOT NULL)", (Type)UnknownType.UNKNOWN, null);
        this.assertInvalidFunction("find_first(ARRAY [CAST (NULL AS INTEGER)], x -> x IS NULL)", "FIND_FIRST finds NULL as match, which is not supported.");
    }

    @Test
    public void testNull() {
        this.assertFunction("find_first(NULL, x -> true)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("find_first(NULL, x -> false)", (Type)UnknownType.UNKNOWN, null);
    }
}

