/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlTime;
import com.facebook.presto.common.type.SqlTimeWithTimeZone;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.chrono.ISOChronology;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class TestDateTimeFunctionsBase
extends AbstractTestFunctions {
    protected static final TimeZoneKey TIME_ZONE_KEY = TestingSession.DEFAULT_TIME_ZONE_KEY;
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    protected static final DateTimeZone UTC_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.UTC_KEY);
    protected static final DateTimeZone DATE_TIME_ZONE_NUMERICAL = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"-11:00"));
    protected static final TimeZoneKey KATHMANDU_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu");
    protected static final DateTimeZone KATHMANDU_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)KATHMANDU_ZONE_KEY);
    protected static final ZoneOffset WEIRD_ZONE = ZoneOffset.ofHoursMinutes(7, 9);
    protected static final DateTimeZone WEIRD_DATE_TIME_ZONE = DateTimeZone.forID((String)WEIRD_ZONE.getId());
    protected static final DateTime DATE = new DateTime(2001, 8, 22, 0, 0, 0, 0, DateTimeZone.UTC);
    protected static final String DATE_LITERAL = "DATE '2001-08-22'";
    protected static final String DATE_ISO8601_STRING = "2001-08-22";
    protected static final LocalTime TIME = LocalTime.of(3, 4, 5, 321000000);
    protected static final String TIME_LITERAL = "TIME '03:04:05.321'";
    protected static final OffsetTime WEIRD_TIME = OffsetTime.of(3, 4, 5, 321000000, WEIRD_ZONE);
    protected static final String WEIRD_TIME_LITERAL = "TIME '03:04:05.321 +07:09'";
    protected static final DateTime NEW_TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, UTC_TIME_ZONE);
    protected static final DateTime LEGACY_TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, DATE_TIME_ZONE);
    protected static final DateTime TIMESTAMP_WITH_NUMERICAL_ZONE = new DateTime(2001, 8, 22, 3, 4, 5, 321, DATE_TIME_ZONE_NUMERICAL);
    protected static final String TIMESTAMP_LITERAL = "TIMESTAMP '2001-08-22 03:04:05.321'";
    protected static final String TIMESTAMP_ISO8601_STRING = "2001-08-22T03:04:05.321-11:00";
    protected static final String TIMESTAMP_ISO8601_STRING_NO_TIME_ZONE = "2001-08-22T03:04:05.321";
    protected static final DateTime WEIRD_TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, WEIRD_DATE_TIME_ZONE);
    protected static final String WEIRD_TIMESTAMP_LITERAL = "TIMESTAMP '2001-08-22 03:04:05.321 +07:09'";
    protected static final String WEIRD_TIMESTAMP_ISO8601_STRING = "2001-08-22T03:04:05.321+07:09";
    protected static final String INTERVAL_LITERAL = "INTERVAL '90061.234' SECOND";
    protected static final Duration DAY_TO_SECOND_INTERVAL = Duration.ofMillis(90061234L);
    private final DateTime TIMESTAMP;

    protected TestDateTimeFunctionsBase(boolean legacyTimestamp) {
        super(TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", String.valueOf(legacyTimestamp)).setTimeZoneKey(TIME_ZONE_KEY).setStartTime(new DateTime(2017, 4, 1, 12, 34, 56, 789, UTC_TIME_ZONE).getMillis()).build());
        this.TIMESTAMP = legacyTimestamp ? LEGACY_TIMESTAMP : NEW_TIMESTAMP;
    }

    @Test
    public void testCurrentDate() {
        this.assertFunction("CURRENT_DATE", (Type)DateType.DATE, new SqlDate(Math.toIntExact(TestDateTimeFunctionsBase.epochDaysInZone(TIME_ZONE_KEY, this.session.getStartTime()))));
    }

    @Test
    public void testCurrentDateTimezone() {
        TimeZoneKey kievTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"Europe/Kiev");
        TimeZoneKey bahiaBanderasTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"America/Bahia_Banderas");
        TimeZoneKey montrealTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"America/Montreal");
        long timeIncrement = TimeUnit.MINUTES.toMillis(53L);
        for (long instant = ISOChronology.getInstanceUTC().getDateTimeMillis(2000, 6, 15, 0, 0, 0, 0); instant < ISOChronology.getInstanceUTC().getDateTimeMillis(2016, 6, 15, 0, 0, 0, 0); instant += timeIncrement) {
            this.assertCurrentDateAtInstant(kievTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(bahiaBanderasTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(montrealTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(TIME_ZONE_KEY, instant);
        }
    }

    private void assertCurrentDateAtInstant(TimeZoneKey timeZoneKey, long instant) {
        long expectedDays = TestDateTimeFunctionsBase.epochDaysInZone(timeZoneKey, instant);
        long dateTimeCalculation = DateTimeFunctions.currentDate((SqlFunctionProperties)new TestingConnectorSession("test", Optional.empty(), Optional.empty(), timeZoneKey, Locale.US, instant, (List)ImmutableList.of(), (Map)ImmutableMap.of(), SystemSessionProperties.isLegacyTimestamp((Session)this.session), Optional.empty(), (Set)ImmutableSet.of(), Optional.empty(), this.session.getSessionFunctions()).getSqlFunctionProperties());
        Assert.assertEquals((long)dateTimeCalculation, (long)expectedDays);
    }

    private static long epochDaysInZone(TimeZoneKey timeZoneKey, long instant) {
        return LocalDate.from(Instant.ofEpochMilli(instant).atZone(ZoneId.of(timeZoneKey.getId()))).toEpochDay();
    }

    @Test
    public void testFromUnixTime() {
        DateTime dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE);
        double seconds = (double)dateTime.getMillis() / 1000.0;
        this.assertFunction("from_unixtime(" + seconds + ")", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)dateTime, (Session)this.session));
        dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 888, DATE_TIME_ZONE);
        seconds = (double)dateTime.getMillis() / 1000.0;
        this.assertFunction("from_unixtime(" + seconds + ")", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)dateTime, (Session)this.session));
    }

    @Test
    public void testFromUnixTimeWithOffset() {
        DateTime dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE);
        double seconds = (double)dateTime.getMillis() / 1000.0;
        int timeZoneHoursOffset = 1;
        int timezoneMinutesOffset = 10;
        DateTime expected = new DateTime((Object)dateTime, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)((long)timeZoneHoursOffset * 60L + (long)timezoneMinutesOffset))));
        this.assertFunction("from_unixtime(" + seconds + ", " + timeZoneHoursOffset + ", " + timezoneMinutesOffset + ")", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
        this.assertInvalidFunction("from_unixtime(0, 1, 10000)", "Invalid offset minutes 10060");
        this.assertInvalidFunction("from_unixtime(0, 10000, 0)", "Invalid offset minutes 600000");
        this.assertInvalidFunction("from_unixtime(0, -100, 100)", "Invalid offset minutes -5900");
    }

    @Test
    public void testFromUnixTimeWithTimeZone() {
        String zoneId = "Asia/Shanghai";
        DateTime expected = new DateTime(1970, 1, 1, 10, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
        zoneId = "Asia/Tokyo";
        expected = new DateTime(1970, 1, 1, 11, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
        zoneId = "Europe/Moscow";
        expected = new DateTime(1970, 1, 1, 5, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
        zoneId = "America/New_York";
        expected = new DateTime(1969, 12, 31, 21, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
        zoneId = "America/Chicago";
        expected = new DateTime(1969, 12, 31, 20, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
        zoneId = "America/Los_Angeles";
        expected = new DateTime(1969, 12, 31, 18, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(expected));
    }

    @Test
    public void testToUnixTime() {
        this.assertFunction("to_unixtime(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)DoubleType.DOUBLE, (double)this.TIMESTAMP.getMillis() / 1000.0);
        this.assertFunction("to_unixtime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)DoubleType.DOUBLE, (double)WEIRD_TIMESTAMP.getMillis() / 1000.0);
    }

    @Test
    public void testDate() {
        this.assertFunction("date('2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE));
        this.assertFunction("date(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE));
        this.assertFunction("date(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE));
    }

    @Test
    public void testFromISO8601() {
        this.assertFunction("from_iso8601_timestamp('2001-08-22T03:04:05.321-11:00')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(TIMESTAMP_WITH_NUMERICAL_ZONE));
        this.assertFunction("from_iso8601_timestamp('2001-08-22T03:04:05.321+07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP));
        this.assertFunction("from_iso8601_date('2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE));
    }

    @Test
    public void testToIso8601() {
        this.assertFunction("to_iso8601(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)VarcharType.createVarcharType((int)35), WEIRD_TIMESTAMP_ISO8601_STRING);
        this.assertFunction("to_iso8601(DATE '2001-08-22')", (Type)VarcharType.createVarcharType((int)16), DATE_ISO8601_STRING);
    }

    @Test
    public void testTimeZone() {
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getHourOfDay());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("current_timezone()", (Type)VarcharType.VARCHAR, TIME_ZONE_KEY.getId());
    }

    @Test
    public void testPartFunctions() {
        this.assertFunction("millisecond(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getMillisOfSecond());
        this.assertFunction("second(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getSecondOfMinute());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getHourOfDay());
        this.assertFunction("day_of_week(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.dayOfWeek().get());
        this.assertFunction("dow(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.dayOfWeek().get());
        this.assertFunction("day(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_month(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_year(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.dayOfYear().get());
        this.assertFunction("doy(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.dayOfYear().get());
        this.assertFunction("week(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("week_of_year(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("month(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getMonthOfYear());
        this.assertFunction("quarter(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, (long)this.TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("year(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getYear());
        this.assertFunction("timezone_minute(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("timezone_hour(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, -11L);
        this.assertFunction("timezone_hour(localtimestamp)", (Type)BigintType.BIGINT, 14L);
        this.assertFunction("timezone_hour(current_timestamp)", (Type)BigintType.BIGINT, 14L);
        this.assertFunction("millisecond(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMillisOfSecond());
        this.assertFunction("second(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getSecondOfMinute());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("day_of_week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfWeek().get());
        this.assertFunction("dow(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfWeek().get());
        this.assertFunction("day(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfYear().get());
        this.assertFunction("doy(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfYear().get());
        this.assertFunction("week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("week_of_year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMonthOfYear());
        this.assertFunction("quarter(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, (long)WEIRD_TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getYear());
        this.assertFunction("timezone_minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 9L);
        this.assertFunction("timezone_hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("millisecond(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getLong(ChronoField.MILLI_OF_SECOND));
        this.assertFunction("second(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getSecond());
        this.assertFunction("minute(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getMinute());
        this.assertFunction("hour(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getHour());
        this.assertFunction("millisecond(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getLong(ChronoField.MILLI_OF_SECOND));
        this.assertFunction("second(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getSecond());
        this.assertFunction("minute(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getMinute());
        this.assertFunction("hour(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getHour());
        this.assertFunction("millisecond(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, (long)DAY_TO_SECOND_INTERVAL.getNano() / 1000000L);
        this.assertFunction("second(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, DAY_TO_SECOND_INTERVAL.getSeconds() % 60L);
        this.assertFunction("minute(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, DAY_TO_SECOND_INTERVAL.getSeconds() / 60L % 60L);
        this.assertFunction("hour(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, DAY_TO_SECOND_INTERVAL.getSeconds() / 3600L % 24L);
    }

    @Test
    public void testYearOfWeek() {
        this.assertFunction("year_of_week(DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("yow(DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("year_of_week(DATE '2005-01-02')", (Type)BigintType.BIGINT, 2004L);
        this.assertFunction("year_of_week(DATE '2008-12-28')", (Type)BigintType.BIGINT, 2008L);
        this.assertFunction("year_of_week(DATE '2008-12-29')", (Type)BigintType.BIGINT, 2009L);
        this.assertFunction("year_of_week(DATE '2009-12-31')", (Type)BigintType.BIGINT, 2009L);
        this.assertFunction("year_of_week(DATE '2010-01-03')", (Type)BigintType.BIGINT, 2009L);
        this.assertFunction("year_of_week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("year_of_week(TIMESTAMP '2010-01-03 03:04:05.321')", (Type)BigintType.BIGINT, 2009L);
    }

    @Test
    public void testLastDayOfMonth() {
        this.assertFunction("last_day_of_month(DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.withDayOfMonth(31)));
        this.assertFunction("last_day_of_month(DATE '2019-08-01')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(DATE '2019-08-31')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.withDayOfMonth(31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 00:00:00.000')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 17:00:00.000')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 23:59:59.999')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-31 23:59:59.999')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.withDayOfMonth(31)));
        ImmutableList.of((Object)"+05:45", (Object)"+00:00", (Object)"-05:45", (Object)"Asia/Tokyo", (Object)"Europe/London", (Object)"America/Los_Angeles", (Object)"America/Bahia_Banderas").forEach(timeZone -> {
            this.assertFunction("last_day_of_month(TIMESTAMP '2018-12-31 17:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2018, 12, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2018-12-31 20:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2018, 12, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2018-12-31 23:59:59.999 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2018, 12, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 00:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 00:00:00.001 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 03:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 06:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 00:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 17:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 23:59:59.999 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-31 23:59:59.999 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(LocalDate.of(2019, 8, 31)));
        });
    }

    @Test
    public void testExtractFromTimestamp() {
        this.assertFunction("extract(second FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getSecondOfMinute());
        this.assertFunction("extract(minute FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getMinuteOfHour());
        this.assertFunction("extract(hour FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getHourOfDay());
        this.assertFunction("extract(day_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(dow FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(day FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_month FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_year FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(year_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(doy FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(week FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getWeekOfWeekyear());
        this.assertFunction("extract(month FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getMonthOfYear());
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, (long)this.TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("extract(year FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, this.TIMESTAMP.getYear());
        this.assertFunction("extract(second FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getSecondOfMinute());
        this.assertFunction("extract(minute FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("extract(hour FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("extract(day_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(dow FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(day FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_month FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_year FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(doy FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(week FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getWeekOfWeekyear());
        this.assertFunction("extract(month FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMonthOfYear());
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, (long)WEIRD_TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("extract(year FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getYear());
        this.assertFunction("extract(timezone_minute FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 9L);
        this.assertFunction("extract(timezone_hour FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 7L);
    }

    @Test
    public void testExtractFromTime() {
        this.assertFunction("extract(second FROM TIME '03:04:05.321')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(minute FROM TIME '03:04:05.321')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(hour FROM TIME '03:04:05.321')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(second FROM TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(minute FROM TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(hour FROM TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 3L);
    }

    @Test
    public void testExtractFromDate() {
        this.assertFunction("extract(day_of_week FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(dow FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(day FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 22L);
        this.assertFunction("extract(day_of_month FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 22L);
        this.assertFunction("extract(day_of_year FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 234L);
        this.assertFunction("extract(doy FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 234L);
        this.assertFunction("extract(year_of_week FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(yow FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(week FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 34L);
        this.assertFunction("extract(month FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 8L);
        this.assertFunction("extract(quarter FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(year FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(quarter FROM DATE '2001-01-01')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM DATE '2001-03-31')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM DATE '2001-04-01')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM DATE '2001-06-30')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM DATE '2001-07-01')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM DATE '2001-09-30')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM DATE '2001-10-01')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM DATE '2001-12-31')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-01-01 00:00:00.000')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-03-31 23:59:59.999')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-04-01 00:00:00.000')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-06-30 23:59:59.999')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-07-01 00:00:00.000')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-09-30 23:59:59.999')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-10-01 00:00:00.000')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-12-31 23:59:59.999')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-01-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-03-31 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-04-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-06-30 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-07-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-09-30 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-10-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-12-31 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 4L);
    }

    @Test
    public void testExtractFromInterval() {
        this.assertFunction("extract(second FROM INTERVAL '5' SECOND)", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(second FROM INTERVAL '65' SECOND)", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(minute FROM INTERVAL '4' MINUTE)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(minute FROM INTERVAL '64' MINUTE)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(minute FROM INTERVAL '247' SECOND)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(hour FROM INTERVAL '3' HOUR)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(hour FROM INTERVAL '27' HOUR)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(hour FROM INTERVAL '187' MINUTE)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(day FROM INTERVAL '2' DAY)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(day FROM INTERVAL '55' HOUR)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(month FROM INTERVAL '3' MONTH)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(month FROM INTERVAL '15' MONTH)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(year FROM INTERVAL '2' YEAR)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(year FROM INTERVAL '29' MONTH)", (Type)BigintType.BIGINT, 2L);
    }

    @Test
    public void testTruncateTimestamp() {
        DateTime result = this.TIMESTAMP;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withHourOfDay(0);
        this.assertFunction("date_trunc('day', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)result, (Session)this.session));
        result = WEIRD_TIMESTAMP;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withHourOfDay(0);
        this.assertFunction("date_trunc('day', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(result));
    }

    @Test
    public void testTruncateTime() {
        LocalTime result = TIME;
        result = result.withNano(0);
        this.assertFunction("date_trunc('second', TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(result));
        result = result.withSecond(0);
        this.assertFunction("date_trunc('minute', TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(result));
        result = result.withMinute(0);
        this.assertFunction("date_trunc('hour', TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(result));
    }

    @Test
    public void testTruncateTimeWithTimeZone() {
        OffsetTime result = WEIRD_TIME;
        result = result.withNano(0);
        this.assertFunction("date_trunc('second', TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(result));
        result = result.withSecond(0);
        this.assertFunction("date_trunc('minute', TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(result));
        result = result.withMinute(0);
        this.assertFunction("date_trunc('hour', TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(result));
    }

    @Test
    public void testTruncateDate() {
        DateTime result = DATE;
        this.assertFunction("date_trunc('day', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(result));
    }

    @Test
    public void testAddFieldToTimestamp() {
        this.assertFunction("date_add('millisecond', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusMillis(3), (Session)this.session));
        this.assertFunction("date_add('second', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusSeconds(3), (Session)this.session));
        this.assertFunction("date_add('minute', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusMinutes(3), (Session)this.session));
        this.assertFunction("date_add('hour', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusHours(3), (Session)this.session));
        this.assertFunction("date_add('hour', 23, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusHours(23), (Session)this.session));
        this.assertFunction("date_add('hour', -4, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.minusHours(4), (Session)this.session));
        this.assertFunction("date_add('hour', -23, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.minusHours(23), (Session)this.session));
        this.assertFunction("date_add('day', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusDays(3), (Session)this.session));
        this.assertFunction("date_add('week', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusWeeks(3), (Session)this.session));
        this.assertFunction("date_add('month', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusMonths(3), (Session)this.session));
        this.assertFunction("date_add('quarter', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusMonths(9), (Session)this.session));
        this.assertFunction("date_add('year', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((DateTime)this.TIMESTAMP.plusYears(3), (Session)this.session));
        this.assertFunction("date_add('millisecond', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMillis(3)));
        this.assertFunction("date_add('second', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusHours(3)));
        this.assertFunction("date_add('day', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusDays(3)));
        this.assertFunction("date_add('week', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMonths(9)));
        this.assertFunction("date_add('year', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusYears(3)));
    }

    @Test
    public void testAddFieldToDate() {
        this.assertFunction("date_add('day', 0, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE));
        this.assertFunction("date_add('day', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.plusDays(3)));
        this.assertFunction("date_add('week', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.plusMonths(9)));
        this.assertFunction("date_add('year', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctionsBase.toDate(DATE.plusYears(3)));
    }

    @Test
    public void testAddFieldToTime() {
        this.assertFunction("date_add('millisecond', 0, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME));
        this.assertFunction("date_add('millisecond', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.plusNanos(3000000L)));
        this.assertFunction("date_add('second', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.plusSeconds(3L)));
        this.assertFunction("date_add('minute', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.plusMinutes(3L)));
        this.assertFunction("date_add('hour', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.plusHours(3L)));
        this.assertFunction("date_add('hour', 23, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.plusHours(23L)));
        this.assertFunction("date_add('hour', -4, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.minusHours(4L)));
        this.assertFunction("date_add('hour', -23, TIME '03:04:05.321')", (Type)TimeType.TIME, this.toTime(TIME.minusHours(23L)));
    }

    @Test
    public void testAddFieldToTimeWithTimeZone() {
        this.assertFunction("date_add('millisecond', 3, TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(WEIRD_TIME.plusNanos(3000000L)));
        this.assertFunction("date_add('second', 3, TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(WEIRD_TIME.plusSeconds(3L)));
        this.assertFunction("date_add('minute', 3, TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(WEIRD_TIME.plusMinutes(3L)));
        this.assertFunction("date_add('hour', 3, TIME '03:04:05.321 +07:09')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimeWithTimeZone(WEIRD_TIME.plusHours(3L)));
    }

    @Test
    public void testDateDiffTimestamp() {
        DateTime baseDateTime = new DateTime(1960, 5, 3, 7, 2, 9, 678, SystemSessionProperties.isLegacyTimestamp((Session)this.session) ? DATE_TIME_ZONE : UTC_TIME_ZONE);
        String baseDateTimeLiteral = "TIMESTAMP '1960-05-03 07:02:09.678'";
        this.assertFunction("date_diff('millisecond', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.millisBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP));
        this.assertFunction("date_diff('second', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.secondsBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getSeconds());
        this.assertFunction("date_diff('minute', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.minutesBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getMinutes());
        this.assertFunction("date_diff('hour', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.hoursBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getHours());
        this.assertFunction("date_diff('day', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Days.daysBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getDays());
        this.assertFunction("date_diff('week', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Weeks.weeksBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getWeeks());
        this.assertFunction("date_diff('month', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getMonths());
        this.assertFunction("date_diff('quarter', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, (long)Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getMonths() / 3L);
        this.assertFunction("date_diff('year', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Years.yearsBetween((ReadableInstant)baseDateTime, (ReadableInstant)this.TIMESTAMP).getYears());
        DateTime weirdBaseDateTime = new DateTime(1960, 5, 3, 7, 2, 9, 678, WEIRD_DATE_TIME_ZONE);
        String weirdBaseDateTimeLiteral = "TIMESTAMP '1960-05-03 07:02:09.678 +07:09'";
        this.assertFunction("date_diff('millisecond', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.millisBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP));
        this.assertFunction("date_diff('second', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.secondsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getSeconds());
        this.assertFunction("date_diff('minute', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.minutesBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMinutes());
        this.assertFunction("date_diff('hour', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.hoursBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getHours());
        this.assertFunction("date_diff('day', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Days.daysBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getDays());
        this.assertFunction("date_diff('week', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Weeks.weeksBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getWeeks());
        this.assertFunction("date_diff('month', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Months.monthsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMonths());
        this.assertFunction("date_diff('quarter', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, (long)Months.monthsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMonths() / 3L);
        this.assertFunction("date_diff('year', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", (Type)BigintType.BIGINT, Years.yearsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getYears());
    }

    @Test
    public void testDateDiffDate() {
        DateTime baseDateTime = new DateTime(1960, 5, 3, 0, 0, 0, 0, DateTimeZone.UTC);
        String baseDateTimeLiteral = "DATE '1960-05-03'";
        this.assertFunction("date_diff('day', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", (Type)BigintType.BIGINT, Days.daysBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getDays());
        this.assertFunction("date_diff('week', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", (Type)BigintType.BIGINT, Weeks.weeksBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getWeeks());
        this.assertFunction("date_diff('month', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", (Type)BigintType.BIGINT, Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getMonths());
        this.assertFunction("date_diff('quarter', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", (Type)BigintType.BIGINT, (long)Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getMonths() / 3L);
        this.assertFunction("date_diff('year', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", (Type)BigintType.BIGINT, Years.yearsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getYears());
    }

    @Test
    public void testDateDiffTime() {
        LocalTime baseDateTime = LocalTime.of(7, 2, 9, 678000000);
        String baseDateTimeLiteral = "TIME '07:02:09.678'";
        this.assertFunction("date_diff('millisecond', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.millisBetween(baseDateTime, TIME));
        this.assertFunction("date_diff('second', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.secondsBetween(baseDateTime, TIME));
        this.assertFunction("date_diff('minute', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.minutesBetween(baseDateTime, TIME));
        this.assertFunction("date_diff('hour', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.hoursBetween(baseDateTime, TIME));
    }

    @Test
    public void testDateDiffTimeWithTimeZone() {
        OffsetTime weirdBaseDateTime = OffsetTime.of(7, 2, 9, 678000000, WEIRD_ZONE);
        String weirdBaseDateTimeLiteral = "TIME '07:02:09.678 +07:09'";
        this.assertFunction("date_diff('millisecond', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.millisBetween(weirdBaseDateTime, WEIRD_TIME));
        this.assertFunction("date_diff('second', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.secondsBetween(weirdBaseDateTime, WEIRD_TIME));
        this.assertFunction("date_diff('minute', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.minutesBetween(weirdBaseDateTime, WEIRD_TIME));
        this.assertFunction("date_diff('hour', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", (Type)BigintType.BIGINT, TestDateTimeFunctionsBase.hoursBetween(weirdBaseDateTime, WEIRD_TIME));
    }

    @Test
    public void testParseDatetime() {
        this.assertFunction("parse_datetime('1960/01/22 03:04', 'YYYY/MM/DD HH:mm')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("parse_datetime('1960/01/22 03:04 Asia/Oral', 'YYYY/MM/DD HH:mm ZZZZZ')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DateTimeZone.forID((String)"Asia/Oral"))));
        this.assertFunction("parse_datetime('1960/01/22 03:04 +0500', 'YYYY/MM/DD HH:mm Z')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DateTimeZone.forOffsetHours((int)5))));
    }

    @Test
    public void testFormatDatetime() {
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321', 'YYYY/MM/dd HH:mm')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09', 'YYYY/MM/dd HH:mm')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09', 'YYYY/MM/dd HH:mm ZZZZ')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04 +07:09");
    }

    @Test
    public void testDateFormat() {
        String dateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321'";
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%a')", (Type)VarcharType.VARCHAR, "Tue");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%b')", (Type)VarcharType.VARCHAR, "Jan");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%c')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%d')", (Type)VarcharType.VARCHAR, "09");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%e')", (Type)VarcharType.VARCHAR, "9");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%f')", (Type)VarcharType.VARCHAR, "321000");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%H')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%h')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%I')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%i')", (Type)VarcharType.VARCHAR, "04");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%j')", (Type)VarcharType.VARCHAR, "009");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%k')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%l')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%M')", (Type)VarcharType.VARCHAR, "January");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%m')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%p')", (Type)VarcharType.VARCHAR, "PM");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%r')", (Type)VarcharType.VARCHAR, "01:04:05 PM");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%S')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%s')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%T')", (Type)VarcharType.VARCHAR, "13:04:05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%v')", (Type)VarcharType.VARCHAR, "02");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%W')", (Type)VarcharType.VARCHAR, "Tuesday");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%Y')", (Type)VarcharType.VARCHAR, "2001");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%y')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%%')", (Type)VarcharType.VARCHAR, "%");
        this.assertFunction("date_format(" + dateTimeLiteral + ", 'foo')", (Type)VarcharType.VARCHAR, "foo");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%g')", (Type)VarcharType.VARCHAR, "g");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%4')", (Type)VarcharType.VARCHAR, "4");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%x %v')", (Type)VarcharType.VARCHAR, "2001 02");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%Y\u5e74%m\u6708%d\u65e5')", (Type)VarcharType.VARCHAR, "2001\u5e7401\u670809\u65e5");
        String weirdDateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'";
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%a')", (Type)VarcharType.VARCHAR, "Tue");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%b')", (Type)VarcharType.VARCHAR, "Jan");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%c')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%d')", (Type)VarcharType.VARCHAR, "09");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%e')", (Type)VarcharType.VARCHAR, "9");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%f')", (Type)VarcharType.VARCHAR, "321000");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%H')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%h')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%I')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%i')", (Type)VarcharType.VARCHAR, "04");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%j')", (Type)VarcharType.VARCHAR, "009");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%k')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%l')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%M')", (Type)VarcharType.VARCHAR, "January");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%m')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%p')", (Type)VarcharType.VARCHAR, "PM");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%r')", (Type)VarcharType.VARCHAR, "01:04:05 PM");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%S')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%s')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%T')", (Type)VarcharType.VARCHAR, "13:04:05");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%v')", (Type)VarcharType.VARCHAR, "02");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%W')", (Type)VarcharType.VARCHAR, "Tuesday");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%Y')", (Type)VarcharType.VARCHAR, "2001");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%y')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%%')", (Type)VarcharType.VARCHAR, "%");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", 'foo')", (Type)VarcharType.VARCHAR, "foo");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%g')", (Type)VarcharType.VARCHAR, "g");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%4')", (Type)VarcharType.VARCHAR, "4");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%x %v')", (Type)VarcharType.VARCHAR, "2001 02");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%Y\u5e74%m\u6708%d\u65e5')", (Type)VarcharType.VARCHAR, "2001\u5e7401\u670809\u65e5");
        this.assertFunction("date_format(TIMESTAMP '2001-01-09 13:04:05.32', '%f')", (Type)VarcharType.VARCHAR, "320000");
        this.assertFunction("date_format(TIMESTAMP '2001-01-09 00:04:05.32', '%k')", (Type)VarcharType.VARCHAR, "0");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%D')", "%D not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%U')", "%U not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%u')", "%u not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%V')", "%V not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%w')", "%w not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%X')", "%X not supported in date format string");
    }

    @Test
    public void testDateParse() {
        this.assertFunction("date_parse('2013', '%Y')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05', '%Y-%m')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)1, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05-17', '%Y-%m-%d')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05-17 12:35:10', '%Y-%m-%d %h:%i:%s')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05-17 12:35:10 PM', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)12, (int)35, (int)10, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05-17 12:35:10 AM', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05-17 00:35:10', '%Y-%m-%d %H:%i:%s')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013-05-17 23:35:10', '%Y-%m-%d %H:%i:%s')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)23, (int)35, (int)10, (int)0, (Session)this.session));
        this.assertFunction("date_parse('abc 2013-05-17 fff 23:35:10 xyz', 'abc %Y-%m-%d fff %H:%i:%s xyz')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)23, (int)35, (int)10, (int)0, (Session)this.session));
        this.assertFunction("date_parse('2013 14', '%Y %y')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2014, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("date_parse('1998 53', '%x %v')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1998, (int)12, (int)28, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("date_parse('1.1', '%s.%f')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)100, (Session)this.session));
        this.assertFunction("date_parse('1.01', '%s.%f')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)10, (Session)this.session));
        this.assertFunction("date_parse('1.2006', '%s.%f')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)200, (Session)this.session));
        this.assertFunction("date_parse('59.123456789', '%s.%f')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)59, (int)123, (Session)this.session));
        this.assertFunction("date_parse('0', '%k')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("date_parse('28-JAN-16 11.45.46.421000 PM','%d-%b-%y %l.%i.%s.%f %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2016, (int)1, (int)28, (int)23, (int)45, (int)46, (int)421, (Session)this.session));
        this.assertFunction("date_parse('11-DEC-70 11.12.13.456000 AM','%d-%b-%y %l.%i.%s.%f %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)12, (int)11, (int)11, (int)12, (int)13, (int)456, (Session)this.session));
        this.assertFunction("date_parse('31-MAY-69 04.59.59.999000 AM','%d-%b-%y %l.%i.%s.%f %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2069, (int)5, (int)31, (int)4, (int)59, (int)59, (int)999, (Session)this.session));
        this.assertInvalidFunction("date_parse('', '%D')", "%D not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%U')", "%U not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%u')", "%u not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%V')", "%V not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%w')", "%w not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%X')", "%X not supported in date format string");
        this.assertInvalidFunction("date_parse('3.0123456789', '%s.%f')", "Invalid format: \"3.0123456789\" is malformed at \"9\"");
        this.assertInvalidFunction("date_parse('%Y-%m-%d', '')", "Both printing and parsing not supported");
    }

    @Test
    public void testLocale() {
        Locale locale = Locale.KOREAN;
        Session localeSession = Session.builder((Session)this.session).setTimeZoneKey(TIME_ZONE_KEY).setLocale(locale).build();
        try (FunctionAssertions localeAssertions = new FunctionAssertions(localeSession);){
            String dateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321'";
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%a')", (Type)VarcharType.VARCHAR, "\ud654");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%W')", (Type)VarcharType.VARCHAR, "\ud654\uc694\uc77c");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%p')", (Type)VarcharType.VARCHAR, "\uc624\ud6c4");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%r')", (Type)VarcharType.VARCHAR, "01:04:05 \uc624\ud6c4");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%b')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%M')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'EEE')", (Type)VarcharType.VARCHAR, "\ud654");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'EEEE')", (Type)VarcharType.VARCHAR, "\ud654\uc694\uc77c");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'a')", (Type)VarcharType.VARCHAR, "\uc624\ud6c4");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'MMM')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'MMMM')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("date_parse('2013-05-17 12:35:10 \uc624\ud6c4', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)12, (int)35, (int)10, (int)0, (Session)localeSession));
            localeAssertions.assertFunction("date_parse('2013-05-17 12:35:10 \uc624\uc804', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0, (Session)localeSession));
            localeAssertions.assertFunction("parse_datetime('2013-05-17 12:35:10 \uc624\ud6c4', 'yyyy-MM-dd hh:mm:ss a')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(new DateTime(2013, 5, 17, 12, 35, 10, 0, DATE_TIME_ZONE)));
            localeAssertions.assertFunction("parse_datetime('2013-05-17 12:35:10 \uc624\uc804', 'yyyy-MM-dd hh:mm:ss aaa')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctionsBase.toTimestampWithTimeZone(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE)));
        }
    }

    @Test
    public void testDateTimeOutputString() {
        this.assertFunctionString("date '2012-12-31'", (Type)DateType.DATE, "2012-12-31");
        this.assertFunctionString("date '0000-12-31'", (Type)DateType.DATE, "0000-12-31");
        this.assertFunctionString("date '0000-09-23'", (Type)DateType.DATE, "0000-09-23");
        this.assertFunctionString("date '0001-10-25'", (Type)DateType.DATE, "0001-10-25");
        this.assertFunctionString("date '1560-04-29'", (Type)DateType.DATE, "1560-04-29");
        this.assertFunctionString("time '00:00:00'", (Type)TimeType.TIME, "00:00:00.000");
        this.assertFunctionString("time '01:02:03'", (Type)TimeType.TIME, "01:02:03.000");
        this.assertFunctionString("time '23:23:23.233'", (Type)TimeType.TIME, "23:23:23.233");
        this.assertFunctionString("time '23:59:59.999'", (Type)TimeType.TIME, "23:59:59.999");
        this.assertFunctionString("time '00:00:00 UTC'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "00:00:00.000 UTC");
        this.assertFunctionString("time '01:02:03 Asia/Shanghai'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "01:02:03.000 Asia/Shanghai");
        this.assertFunctionString("time '23:23:23.233 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "23:23:23.233 America/Los_Angeles");
        this.assertFunctionString(WEIRD_TIME_LITERAL, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "03:04:05.321 +07:09");
        this.assertFunctionString("time '23:59:59.999 Asia/Kathmandu'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "23:59:59.999 Asia/Kathmandu");
        this.assertFunctionString("timestamp '0000-01-02 01:02:03'", (Type)TimestampType.TIMESTAMP, "0000-01-02 01:02:03.000");
        this.assertFunctionString("timestamp '2012-12-31 00:00:00'", (Type)TimestampType.TIMESTAMP, "2012-12-31 00:00:00.000");
        this.assertFunctionString("timestamp '1234-05-06 23:23:23.233'", (Type)TimestampType.TIMESTAMP, "1234-05-06 23:23:23.233");
        this.assertFunctionString("timestamp '2012-12-31 00:00:00 UTC'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2012-12-31 00:00:00.000 UTC");
        this.assertFunctionString("timestamp '0000-01-02 01:02:03 Asia/Shanghai'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "0000-01-02 01:02:03.000 Asia/Shanghai");
        this.assertFunctionString("timestamp '1234-05-06 23:23:23.233 America/Los_Angeles'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "1234-05-06 23:23:23.233 America/Los_Angeles");
        this.assertFunctionString("timestamp '2333-02-23 23:59:59.999 Asia/Tokyo'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2333-02-23 23:59:59.999 Asia/Tokyo");
    }

    @Test
    public void testTimeWithTimeZoneAtTimeZone() {
        Session oldKathmanduTimeZoneOffsetSession = Session.builder((Session)this.session).setTimeZoneKey(TIME_ZONE_KEY).setStartTime(new DateTime(1980, 1, 1, 10, 0, 0, DATE_TIME_ZONE).getMillis()).build();
        TimeZoneKey europeWarsawTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw");
        DateTimeZone europeWarsawTimeZone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)europeWarsawTimeZoneKey);
        Session europeWarsawSessionWinter = Session.builder((Session)this.session).setTimeZoneKey(europeWarsawTimeZoneKey).setStartTime(new DateTime(2017, 1, 1, 10, 0, 0, europeWarsawTimeZone).getMillis()).build();
        try (FunctionAssertions europeWarsawAssertionsWinter = new FunctionAssertions(europeWarsawSessionWinter);
             FunctionAssertions oldKathmanduTimeZoneOffsetAssertions = new FunctionAssertions(oldKathmanduTimeZoneOffsetSession);){
            long millisTenOClockWarsawWinter = new DateTime(1970, 1, 1, 9, 0, 0, 0, UTC_TIME_ZONE).getMillis();
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '10:00 Europe/Warsaw', 'UTC')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(millisTenOClockWarsawWinter, TimeZoneKey.UTC_KEY));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '10:00 Europe/Warsaw', '+00:45')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(millisTenOClockWarsawWinter, TimeZoneKey.getTimeZoneKey((String)"+00:45")));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '10:00 Europe/Warsaw', 'America/New_York')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(millisTenOClockWarsawWinter, TimeZoneKey.getTimeZoneKey((String)"America/New_York")));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '10:00 Europe/Warsaw', 'Europe/Berlin')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(millisTenOClockWarsawWinter, TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")));
            this.assertFunction("at_timezone(TIME '10:00 UTC', 'UTC')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 10, 0, 0, 0, UTC_TIME_ZONE).getMillis(), TimeZoneKey.UTC_KEY));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '10:00 Europe/Warsaw', 'Europe/Warsaw')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(millisTenOClockWarsawWinter, europeWarsawTimeZoneKey));
            this.assertFunction("at_timezone(TIME '10:00 Europe/Warsaw', 'Europe/Warsaw')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(millisTenOClockWarsawWinter, europeWarsawTimeZoneKey));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '2:00 Europe/Warsaw', 'America/New_York')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 20, 0, 0, 0, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/New_York"))).getMillis(), TimeZoneKey.getTimeZoneKey((String)"America/New_York")));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '22:00 America/New_York', 'Europe/Warsaw')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 4, 0, 0, 0, europeWarsawTimeZone).getMillis(), europeWarsawTimeZoneKey));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '00:00 +14:00', '+13:00')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 23, 0, 0, 0, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"+13:00"))).getMillis(), TimeZoneKey.getTimeZoneKey((String)"+13:00")));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '00:00 +14:00', '-14:00')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 20, 0, 0, 0, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"-14:00"))).getMillis(), TimeZoneKey.getTimeZoneKey((String)"-14:00")));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '23:59:59.999 +14:00', '+13:00')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 22, 59, 59, 999, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"+13:00"))).getMillis(), TimeZoneKey.getTimeZoneKey((String)"+13:00")));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '23:59:59.999 +14:00', '-14:00')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 19, 59, 59, 999, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"-14:00"))).getMillis(), TimeZoneKey.getTimeZoneKey((String)"-14:00")));
            this.assertFunction("at_timezone(TIME '10:00 Asia/Kathmandu', 'UTC')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 4, 15, 0, 0, UTC_TIME_ZONE).getMillis(), TimeZoneKey.UTC_KEY));
            TimeZoneKey kabul = TimeZoneKey.getTimeZoneKey((String)"Asia/Kabul");
            this.assertFunction("at_timezone(TIME '10:00 Asia/Kabul', 'Asia/Kabul')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 10, 0, 0, 0, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)kabul)).getMillis(), kabul));
            oldKathmanduTimeZoneOffsetAssertions.assertFunction("at_timezone(TIME '10:00 Asia/Kathmandu', 'UTC')", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 4, 30, 0, 0, UTC_TIME_ZONE).getMillis(), TimeZoneKey.UTC_KEY));
            europeWarsawAssertionsWinter.assertFunction("at_timezone(TIME '10:00 +01:00', INTERVAL '2' HOUR)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 11, 0, 0, 0, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"+02:00"))).getMillis(), TimeZoneKey.getTimeZoneKey((String)"+02:00")));
            europeWarsawAssertionsWinter.assertInvalidFunction("at_timezone(TIME '10:00 +01:00', INTERVAL '60' HOUR)", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid offset minutes 3600");
        }
    }

    @Test
    public void testParseDuration() {
        this.assertFunction("parse_duration('1234 ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234 us')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 1));
        this.assertFunction("parse_duration('1234 ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 234));
        this.assertFunction("parse_duration('1234 s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 20, 34, 0));
        this.assertFunction("parse_duration('1234 m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 0, 0));
        this.assertFunction("parse_duration('1234 h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 0, 0, 0));
        this.assertFunction("parse_duration('1234 d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567 ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567 ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 235));
        this.assertFunction("parse_duration('1234.567 s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1234, 567));
        this.assertFunction("parse_duration('1234.567 m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 34, 20));
        this.assertFunction("parse_duration('1234.567 h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 34, 1, 200));
        this.assertFunction("parse_duration('1234.567 d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 13, 36, 28, 800));
        this.assertFunction("parse_duration('1234ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234us')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 1));
        this.assertFunction("parse_duration('1234ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 234));
        this.assertFunction("parse_duration('1234s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 20, 34, 0));
        this.assertFunction("parse_duration('1234m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 0, 0));
        this.assertFunction("parse_duration('1234h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 0, 0, 0));
        this.assertFunction("parse_duration('1234d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 235));
        this.assertFunction("parse_duration('1234.567s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1234, 567));
        this.assertFunction("parse_duration('1234.567m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 34, 20));
        this.assertFunction("parse_duration('1234.567h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 34, 1, 200));
        this.assertFunction("parse_duration('1234.567d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 13, 36, 28, 800));
        this.assertInvalidFunction("parse_duration('')", "duration is empty");
        this.assertInvalidFunction("parse_duration('1f')", "Unknown time unit: f");
        this.assertInvalidFunction("parse_duration('abc')", "duration is not a valid data duration string: abc");
    }

    @Test
    public void testIntervalDayToSecondToMilliseconds() {
        this.assertFunction("to_milliseconds(parse_duration('1ns'))", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("to_milliseconds(parse_duration('1ms'))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("to_milliseconds(parse_duration('1s'))", (Type)BigintType.BIGINT, TimeUnit.SECONDS.toMillis(1L));
        this.assertFunction("to_milliseconds(parse_duration('1h'))", (Type)BigintType.BIGINT, TimeUnit.HOURS.toMillis(1L));
        this.assertFunction("to_milliseconds(parse_duration('1d'))", (Type)BigintType.BIGINT, TimeUnit.DAYS.toMillis(1L));
    }

    private void assertFunctionString(String projection, Type expectedType, String expected) {
        this.functionAssertions.assertFunctionString(projection, expectedType, expected);
    }

    private static SqlDate toDate(LocalDate localDate) {
        return new SqlDate(Math.toIntExact(localDate.toEpochDay()));
    }

    private static SqlDate toDate(DateTime dateDate) {
        long millis = dateDate.getMillis();
        return new SqlDate(Math.toIntExact(TimeUnit.MILLISECONDS.toDays(millis)));
    }

    private static long millisBetween(ReadableInstant start, ReadableInstant end) {
        Objects.requireNonNull(start, "start is null");
        Objects.requireNonNull(end, "end is null");
        return DurationFieldType.millis().getField(DateTimeUtils.getInstantChronology((ReadableInstant)start)).getDifferenceAsLong(end.getMillis(), start.getMillis());
    }

    private static Seconds secondsBetween(ReadableInstant start, ReadableInstant end) {
        return Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    private static Minutes minutesBetween(ReadableInstant start, ReadableInstant end) {
        return Minutes.minutesBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    private static Hours hoursBetween(ReadableInstant start, ReadableInstant end) {
        return Hours.hoursBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    private static long millisBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toMillis(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long secondsBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toSeconds(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long minutesBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toMinutes(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long hoursBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toHours(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long millisBetween(OffsetTime start, OffsetTime end) {
        return TestDateTimeFunctionsBase.millisUtc(end) - TestDateTimeFunctionsBase.millisUtc(start);
    }

    private static long secondsBetween(OffsetTime start, OffsetTime end) {
        return TimeUnit.MILLISECONDS.toSeconds(TestDateTimeFunctionsBase.millisBetween(start, end));
    }

    private static long minutesBetween(OffsetTime start, OffsetTime end) {
        return TimeUnit.MILLISECONDS.toMinutes(TestDateTimeFunctionsBase.millisBetween(start, end));
    }

    private static long hoursBetween(OffsetTime start, OffsetTime end) {
        return TimeUnit.MILLISECONDS.toHours(TestDateTimeFunctionsBase.millisBetween(start, end));
    }

    private SqlTime toTime(LocalTime time) {
        return DateTimeTestingUtils.sqlTimeOf((LocalTime)time, (Session)this.session);
    }

    private static SqlTimeWithTimeZone toTimeWithTimeZone(OffsetTime offsetTime) {
        return new SqlTimeWithTimeZone(TestDateTimeFunctionsBase.millisUtc(offsetTime), TimeZoneKey.getTimeZoneKey((String)offsetTime.getOffset().getId()));
    }

    private static long millisUtc(OffsetTime offsetTime) {
        return offsetTime.atDate(LocalDate.ofEpochDay(0L)).toInstant().toEpochMilli();
    }

    private static SqlTimestampWithTimeZone toTimestampWithTimeZone(DateTime dateTime) {
        return new SqlTimestampWithTimeZone(dateTime.getMillis(), TimeZoneKey.getTimeZoneKey((String)dateTime.getZone().getID()));
    }
}

