/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.testng.annotations.Test;

public class TestMapNormalize
extends AbstractTestFunctions {
    @Test
    public void testMapNormalize() {
        this.assertFunction("map_normalize(map(array['w', 'x', 'y', 'z'], array[1, 1, 1, 1]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)"w", (Object)0.25, (Object)"x", (Object)0.25, (Object)"y", (Object)0.25, (Object)"z", (Object)0.25));
        this.assertFunction("map_normalize(map(array['w', 'x', 'y', 'z'], array[1.0, 2, 3.0, 4]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)"w", (Object)0.1, (Object)"x", (Object)0.2, (Object)"y", (Object)0.3, (Object)"z", (Object)0.4));
        this.assertFunction("map_normalize(map(array['w', 'x', 'y', 'z'], array[1, 2, -3, -4]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)"w", (Object)-0.25, (Object)"x", (Object)-0.5, (Object)"y", (Object)0.75, (Object)"z", (Object)1.0));
        HashMap<String, Double> expectedWithNull = new HashMap<String, Double>();
        expectedWithNull.put("w", 0.14285714285714285);
        expectedWithNull.put("x", 0.2857142857142857);
        expectedWithNull.put("y", null);
        expectedWithNull.put("z", 0.5714285714285714);
        this.assertFunction("map_normalize(map(array['w', 'x', 'y', 'z'], array[1, 2, null, 4.0]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), expectedWithNull);
        HashMap<String, Object> expectedNullOnly = new HashMap<String, Object>();
        expectedNullOnly.put("w", null);
        this.assertFunction("map_normalize(map(array['w'], array[null]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), expectedNullOnly);
        this.assertFunction("map_normalize(map(array[], array[]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), ImmutableMap.of());
        this.assertFunction("map_normalize(null)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE), null);
    }
}

