/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapTopNKeysFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3, (Object)2));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)-1, (Object)-2));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of((Object)"cd"));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 3)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)6, (int)2)), ImmutableList.of((Object)TestMapTopNKeysFunction.decimal("1000.99"), (Object)TestMapTopNKeysFunction.decimal("123.00"), (Object)TestMapTopNKeysFunction.decimal("99.50")));
    }

    @Test
    public void testNegativeN() {
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[100, 200, 300], ARRAY[4, 5, 6]), -3)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), -1)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY['a', 'b', 'c'], ARRAY[4, 5, 6]), -2)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
    }

    @Test
    public void testZeroN() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 0)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of());
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 0)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)6, (int)2)), ImmutableList.of());
    }

    @Test
    public void testEmpty() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[], ARRAY[]), 5)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("MAP_TOP_N_KEYS(NULL, 1)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
    }

    @Test
    public void testComplexKeys() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[ROW('x', 1), ROW('y', 2)], ARRAY[1, 2]), 1)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"y", (Object)2)));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[ROW('x', 1), ROW('x', -2)], ARRAY[1, 2]), 1)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)1)));
    }
}

