/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.FileBasedSystemAccessControl;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.testing.InterfaceTestUtils;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.ResourceFileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileBasedSystemAccessControl {
    private static final Identity alice = new Identity("alice", Optional.empty());
    private static final Identity kerberosValidAlice = new Identity("alice", Optional.of(new KerberosPrincipal("alice/example.com@EXAMPLE.COM")));
    private static final Identity kerberosValidNonAsciiUser = new Identity("\u0194\u0194\u0194", Optional.of(new KerberosPrincipal("\u0194\u0194\u0194/example.com@EXAMPLE.COM")));
    private static final Identity kerberosInvalidAlice = new Identity("alice", Optional.of(new KerberosPrincipal("mallory/example.com@EXAMPLE.COM")));
    private static final Identity kerberosValidShare = new Identity("alice", Optional.of(new KerberosPrincipal("valid/example.com@EXAMPLE.COM")));
    private static final Identity kerberosInValidShare = new Identity("alice", Optional.of(new KerberosPrincipal("invalid/example.com@EXAMPLE.COM")));
    private static final Identity validSpecialRegexWildDot = new Identity(".*", Optional.of(new KerberosPrincipal("special/.*@EXAMPLE.COM")));
    private static final Identity validSpecialRegexEndQuote = new Identity("\\E", Optional.of(new KerberosPrincipal("special/\\E@EXAMPLE.COM")));
    private static final Identity invalidSpecialRegex = new Identity("alice", Optional.of(new KerberosPrincipal("special/.*@EXAMPLE.COM")));
    private static final Identity bob = new Identity("bob", Optional.empty());
    private static final Identity admin = new Identity("admin", Optional.empty());
    private static final Identity nonAsciiUser = new Identity("\u0194\u0194\u0194", Optional.empty());
    private static final Set<String> allCatalogs = ImmutableSet.of((Object)"secret", (Object)"open-to-all", (Object)"all-allowed", (Object)"alice-catalog", (Object)"\u0200\u0200\u0200");
    private static final QualifiedObjectName aliceTable = new QualifiedObjectName("alice-catalog", "schema", "table");
    private static final QualifiedObjectName aliceView = new QualifiedObjectName("alice-catalog", "schema", "view");
    private static final CatalogSchemaName aliceSchema = new CatalogSchemaName("alice-catalog", "schema");
    private static final AccessControlContext context = new AccessControlContext(new QueryId("query_id"), Optional.empty(), Optional.empty());

    @Test
    public void testCanSetUserOperations() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_principal.json");
        try {
            accessControlManager.checkCanSetUser(alice, context, Optional.empty(), alice.getUser());
            throw new AssertionError((Object)"expected AccessDeniedException");
        }
        catch (AccessDeniedException accessDeniedException) {
            accessControlManager.checkCanSetUser(kerberosValidAlice, context, kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
            accessControlManager.checkCanSetUser(kerberosValidNonAsciiUser, context, kerberosValidNonAsciiUser.getPrincipal(), kerberosValidNonAsciiUser.getUser());
            try {
                accessControlManager.checkCanSetUser(kerberosInvalidAlice, context, kerberosInvalidAlice.getPrincipal(), kerberosInvalidAlice.getUser());
                throw new AssertionError((Object)"expected AccessDeniedException");
            }
            catch (AccessDeniedException accessDeniedException2) {
                accessControlManager.checkCanSetUser(kerberosValidShare, context, kerberosValidShare.getPrincipal(), kerberosValidShare.getUser());
                try {
                    accessControlManager.checkCanSetUser(kerberosInValidShare, context, kerberosInValidShare.getPrincipal(), kerberosInValidShare.getUser());
                    throw new AssertionError((Object)"expected AccessDeniedException");
                }
                catch (AccessDeniedException accessDeniedException3) {
                    accessControlManager.checkCanSetUser(validSpecialRegexWildDot, context, validSpecialRegexWildDot.getPrincipal(), validSpecialRegexWildDot.getUser());
                    accessControlManager.checkCanSetUser(validSpecialRegexEndQuote, context, validSpecialRegexEndQuote.getPrincipal(), validSpecialRegexEndQuote.getUser());
                    try {
                        accessControlManager.checkCanSetUser(invalidSpecialRegex, context, invalidSpecialRegex.getPrincipal(), invalidSpecialRegex.getUser());
                        throw new AssertionError((Object)"expected AccessDeniedException");
                    }
                    catch (AccessDeniedException accessDeniedException4) {
                        TransactionManager transactionManagerNoPatterns = InMemoryTransactionManager.createTestTransactionManager();
                        AccessControlManager accessControlManagerNoPatterns = this.newAccessControlManager(transactionManager, "catalog.json");
                        accessControlManagerNoPatterns.checkCanSetUser(kerberosValidAlice, context, kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void testCatalogOperations() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(admin, context, allCatalogs), allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(alice, context, allCatalogs), (Set)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(bob, context, allCatalogs), (Set)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(nonAsciiUser, context, allCatalogs), (Set)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testCatalogOperationsReadOnly() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(admin, context, allCatalogs), allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(alice, context, allCatalogs), (Set)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(bob, context, allCatalogs), (Set)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(nonAsciiUser, context, allCatalogs), (Set)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testSchemaOperations() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, alice, context, "alice-catalog", (Set)aliceSchemas), (Set)aliceSchemas);
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, bob, context, "alice-catalog", (Set)aliceSchemas), (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateSchema(transactionId, alice, context, aliceSchema);
            accessControlManager.checkCanDropSchema(transactionId, alice, context, aliceSchema);
            accessControlManager.checkCanRenameSchema(transactionId, alice, context, aliceSchema, "new-schema");
            accessControlManager.checkCanShowSchemas(transactionId, alice, context, "alice-catalog");
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, bob, context, aliceSchema)));
    }

    @Test
    public void testSchemaRulesForCheckCanCreateSchema() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "file-based-system-access-schema.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateSchema(transactionId, bob, context, new CatalogSchemaName("alice-catalog", "bob"));
            accessControlManager.checkCanCreateSchema(transactionId, bob, context, new CatalogSchemaName("bob-catalog", "bob"));
            accessControlManager.checkCanCreateSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "some-schema"));
            accessControlManager.checkCanCreateSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "bob"));
            accessControlManager.checkCanCreateSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "alice"));
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, bob, context, new CatalogSchemaName("alice-catalog", "alice"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, bob, context, new CatalogSchemaName("bob-catalog", "alice"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, bob, context, new CatalogSchemaName("secret-catalog", "secret"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, alice, context, new CatalogSchemaName("secret-catalog", "secret"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, admin, context, new CatalogSchemaName("secret-catalog", "secret"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, alice, context, new CatalogSchemaName("alice-catalog", "alice"))));
    }

    @Test
    public void testSchemaRulesForCheckCanDropSchema() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "file-based-system-access-schema.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanDropSchema(transactionId, bob, context, new CatalogSchemaName("alice-catalog", "bob"));
            accessControlManager.checkCanDropSchema(transactionId, bob, context, new CatalogSchemaName("bob-catalog", "bob"));
            accessControlManager.checkCanDropSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "bob"));
            accessControlManager.checkCanDropSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "alice"));
            accessControlManager.checkCanDropSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "some-schema"));
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, bob, context, new CatalogSchemaName("alice-catalog", "alice"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, bob, context, new CatalogSchemaName("bob-catalog", "alice"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, bob, context, new CatalogSchemaName("secret-catalog", "secret"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, alice, context, new CatalogSchemaName("secret-catalog", "secret"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, admin, context, new CatalogSchemaName("secret-catalog", "secret"))));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, alice, context, new CatalogSchemaName("alice-catalog", "alice"))));
    }

    @Test
    public void testSchemaRulesForCheckCanRenameSchema() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "file-based-system-access-schema.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanRenameSchema(transactionId, bob, context, new CatalogSchemaName("alice-catalog", "bob"), "some-schema");
            accessControlManager.checkCanRenameSchema(transactionId, bob, context, new CatalogSchemaName("bob-catalog", "bob"), "some-schema");
            accessControlManager.checkCanRenameSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "bob"), "new-schema-name");
            accessControlManager.checkCanRenameSchema(transactionId, admin, context, new CatalogSchemaName("some-catalog", "alice"), "new-schema-name");
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, bob, context, new CatalogSchemaName("alice-catalog", "alice"), "new-schema-name")));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, bob, context, new CatalogSchemaName("bob-catalog", "alice"), "new-schema-name")));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, bob, context, new CatalogSchemaName("secret-catalog", "secret"), "new-schema-name")));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, alice, context, new CatalogSchemaName("secret-catalog", "secret"), "new-schema-name")));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, admin, context, new CatalogSchemaName("secret-catalog", "secret"), "new-schema-name")));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, alice, context, new CatalogSchemaName("alice-catalog", "alice"), "new-schema-name")));
    }

    @Test
    public void testSchemaOperationsReadOnly() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, alice, context, "alice-catalog", (Set)aliceSchemas), (Set)aliceSchemas);
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, bob, context, "alice-catalog", (Set)aliceSchemas), (Set)ImmutableSet.of());
            accessControlManager.checkCanShowSchemas(transactionId, alice, context, "alice-catalog");
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, alice, context, aliceSchema)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(transactionId, alice, context, aliceSchema)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(transactionId, alice, context, aliceSchema, "new-schema")));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, bob, context, aliceSchema)));
    }

    @Test
    public void testTableOperations() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, alice, context, "alice-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, bob, context, "alice-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateTable(transactionId, alice, context, aliceTable);
            accessControlManager.checkCanDropTable(transactionId, alice, context, aliceTable);
            accessControlManager.checkCanTruncateTable(transactionId, alice, context, aliceTable);
            accessControlManager.checkCanSelectFromColumns(transactionId, alice, context, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(transactionId, alice, context, aliceTable);
            accessControlManager.checkCanDeleteFromTable(transactionId, alice, context, aliceTable);
            accessControlManager.checkCanAddColumns(transactionId, alice, context, aliceTable);
            accessControlManager.checkCanRenameColumn(transactionId, alice, context, aliceTable);
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(transactionId, bob, context, aliceTable)));
    }

    @Test
    public void testTableOperationsReadOnly() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, alice, context, "alice-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, bob, context, "alice-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            accessControlManager.checkCanSelectFromColumns(transactionId, alice, context, aliceTable, (Set)ImmutableSet.of());
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropTable(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanTruncateTable(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDeleteFromTable(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanAddColumns(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameColumn(transactionId, alice, context, aliceTable)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(transactionId, bob, context, aliceTable)));
    }

    @Test
    public void testViewOperations() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView);
            accessControlManager.checkCanDropView(transactionId, alice, context, aliceView);
            accessControlManager.checkCanSelectFromColumns(transactionId, alice, context, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, alice, context, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, alice, context, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(transactionId, alice, context, "alice-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(transactionId, alice, context, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(transactionId, alice, context, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true);
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, bob, context, aliceView)));
    }

    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(SystemAccessControl.class, FileBasedSystemAccessControl.class);
    }

    @Test
    public void testViewOperationsReadOnly() throws IOException {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanSelectFromColumns(transactionId, alice, context, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(transactionId, alice, context, "alice-catalog", "property");
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropView(transactionId, alice, context, aliceView)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, alice, context, aliceTable, (Set)ImmutableSet.of())));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, alice, context, aliceView, (Set)ImmutableSet.of())));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanGrantTablePrivilege(transactionId, alice, context, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRevokeTablePrivilege(transactionId, alice, context, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true)));
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, bob, context, aliceView)));
    }

    @Test
    public void testRefreshing() throws Exception {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        File configFile = Files.newTemporaryFile();
        configFile.deleteOnExit();
        com.google.common.io.Files.copy((File)ResourceFileUtils.getResourceFile("catalog.json"), (File)configFile);
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)configFile.getAbsolutePath(), (Object)"security.refresh-period", (Object)"1ms"));
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView);
            accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView);
            accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView);
        });
        com.google.common.io.Files.copy((File)ResourceFileUtils.getResourceFile("security-config-file-with-unknown-rules.json"), (File)configFile);
        Thread.sleep(2L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
        com.google.common.io.Files.copy((File)ResourceFileUtils.getResourceFile("catalog.json"), (File)configFile);
        Thread.sleep(2L);
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, context, aliceView));
    }

    @Test
    public void testAllowModeIsRequired() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.newAccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), "catalog_allow_unset.json"));
    }

    @Test
    public void testAllowModeInvalidValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.newAccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), "catalog_invalid_allow_value.json"));
    }

    private AccessControlManager newAccessControlManager(TransactionManager transactionManager, String resourceName) throws IOException {
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)ResourceFileUtils.getResourceFile(resourceName).getAbsolutePath()));
        return accessControlManager;
    }

    @Test
    public void parseUnknownRules() throws IOException {
        Assertions.assertThatThrownBy(() -> this.parse("security-config-file-with-unknown-rules.json")).hasMessageContaining("Invalid JSON");
    }

    private SystemAccessControl parse(String path) throws IOException {
        return new FileBasedSystemAccessControl.Factory().create((Map)ImmutableMap.of((Object)"security.config-file", (Object)ResourceFileUtils.getResourceFile(path).getPath()));
    }
}

