/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroup;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryProgressStats;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryStateInfo {
    @Test
    public void testQueryStateInfo() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor(), ignored -> Optional.empty(), rg -> false, (InternalNodeManager)new InMemoryNodeManager());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a", true);
        rootA.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(0);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x", true);
        rootAX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(0);
        QueryStateInfo query = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(this.createQueryInfo("query_root_a_x", rootAX.getId(), QueryState.QUEUED, "SELECT 1")), Optional.of(ImmutableList.of((Object)rootAX.getInfo(), (Object)rootA.getInfo(), (Object)root.getInfo())), (boolean)false, (OptionalInt)OptionalInt.empty());
        Assert.assertEquals((String)query.getQuery(), (String)"SELECT 1");
        Assert.assertEquals((String)query.getQueryId().toString(), (String)"query_root_a_x");
        Assert.assertEquals((Object)query.getQueryState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query.getProgress(), Optional.empty());
        List chainInfo = (List)query.getPathToRoot().get();
        Assert.assertEquals((int)chainInfo.size(), (int)3);
        ResourceGroupInfo rootAInfo = (ResourceGroupInfo)chainInfo.get(1);
        ResourceGroupInfo expectedRootAInfo = rootA.getInfo();
        Assert.assertEquals((Object)rootAInfo.getId(), (Object)expectedRootAInfo.getId());
        Assert.assertEquals((Object)rootAInfo.getState(), (Object)expectedRootAInfo.getState());
        Assert.assertEquals((int)rootAInfo.getNumRunningQueries(), (int)expectedRootAInfo.getNumRunningQueries());
        Assert.assertEquals((int)rootAInfo.getNumQueuedQueries(), (int)expectedRootAInfo.getNumQueuedQueries());
        ResourceGroupInfo actualRootInfo = (ResourceGroupInfo)chainInfo.get(2);
        ResourceGroupInfo expectedRootInfo = root.getInfo();
        Assert.assertEquals((Object)actualRootInfo.getId(), (Object)expectedRootInfo.getId());
        Assert.assertEquals((Object)actualRootInfo.getState(), (Object)expectedRootInfo.getState());
        Assert.assertEquals((int)actualRootInfo.getNumRunningQueries(), (int)expectedRootInfo.getNumRunningQueries());
        Assert.assertEquals((int)actualRootInfo.getNumQueuedQueries(), (int)expectedRootInfo.getNumQueuedQueries());
    }

    @Test
    public void testQueryTextTruncation() {
        QueryInfo queryInfo = this.createQueryInfo("query_id_test", QueryState.RUNNING, "SELECT * FROM foo");
        QueryStateInfo queryStateInfoNoLimit = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(queryInfo), Optional.empty(), (boolean)false, (OptionalInt)OptionalInt.empty());
        Assert.assertFalse((boolean)queryStateInfoNoLimit.isQueryTruncated());
        Assert.assertEquals((String)queryStateInfoNoLimit.getQuery(), (String)queryInfo.getQuery());
        QueryStateInfo queryStateInfoLimitLower = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(queryInfo), Optional.empty(), (boolean)false, (OptionalInt)OptionalInt.of(5));
        Assert.assertTrue((boolean)queryStateInfoLimitLower.isQueryTruncated());
        Assert.assertEquals((String)queryStateInfoLimitLower.getQuery(), (String)queryInfo.getQuery().substring(0, 5));
        Assert.assertEquals((int)queryStateInfoLimitLower.getQuery().length(), (int)5);
        QueryStateInfo queryStateInfoLimitHigher = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(queryInfo), Optional.empty(), (boolean)false, (OptionalInt)OptionalInt.of(500));
        Assert.assertFalse((boolean)queryStateInfoLimitHigher.isQueryTruncated());
        Assert.assertEquals((String)queryStateInfoLimitHigher.getQuery(), (String)queryInfo.getQuery());
    }

    @Test
    public void testIncludeQueryProgress() {
        QueryInfo queuedQueryInfo = this.createQueryInfo("query_id_test", QueryState.QUEUED, "SELECT * FROM foo");
        QueryStateInfo queuedStateInfoWithoutProgress = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(queuedQueryInfo), Optional.empty(), (boolean)false, (OptionalInt)OptionalInt.empty());
        Assert.assertFalse((boolean)queuedStateInfoWithoutProgress.getProgress().isPresent());
        QueryStateInfo queuedStateInfoWithProgress = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(queuedQueryInfo), Optional.empty(), (boolean)true, (OptionalInt)OptionalInt.empty());
        Assert.assertTrue((boolean)queuedStateInfoWithProgress.getProgress().isPresent());
        QueryInfo runningQueryInfo = this.createQueryInfo("query_id_test", QueryState.RUNNING, "SELECT * FROM foo");
        QueryStateInfo runningStateInfoWithoutProgress = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(runningQueryInfo), Optional.empty(), (boolean)false, (OptionalInt)OptionalInt.empty());
        Assert.assertTrue((boolean)runningStateInfoWithoutProgress.getProgress().isPresent());
        QueryStateInfo runningStateInfoWithProgress = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(runningQueryInfo), Optional.empty(), (boolean)true, (OptionalInt)OptionalInt.empty());
        Assert.assertTrue((boolean)runningStateInfoWithProgress.getProgress().isPresent());
        QueryInfo finishedQueryInfo = this.createQueryInfo("query_id_test", QueryState.FINISHED, "SELECT * FROM foo");
        QueryStateInfo finishedStateInfoWithoutProgress = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(finishedQueryInfo), Optional.empty(), (boolean)false, (OptionalInt)OptionalInt.empty());
        Assert.assertFalse((boolean)finishedStateInfoWithoutProgress.getProgress().isPresent());
        QueryStateInfo finishedStateInfoWithProgress = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(finishedQueryInfo), Optional.empty(), (boolean)true, (OptionalInt)OptionalInt.empty());
        Assert.assertTrue((boolean)finishedStateInfoWithProgress.getProgress().isPresent());
    }

    @Test
    public void testQueryStateInfoCreation() {
        QueryInfo queryInfo = this.createQueryInfo("query_id_test", QueryState.RUNNING, "SELECT * FROM foo");
        QueryStateInfo queryStateInfo = QueryStateInfo.createQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(queryInfo));
        Assert.assertEquals((Object)queryStateInfo.getQueryId(), (Object)queryInfo.getQueryId());
        Assert.assertEquals((Object)queryStateInfo.getQueryState(), (Object)queryInfo.getState());
        Assert.assertEquals((Object)queryStateInfo.getResourceGroupId(), (Object)queryInfo.getResourceGroupId());
        Assert.assertEquals((String)queryStateInfo.getQuery(), (String)queryInfo.getQuery());
        Assert.assertEquals((Object)queryStateInfo.getCreateTime(), (Object)queryInfo.getQueryStats().getCreateTime());
        Assert.assertEquals((String)queryStateInfo.getUser(), (String)queryInfo.getSession().getUser());
        Assert.assertEquals((boolean)queryStateInfo.isAuthenticated(), (boolean)queryInfo.getSession().getPrincipal().isPresent());
        Assert.assertEquals((Object)queryStateInfo.getSource(), (Object)queryInfo.getSession().getSource());
        Assert.assertEquals((Object)queryStateInfo.getClientInfo(), (Object)queryInfo.getSession().getClientInfo());
        Assert.assertEquals((Object)queryStateInfo.getCatalog(), (Object)queryInfo.getSession().getCatalog());
        Assert.assertEquals((Object)queryStateInfo.getSchema(), (Object)queryInfo.getSession().getSchema());
        Assert.assertEquals((Collection)queryStateInfo.getWarningCodes(), (Collection)ImmutableList.of((Object)"WARNING_123"));
        Assert.assertTrue((boolean)queryStateInfo.getProgress().isPresent());
        Assert.assertEquals((Object)queryStateInfo.getErrorCode(), Optional.ofNullable(queryInfo.getErrorCode()));
        QueryProgressStats progress = (QueryProgressStats)queryStateInfo.getProgress().get();
        QueryStats stats = queryInfo.getQueryStats();
        Assert.assertEquals((long)progress.getElapsedTimeMillis(), (long)stats.getElapsedTime().toMillis());
        Assert.assertEquals((long)progress.getQueuedTimeMillis(), (long)stats.getQueuedTime().toMillis());
        Assert.assertEquals((long)progress.getExecutionTimeMillis(), (long)stats.getExecutionTime().toMillis());
        Assert.assertEquals((long)progress.getCpuTimeMillis(), (long)stats.getTotalCpuTime().toMillis());
        Assert.assertEquals((long)progress.getScheduledTimeMillis(), (long)stats.getTotalScheduledTime().toMillis());
        Assert.assertEquals((long)progress.getCurrentMemoryBytes(), (long)stats.getUserMemoryReservation().toBytes());
        Assert.assertEquals((long)progress.getPeakMemoryBytes(), (long)stats.getPeakUserMemoryReservation().toBytes());
        Assert.assertEquals((long)progress.getPeakTotalMemoryBytes(), (long)stats.getPeakTotalMemoryReservation().toBytes());
        Assert.assertEquals((double)progress.getCumulativeUserMemory(), (double)stats.getCumulativeUserMemory());
        Assert.assertEquals((double)progress.getCumulativeTotalMemory(), (double)stats.getCumulativeTotalMemory());
        Assert.assertEquals((long)progress.getInputRows(), (long)stats.getRawInputPositions());
        Assert.assertEquals((long)progress.getInputBytes(), (long)stats.getRawInputDataSize().toBytes());
        Assert.assertEquals((boolean)progress.isBlocked(), (boolean)stats.isFullyBlocked());
        Assert.assertEquals((Object)progress.getBlockedReasons(), Optional.of(stats.getBlockedReasons()));
        Assert.assertEquals((Object)progress.getProgressPercentage(), (Object)stats.getProgressPercentage());
        Assert.assertEquals((int)progress.getQueuedDrivers(), (int)stats.getQueuedDrivers());
        Assert.assertEquals((int)progress.getRunningDrivers(), (int)stats.getRunningDrivers());
        Assert.assertEquals((int)progress.getCompletedDrivers(), (int)stats.getCompletedDrivers());
    }

    private QueryInfo createQueryInfo(String queryId, QueryState state, String query) {
        return this.createQueryInfo(queryId, new ResourceGroupId("global"), state, query);
    }

    private QueryInfo createQueryInfo(String queryId, ResourceGroupId resourceGroupId, QueryState state, String query) {
        return new QueryInfo(new QueryId(queryId), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), state, new MemoryPoolId("reserved"), true, URI.create("1"), (List)ImmutableList.of((Object)"2", (Object)"3"), query, Optional.empty(), Optional.empty(), new QueryStats(DateTime.parse((String)"1991-09-06T05:00-05:30"), DateTime.parse((String)"1991-09-06T05:01-05:30"), DateTime.parse((String)"1991-09-06T05:02-05:30"), DateTime.parse((String)"1991-09-06T06:00-05:30"), Duration.valueOf((String)"8m"), Duration.valueOf((String)"5m"), Duration.valueOf((String)"7m"), Duration.valueOf((String)"34m"), Duration.valueOf((String)"5m"), Duration.valueOf((String)"6m"), Duration.valueOf((String)"35m"), Duration.valueOf((String)"44m"), Duration.valueOf((String)"9m"), Duration.valueOf((String)"10m"), Duration.valueOf((String)"11m"), 13, 14, 15, 16, 100, 17, 18, 34, 19, 20.0, 43.0, DataSize.valueOf((String)"21GB"), DataSize.valueOf((String)"22GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"24GB"), DataSize.valueOf((String)"25GB"), DataSize.valueOf((String)"26GB"), DataSize.valueOf((String)"42GB"), true, Duration.valueOf((String)"23m"), Duration.valueOf((String)"24m"), Duration.valueOf((String)"0m"), Duration.valueOf((String)"26m"), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), DataSize.valueOf((String)"123MB"), DataSize.valueOf((String)"27GB"), 28L, DataSize.valueOf((String)"29GB"), 30L, DataSize.valueOf((String)"32GB"), 40L, DataSize.valueOf((String)"31GB"), 32L, 33L, DataSize.valueOf((String)"34GB"), DataSize.valueOf((String)"35GB"), DataSize.valueOf((String)"36GB"), (List)ImmutableList.of(), (List)ImmutableList.of(), new RuntimeStats()), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "33", Optional.empty(), null, StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT.toErrorCode(), (List)ImmutableList.of((Object)new PrestoWarning(new WarningCode(123, "WARNING_123"), "warning message")), (Set)ImmutableSet.of(), Optional.empty(), false, Optional.of(resourceGroupId), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), StatsAndCosts.empty(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (List)ImmutableList.of());
    }
}

