/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.server.ServerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestServerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ServerConfig)ConfigAssertions.recordDefaults(ServerConfig.class)).setCoordinator(true).setPrestoVersion(null).setDataSources(null).setIncludeExceptionInResponse(true).setGracePeriod(new Duration(2.0, TimeUnit.MINUTES)).setEnhancedErrorReporting(true).setQueryResultsCompressionEnabled(true).setResourceManagerEnabled(false).setResourceManager(false).setCatalogServer(false).setCatalogServerEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"coordinator", (Object)"false").put((Object)"presto.version", (Object)"test").put((Object)"datasources", (Object)"jmx").put((Object)"http.include-exception-in-response", (Object)"false").put((Object)"shutdown.grace-period", (Object)"5m").put((Object)"sql.parser.enhanced-error-reporting", (Object)"false").put((Object)"query-results.compression-enabled", (Object)"false").put((Object)"resource-manager-enabled", (Object)"true").put((Object)"resource-manager", (Object)"true").put((Object)"catalog-server-enabled", (Object)"true").put((Object)"catalog-server", (Object)"true").build();
        ServerConfig expected = new ServerConfig().setCoordinator(false).setPrestoVersion("test").setDataSources("jmx").setIncludeExceptionInResponse(false).setGracePeriod(new Duration(5.0, TimeUnit.MINUTES)).setEnhancedErrorReporting(false).setQueryResultsCompressionEnabled(false).setResourceManagerEnabled(true).setResourceManager(true).setCatalogServer(true).setCatalogServerEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

