/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.NoopSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.testing.InMemoryFunctionNamespaceManager;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.scalar.ApplyFunction;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionExecutor;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingWarningCollector;
import com.facebook.presto.testing.TestingWarningCollectorConfig;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public class AbstractAnalyzerTest {
    protected static final SqlParser SQL_PARSER = new SqlParser();
    protected static final String TPCH_CATALOG = "tpch";
    protected static final ConnectorId TPCH_CONNECTOR_ID = new ConnectorId("tpch");
    protected static final String SECOND_CATALOG = "c2";
    protected static final ConnectorId SECOND_CONNECTOR_ID = new ConnectorId("c2");
    protected static final String THIRD_CATALOG = "c3";
    protected static final ConnectorId THIRD_CONNECTOR_ID = new ConnectorId("c3");
    protected static final Session SETUP_SESSION = TestingSession.testSessionBuilder().setCatalog("c1").setSchema("s1").build();
    protected static final Session CLIENT_SESSION = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("s1").build();
    protected static final SqlInvokedFunction SQL_FUNCTION_SQUARE = new SqlInvokedFunction(QualifiedObjectName.valueOf((String)"unittest", (String)"memory", (String)"square"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"bigint"))), TypeSignature.parseTypeSignature((String)"bigint"), "square", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN x * x", FunctionVersion.notVersioned());
    protected TransactionManager transactionManager;
    protected AccessControl accessControl;
    protected Metadata metadata;

    @BeforeClass
    public void setup() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new TestingAccessControlManager(this.transactionManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.metadata.getFunctionAndTypeManager().registerBuiltInFunctions((List)ImmutableList.of((Object)ApplyFunction.APPLY_FUNCTION));
        this.metadata.getFunctionAndTypeManager().addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL), (SqlFunctionExecutor)new NoopSqlFunctionExecutor()), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql")));
        this.metadata.getFunctionAndTypeManager().createFunction(SQL_FUNCTION_SQUARE, true);
        Catalog tpchTestCatalog = this.createTestingCatalog(TPCH_CATALOG, TPCH_CONNECTOR_ID);
        catalogManager.registerCatalog(tpchTestCatalog);
        this.metadata.getAnalyzePropertyManager().addProperties(TPCH_CONNECTOR_ID, tpchTestCatalog.getConnector(TPCH_CONNECTOR_ID).getAnalyzeProperties());
        catalogManager.registerCatalog(this.createTestingCatalog(SECOND_CATALOG, SECOND_CONNECTOR_ID));
        catalogManager.registerCatalog(this.createTestingCatalog(THIRD_CATALOG, THIRD_CONNECTOR_ID));
        SchemaTableName table1 = new SchemaTableName("s1", "t1");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table1, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), false));
        SchemaTableName table2 = new SchemaTableName("s1", "t2");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table2, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), false));
        SchemaTableName table3 = new SchemaTableName("s1", "t3");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table3, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("x", (Type)BigintType.BIGINT, null, true))), false));
        SchemaTableName table4 = new SchemaTableName("s2", "t4");
        this.inSetupTransaction(session -> this.metadata.createTable(session, SECOND_CATALOG, new ConnectorTableMetadata(table4, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT))), false));
        SchemaTableName table5 = new SchemaTableName("s1", "t5");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table5, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT, null, true))), false));
        SchemaTableName table6 = new SchemaTableName("s1", "t6");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table6, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), false));
        SchemaTableName table7 = new SchemaTableName("s1", "t7");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table7, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)DoubleType.DOUBLE), (Object)new ColumnMetadata("c", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("d", (Type)new ArrayType((Type)DoubleType.DOUBLE)))), false));
        SchemaTableName table8 = new SchemaTableName("s1", "t8");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table8, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)DoubleType.DOUBLE), (Object)new ColumnMetadata("b", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("c", (Type)RealType.REAL), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), false));
        SchemaTableName table9 = new SchemaTableName("s1", "t9");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table9, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)DoubleType.DOUBLE), (Object)new ColumnMetadata("b", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("c", (Type)RealType.REAL), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), false));
        SchemaTableName table10 = new SchemaTableName("s1", "t10");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table10, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("w"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("x"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("z"), (Type)DoubleType.DOUBLE))))))), (Object)new ColumnMetadata("c", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("d"), (Type)BigintType.BIGINT)))))), false));
        SchemaTableName table11 = new SchemaTableName("s1", "t11");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table11, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT))))), (Object)new ColumnMetadata("b", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("w"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("x"), (Type)new ArrayType((Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT))))))))), (Object)new ColumnMetadata("c", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)))))))))), false));
        SchemaTableName table12 = new SchemaTableName("s1", "t12");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table12, (List)ImmutableList.of((Object)new ColumnMetadata("a.x", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("a&^[x", (Type)BigintType.BIGINT))), false));
        SchemaTableName table13 = new SchemaTableName("s1", "t13");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table13, (List)ImmutableList.of((Object)new ColumnMetadata("w", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("x", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("y", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("z", (Type)BigintType.BIGINT))), false));
        String viewData1 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)BigintType.BIGINT)), Optional.of("user"), false));
        ConnectorTableMetadata viewMetadata1 = new ConnectorTableMetadata(new SchemaTableName("s1", "v1"), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)));
        this.inSetupTransaction(session -> this.metadata.createView(session, TPCH_CATALOG, viewMetadata1, viewData1, false));
        String viewData2 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)VarcharType.VARCHAR)), Optional.of("user"), false));
        ConnectorTableMetadata viewMetadata2 = new ConnectorTableMetadata(new SchemaTableName("s1", "v2"), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)VarcharType.VARCHAR)));
        this.inSetupTransaction(session -> this.metadata.createView(session, TPCH_CATALOG, viewMetadata2, viewData2, false));
        String viewData3 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select a from t4", Optional.of(SECOND_CATALOG), Optional.of("s2"), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)BigintType.BIGINT)), Optional.of("owner"), false));
        ConnectorTableMetadata viewMetadata3 = new ConnectorTableMetadata(new SchemaTableName("s3", "v3"), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)));
        this.inSetupTransaction(session -> this.metadata.createView(session, THIRD_CATALOG, viewMetadata3, viewData3, false));
        String viewData4 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select A from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)BigintType.BIGINT)), Optional.of("user"), false));
        ConnectorTableMetadata viewMetadata4 = new ConnectorTableMetadata(new SchemaTableName("s1", "v4"), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)));
        this.inSetupTransaction(session -> this.metadata.createView(session, TPCH_CATALOG, viewMetadata4, viewData4, false));
        String viewData5 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select * from v5", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)BigintType.BIGINT)), Optional.of("user"), false));
        ConnectorTableMetadata viewMetadata5 = new ConnectorTableMetadata(new SchemaTableName("s1", "v5"), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)));
        this.inSetupTransaction(session -> this.metadata.createView(session, TPCH_CATALOG, viewMetadata5, viewData5, false));
    }

    private void inSetupTransaction(Consumer<Session> consumer) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().execute(SETUP_SESSION, consumer);
    }

    protected void analyze(@Language(value="SQL") String query) {
        this.analyze(CLIENT_SESSION, query);
    }

    protected WarningCollector analyzeWithWarnings(@Language(value="SQL") String query) {
        TestingWarningCollector warningCollector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig());
        this.analyze(CLIENT_SESSION, (WarningCollector)warningCollector, query);
        return warningCollector;
    }

    protected void analyze(Session clientSession, @Language(value="SQL") String query) {
        this.analyze(clientSession, WarningCollector.NOOP, query);
    }

    private void analyze(Session clientSession, WarningCollector warningCollector, @Language(value="SQL") String query) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().readOnly().execute(clientSession, session -> {
            Analyzer analyzer = AbstractAnalyzerTest.createAnalyzer(session, this.metadata, warningCollector);
            Statement statement = SQL_PARSER.createStatement(query);
            analyzer.analyze(statement);
        });
    }

    protected void assertFails(SemanticErrorCode error, @Language(value="SQL") String query) {
        this.assertFails(CLIENT_SESSION, error, query);
    }

    protected void assertFails(SemanticErrorCode error, int line, int column, @Language(value="SQL") String query) {
        this.assertFails(CLIENT_SESSION, error, Optional.of(new NodeLocation(line, column - 1)), query);
    }

    protected void assertFails(SemanticErrorCode error, String message, @Language(value="SQL") String query) {
        this.assertFails(CLIENT_SESSION, error, message, query);
    }

    protected void assertFails(Session session, SemanticErrorCode error, @Language(value="SQL") String query) {
        this.assertFails(session, error, Optional.empty(), query);
    }

    private void assertFails(Session session, SemanticErrorCode error, Optional<NodeLocation> location, @Language(value="SQL") String query) {
        block3: {
            try {
                this.analyze(session, query);
                Assert.fail((String)String.format("Expected error %s, but analysis succeeded", error));
            }
            catch (SemanticException e) {
                if (e.getCode() != error) {
                    Assert.fail((String)String.format("Expected error %s, but found %s: %s", error, e.getCode(), e.getMessage()), (Throwable)e);
                }
                if (!location.isPresent()) break block3;
                NodeLocation expected = location.get();
                NodeLocation actual = (NodeLocation)e.getLocation().get();
                if (expected.getLineNumber() == actual.getLineNumber() && expected.getColumnNumber() == actual.getColumnNumber()) break block3;
                Assert.fail((String)String.format("Expected error '%s' to occur at line %s, offset %s, but was: line %s, offset %s", e.getCode(), expected.getLineNumber(), expected.getColumnNumber(), actual.getLineNumber(), actual.getColumnNumber()));
            }
        }
    }

    protected void assertFails(Session session, SemanticErrorCode error, String message, @Language(value="SQL") String query) {
        block3: {
            try {
                this.analyze(session, query);
                Assert.fail((String)String.format("Expected error %s, but analysis succeeded", error));
            }
            catch (SemanticException e) {
                if (e.getCode() != error) {
                    Assert.fail((String)String.format("Expected error %s, but found %s: %s", error, e.getCode(), e.getMessage()), (Throwable)e);
                }
                if (e.getMessage().matches(message)) break block3;
                Assert.fail((String)String.format("Expected error '%s', but got '%s'", message, e.getMessage()), (Throwable)e);
            }
        }
    }

    protected static Analyzer createAnalyzer(Session session, Metadata metadata, WarningCollector warningCollector) {
        return new Analyzer(session, metadata, SQL_PARSER, (AccessControl)new AllowAllAccessControl(), Optional.empty(), Collections.emptyList(), Collections.emptyMap(), warningCollector);
    }

    private Catalog createTestingCatalog(String catalogName, ConnectorId connectorId) {
        ConnectorId systemId = ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId);
        Connector connector = AbstractAnalyzerTest.createTestingConnector();
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        return new Catalog(catalogName, connectorId, connector, ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, this.metadata, this.accessControl, (List)ImmutableList.of()), systemId, (Connector)new SystemConnector(systemId, (InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> this.transactionManager.getConnectorTransaction(transactionId, connectorId)));
    }

    private static Connector createTestingConnector() {
        return new Connector(){
            private final ConnectorMetadata metadata = new TestingMetadata();

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return this.metadata;
            }

            public ConnectorSplitManager getSplitManager() {
                throw new UnsupportedOperationException();
            }

            public List<PropertyMetadata<?>> getAnalyzeProperties() {
                return ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"p1", (String)"test string property", (String)"", (boolean)false), (Object)PropertyMetadata.integerProperty((String)"p2", (String)"test integer property", (Integer)0, (boolean)false));
            }
        };
    }
}

