/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsCalculator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.CachingPlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.testing.TestingSession;
import com.google.common.graph.Traverser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCachingPlanCanonicalInfoProvider
extends BasePlanTest {
    @Test
    public void testCache() {
        Session session = this.createSession();
        String sql = "SELECT O.totalprice, C.name FROM orders O, customer C WHERE C.custkey = O.custkey LIMIT 10";
        PlanNode root = this.plan(sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, session).getRoot();
        Assert.assertTrue((boolean)root.getStatsEquivalentPlanNode().isPresent());
        CachingPlanCanonicalInfoProvider planCanonicalInfoProvider = (CachingPlanCanonicalInfoProvider)((HistoryBasedPlanStatisticsCalculator)this.getQueryRunner().getStatsCalculator()).getPlanCanonicalInfoProvider();
        Assert.assertEquals((long)planCanonicalInfoProvider.getCacheSize(), (long)(5L * (long)PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList().size()));
        Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root).forEach(child -> {
            if (!child.getStatsEquivalentPlanNode().isPresent()) {
                return;
            }
            for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
                planCanonicalInfoProvider.hash(session, (PlanNode)child.getStatsEquivalentPlanNode().get(), strategy).get();
            }
        });
        Assert.assertEquals((long)planCanonicalInfoProvider.getCacheSize(), (long)(5L * (long)PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList().size()));
        planCanonicalInfoProvider.getHistoryBasedStatisticsCacheManager().invalidate(session.getQueryId());
        Assert.assertEquals((long)planCanonicalInfoProvider.getCacheSize(), (long)0L);
    }

    private Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("use_history_based_plan_statistics", "true").setSystemProperty("task_concurrency", "1").build();
    }
}

