/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestEarlyOutJoins
extends BasePlanTest {
    private ImmutableMap<String, String> nationColumns = ImmutableMap.builder().put((Object)"regionkey", (Object)"regionkey").put((Object)"nationkey", (Object)"nationkey").put((Object)"name", (Object)"name").put((Object)"comment", (Object)"comment").build();
    private ImmutableMap<String, String> orderColumns = ImmutableMap.builder().put((Object)"orderpriority", (Object)"orderpriority").put((Object)"orderstatus", (Object)"orderstatus").put((Object)"totalprice", (Object)"totalprice").put((Object)"orderkey", (Object)"orderkey").put((Object)"custkey", (Object)"custkey").put((Object)"orderdate", (Object)"orderdate").put((Object)"comment", (Object)"comment").put((Object)"shippriority", (Object)"shippriority").put((Object)"clerk", (Object)"clerk").build();

    public TestEarlyOutJoins() {
        super((Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true), (Object)"in_predicates_as_inner_joins_enabled", (Object)Boolean.toString(true), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()));
    }

    @Test
    public void testDistinctInnerRewrite() {
        String query = "select * from nation where nationkey in (select custkey from orders)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", this.nationColumns)))))))));
    }

    @Test
    public void testDistinctInnerToLeftEarlyOutRewrite() {
        String query = "select distinct o.custkey, o.totalprice from orders o, nation n where o.custkey = n.nationkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("custkey", "nationkey", "semijoinvariable$eoj", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"totalprice", (Object)"totalprice"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))))));
        query = "select distinct o.custkey, o.totalprice, n.nationkey, n.name from orders o, nation n where o.custkey = n.nationkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"totalprice", (Object)"totalprice"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name")))))));
        query = "select * from orders where custkey in (select custkey from customer where name = 'Customer#000156251')";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("custkey", "custkey_1", "semijoinvariable$eoj", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", this.orderColumns)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey_1", (Object)"custkey", (Object)"name", (Object)"name"))))))));
    }

    @Test
    public void testDistinctInnerToRightEarlyOutRewrite() {
        String query = "select orderkey from orders where orderkey in (select orderkey from lineitem)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey_1", "orderkey")), PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_1", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        Session sessionWithIncreasedByteReductionThreshold = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("push_aggregation_below_join_byte_reduction_threshold", Double.toString(2.0)).build();
        this.assertPlanWithSession(query, sessionWithIncreasedByteReductionThreshold, false, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey_1", "orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_1", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))))))));
        query = "select distinct l.orderkey, l.partkey, o.custkey from lineitem l, orders o where l.orderkey = o.orderkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey", "orderkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"orderkey", (Object)"orderkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"orderkey_0", (Object)"orderkey")))))));
    }

    @Test
    public void testAntiJoinScenarios() {
        String query = "select * from nation where nationkey not in (select custkey from orders)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("nationkey", "custkey", "expr_9", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))))));
        query = "select * from nation where nationkey in (select custkey from orders) or nationkey in (select orderkey from lineitem)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("nationkey", "orderkey_11", "expr_21", PlanMatchPattern.semiJoin("nationkey", "custkey", "expr_9", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_11", (Object)"orderkey")))))));
        query = "select * from nation where not (nationkey = any (select custkey from orders))";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("nationkey", "custkey", "expr_9", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))))));
        query = "select case when (nationkey in (select custkey from orders)) then 1 else 2 end from nation";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("nationkey", "custkey", "expr_9", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))))));
    }

    @Test
    void testCombinationsOfSubqueries() {
        String query = "select * from nation where nationkey in (select custkey from orders) and nationkey in (select orderkey from lineitem)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey_9", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_9", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.assignUniqueId("unique_34", PlanMatchPattern.tableScan("nation", this.nationColumns)))))))))))));
        query = "select * from nation where nationkey in (select custkey from orders) and regionkey in (select orderkey from lineitem)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey_9", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_9", (Object)"orderkey"))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.assignUniqueId("unique_34", PlanMatchPattern.tableScan("nation", this.nationColumns))))))))))))));
    }

    @Test
    void testComplexQueries() {
        String query = "select * from nation where nationkey in (select custkey from orders group by custkey)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)))));
        query = "select nationkey, name from nation having nationkey in (select custkey from orders)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name"))))))))));
        query = "select nationkey, name from nation having nationkey in (select custkey from orders) and nationkey in (select orderkey from lineitem)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey_9", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_9", (Object)"orderkey"))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "nationkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.assignUniqueId("unique_26", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name")))))))))))))));
        query = "select nationkey, name from nation having nationkey in (select custkey from orders) or nationkey in (select orderkey from lineitem)";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("nationkey", "orderkey_9", "expr_17", PlanMatchPattern.semiJoin("nationkey", "custkey", "expr_7", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"nationkey", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_9", (Object)"orderkey")))))));
    }
}

