/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.functionNamespace.FunctionNamespaceManagerPlugin;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.TestExpressionInterpreter;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.RowNumberSymbolMatcher;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.QueryTemplate;
import com.facebook.presto.util.MorePredicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLogicalPlanner
extends BasePlanTest {
    @BeforeClass
    public void setup() {
        this.setupJsonFunctionNamespaceManager((QueryRunner)this.getQueryRunner());
    }

    @Test
    public void testAnalyze() {
        this.assertDistributedPlan("ANALYZE orders", PlanMatchPattern.anyTree(PlanMatchPattern.node(StatisticsWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of()))))))))));
    }

    @Test
    public void testAggregation() {
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders WHERE orderstatus='O' GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
    }

    @Test
    public void testGroupingSet() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("push_remote_exchange_through_group_id", "false").build();
        this.assertDistributedPlan("SELECT sum(totalprice), orderstatus, orderpriority FROM orders GROUP BY GROUPING SETS ((orderstatus), (orderstatus, orderpriority))", session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.groupingSet((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"orderstatus"), (Object)ImmutableList.of((Object)"orderstatus", (Object)"orderpriority")), (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"), "groupid", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderstatus", (Object)"orderstatus", (Object)"orderpriority", (Object)"orderpriority"))))))))));
    }

    @Test
    public void testGroupingSetWithPushRemoteExchange() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("push_remote_exchange_through_group_id", "true").build();
        this.assertDistributedPlan("SELECT sum(totalprice), orderstatus, orderpriority FROM orders GROUP BY GROUPING SETS ((orderstatus), (orderstatus, orderpriority))", session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.groupingSet((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"orderstatus"), (Object)ImmutableList.of((Object)"orderstatus", (Object)"orderpriority")), (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"), "groupid", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderstatus", (Object)"orderstatus", (Object)"orderpriority", (Object)"orderpriority"))))))))))));
        this.assertDistributedPlan("SELECT sum(totalprice), orderstatus, orderpriority FROM orders GROUP BY GROUPING SETS ((orderstatus), (orderpriority))", session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.groupingSet((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"orderstatus"), (Object)ImmutableList.of((Object)"orderpriority")), (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"), "groupid", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderstatus", (Object)"orderstatus", (Object)"orderpriority", (Object)"orderpriority"))))))))));
    }

    @Test
    public void testWindow() {
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY orderkey) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertDistributedPlan("SELECT row_number() OVER (PARTITION BY orderkey) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(rowNumberMatcherBuilder -> rowNumberMatcherBuilder.partitionBy((List<String>)ImmutableList.of((Object)"orderkey")), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertDistributedPlan("SELECT orderkey FROM (SELECT orderkey, row_number() OVER (PARTITION BY orderkey ORDER BY custkey) n FROM orders) WHERE n = 1", PlanMatchPattern.anyTree(PlanMatchPattern.topNRowNumber(topNRowNumber -> topNRowNumber.specification((List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey"))))));
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY orderstatus) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))))))));
        this.assertDistributedPlan("SELECT row_number() OVER (PARTITION BY orderstatus) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(rowNumberMatcherBuilder -> rowNumberMatcherBuilder.partitionBy((List<String>)ImmutableList.of((Object)"orderstatus")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))))))));
        this.assertDistributedPlan("SELECT orderstatus FROM (SELECT orderstatus, row_number() OVER (PARTITION BY orderstatus ORDER BY custkey) n FROM orders) WHERE n = 1", PlanMatchPattern.anyTree(PlanMatchPattern.topNRowNumber(topNRowNumber -> topNRowNumber.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)).partial(false), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.topNRowNumber(topNRowNumber -> topNRowNumber.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)).partial(true), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"custkey", (Object)"custkey")))))))));
    }

    @Test
    public void testWindowAfterJoin() {
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY o.orderstatus, o.orderkey) FROM orders o JOIN lineitem l ON o.orderstatus = l.linestatus", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderstatus", (Object)"orderkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderstatus", "linestatus")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"linestatus", (Object)"linestatus")))))))))));
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY o.orderkey) FROM orders o JOIN lineitem l ON o.orderstatus = l.linestatus", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderstatus", "linestatus")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"linestatus", (Object)"linestatus"))))))))))));
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).build();
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY o.custkey) FROM orders o JOIN lineitem l ON o.orderstatus = l.linestatus", broadcastJoin, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderstatus", "linestatus")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"custkey", (Object)"custkey"))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"linestatus", (Object)"linestatus"))))))))))));
    }

    @Test
    public void testWindowAfterAggregation() {
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY custkey) FROM orders GROUP BY custkey", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("custkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))))))))));
        this.assertDistributedPlan("SELECT rank() OVER (partition by custkey) FROM (SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY shippriority, custkey)", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("shippriority", "custkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"shippriority", (Object)"shippriority"))))))))))));
    }

    @Test
    public void testDistinctLimitOverInequalityJoin() {
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY", (Object)"L_ORDERKEY")))))));
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey LIMIT 1", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY"))))));
    }

    @Test
    public void testDistinctOverConstants() {
        this.assertPlan("SELECT count(*), count(distinct orderstatus) FROM (SELECT * FROM orders WHERE orderstatus = 'F')", PlanMatchPattern.anyTree(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"orderstatus"), "hash", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(orderstatus), 0))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")))))));
    }

    @Test
    public void testInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testLeftConvertedToInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o LEFT JOIN lineitem l ON o.orderkey < l.orderkey WHERE l.orderkey IS NOT NULL", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.any(PlanMatchPattern.filter("NOT (L_ORDERKEY IS NULL)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("X", "Y")), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.project(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testPushDownJoinConditionConjunctsToInnerSideBasedOnInheritedPredicate() {
        this.assertPlan("SELECT nationkey FROM nation LEFT OUTER JOIN region ON nation.regionkey = region.regionkey and nation.name = region.name WHERE nation.name = 'blah'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("NATION_NAME", "REGION_NAME"), PlanMatchPattern.equiJoinClause("NATION_REGIONKEY", "REGION_REGIONKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("NATION_NAME = CAST ('blah' AS VARCHAR(25))", PlanMatchPattern.constrainedTableScan("nation", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"NATION_NAME", (Object)"name", (Object)"NATION_REGIONKEY", (Object)"regionkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("REGION_NAME = CAST ('blah' AS VARCHAR(25))", PlanMatchPattern.constrainedTableScan("region", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"REGION_NAME", (Object)"name", (Object)"REGION_REGIONKEY", (Object)"regionkey")))))));
    }

    @Test
    public void testScalarSubqueryJoinFilterPushdown() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.filter("orderkey = BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.any(new PlanMatchPattern[0]))))));
    }

    @Test
    public void testSameScalarSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders WHERE CAST(orderkey AS INTEGER) = (SELECT 1) AND custkey = (SELECT 2) AND CAST(custkey as REAL) != (SELECT 1)"), EnforceSingleRowNode.class::isInstance), (int)2);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey = (SELECT 1) AND o2.orderkey = (SELECT 1) AND o1.orderkey + o2.orderkey = (SELECT 2)"), EnforceSingleRowNode.class::isInstance), (int)2);
    }

    @Test
    public void testSameInSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey IN (SELECT 1) AND (o1.orderkey IN (SELECT 1) OR o1.orderkey IN (SELECT 1))"), SemiJoinNode.class::isInstance), (int)1);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 IN (SELECT 1), 2 IN (SELECT 1) WHERE 1 IN (SELECT 1)"), SemiJoinNode.class::isInstance), (int)2);
    }

    @Test
    public void testSameQualifiedSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey <= ALL(SELECT 1) AND (o1.orderkey <= ALL(SELECT 1) OR o1.orderkey <= ALL(SELECT 1))"), AggregationNode.class::isInstance), (int)1);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 <= ALL(SELECT 1), 2 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)"), AggregationNode.class::isInstance), (int)2);
    }

    private static int countOfMatchingNodes(Plan plan, Predicate<PlanNode> predicate) {
        return PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(predicate).count();
    }

    @Test
    public void testRemoveUnreferencedScalarInputApplyNodes() {
        this.assertPlanContainsNoApplyOrAnyJoin("SELECT (SELECT 1)");
    }

    @Test
    public void testSubqueryPruning() {
        List<QueryTemplate.Parameter> subqueries = QueryTemplate.parameter("subquery").of("orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "EXISTS(SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "0 = (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)");
        QueryTemplate.queryTemplate("SELECT COUNT(*) FROM (SELECT %subquery% FROM orders)", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
        QueryTemplate.queryTemplate("SELECT * FROM orders WHERE true OR %subquery%", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
    }

    @Test
    public void testJoinOutputPruning() {
        this.assertPlan("SELECT nationkey FROM nation JOIN region ON nation.regionkey = region.regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("REGIONKEY_LEFT", "REGIONKEY_RIGHT")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_LEFT", (Object)"regionkey", (Object)"NATIONKEY", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_RIGHT", (Object)"regionkey"))))).withNumberOfOutputColumns(1).withOutputs((List<String>)ImmutableList.of((Object)"NATIONKEY")));
    }

    private void assertPlanContainsNoApplyOrAnyJoin(String sql) {
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(sql, Optimizer.PlanStage.OPTIMIZED).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{ApplyNode.class, JoinNode.class, IndexJoinNode.class, SemiJoinNode.class, LateralJoinNode.class})).matches(), (String)("Unexpected node for query: " + sql));
    }

    @Test
    public void testCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders WHERE 3 = (SELECT orderkey)", Optimizer.PlanStage.OPTIMIZED, PlanMatchPattern.any(PlanMatchPattern.filter("X = BIGINT '3'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))));
    }

    @Test
    public void testCorrelatedScalarSubqueryInSelect() {
        this.assertDistributedPlan("SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.filter(String.format("CASE \"is_distinct\" WHEN true THEN true ELSE CAST(fail(%s, 'Scalar sub-query has returned multiple rows') AS boolean) END", StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("n_regionkey", "r_regionkey")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_regionkey", (Object)"regionkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testStreamingAggregationForCorrelatedSubquery() {
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey = nation.regionkey AND length(name) > length(nation.name)) FROM nation", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name")))))));
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey > nation.regionkey) FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name")))))));
    }

    @Test
    public void testStreamingAggregationOverJoin() {
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l WHERE o.orderkey=l.orderkey GROUP BY 1", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("o_orderkey", "l_orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o LEFT JOIN lineitem l ON o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("o_orderkey", "l_orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testCorrelatedInUncorrelatedFiltersPushDown() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey < BIGINT '7'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))))));
    }

    @Test
    public void testSymbolsPrunedInCorrelatedInPredicateSource() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"comment", (Object)"comment"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*Unexpected UnresolvedSymbolExpression.*")
    public void testDoubleNestedCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders o WHERE 3 IN (SELECT o.custkey FROM lineitem l WHERE (SELECT l.orderkey = o.orderkey))", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, PlanMatchPattern.anyTree(PlanMatchPattern.filter("OUTER_FILTER", PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"C", (Object)"O"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"OUTER_FILTER", (Object)PlanMatchPattern.expression("THREE IN (C)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"THREE", (Object)PlanMatchPattern.expression("BIGINT '3'")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O", (Object)"orderkey", (Object)"C", (Object)"custkey"))), PlanMatchPattern.project(PlanMatchPattern.any(PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L", (Object)"orderkey")))))))), MorePredicates.isInstanceOfAny((Class[])new Class[]{AddLocalExchanges.class}).negate());
    }

    @Test
    public void testCorrelatedScalarAggregationRewriteToLeftOuterJoin() {
        this.assertPlan("SELECT orderkey FROM orders WHERE EXISTS(SELECT 1 WHERE orderkey = 3)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("FINAL_COUNT > BIGINT '0'", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"FINAL_COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"NON_NULL"))), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("BIGINT '3' = ORDERKEY"), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testRemovesTrivialFilters() {
        this.assertPlan("SELECT * FROM nation WHERE 1 = 1", PlanMatchPattern.output(PlanMatchPattern.tableScan("nation")));
        this.assertPlan("SELECT * FROM nation WHERE 1 = 0", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
    }

    @Test
    public void testPruneCountAggregationOverScalar() {
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"_col0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"))))));
        this.assertPlan("SELECT count(s) FROM (SELECT sum(orderkey) AS s FROM orders)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders GROUP BY custkey)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
    }

    @Test
    public void testPickTableLayoutWithFilter() {
        this.assertPlan("SELECT orderkey FROM orders WHERE orderkey=5", PlanMatchPattern.output(PlanMatchPattern.filter("orderkey = BIGINT '5'", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("SELECT orderkey FROM orders WHERE orderstatus='F'", PlanMatchPattern.output(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))));
    }

    @Test
    public void testBroadcastCorrelatedSubqueryAvoidsRemoteExchangeBeforeAggregation() {
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).build();
        PlanMatchPattern joinBuildSideWithRemoteExchange = PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        Consumer<Plan> validateSingleRemoteExchange = plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope().isRemote()), (int)1);
        Consumer<Plan> validateSingleStreamingAggregation = plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof AggregationNode && ((AggregationNode)node).getGroupingKeys().contains(new VariableReferenceExpression(Optional.empty(), "unique", (Type)BigintType.BIGINT)) && ((AggregationNode)node).isStreamable()), (int)1);
        this.assertPlanWithSession("SELECT (SELECT COUNT(*) FROM region r2 WHERE r2.regionkey > r1.regionkey) FROM region r1", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
        this.assertPlanWithSession("SELECT COUNT(COUNT) FROM (SELECT o1.orderkey orderkey, (SELECT COUNT(*) FROM orders o2 WHERE o2.orderkey > o1.orderkey) COUNT FROM orders o1) GROUP BY orderkey", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
    }

    @Test
    public void testUsesDistributedJoinIfNaturallyPartitionedOnProbeSymbols() {
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.toString()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).setSystemProperty("optimize_hash_generation", Boolean.toString(false)).build();
        this.assertPlanWithSession("SELECT r1.regionkey FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey = r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LEFT_REGIONKEY", "RIGHT_REGIONKEY")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"LEFT_REGIONKEY", (Object)"regionkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"RIGHT_REGIONKEY", (Object)"regionkey")))))), plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope().isRemote()), (int)2));
        this.assertPlanWithSession("SELECT * FROM (SELECT * FROM (VALUES 1) t(a)) t, region r WHERE r.regionkey = t.a", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        this.assertPlanWithSession("SELECT * FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey > r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testDistributedSort() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))))));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("distributed_sort", Boolean.toString(false)).build(), PlanMatchPattern.output(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualityInference() {
        this.assertPlan("SELECT l.comment, p.partkey FROM lineitem l JOIN partsupp p ON l.suppkey = p.suppkey AND l.partkey = p.partkey WHERE l.partkey = 42", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_suppkey", "p_suppkey")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("l_partkey = 42", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_suppkey", (Object)"suppkey", (Object)"l_comment", (Object)"comment")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("p_partkey = 42", PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey", (Object)"p_suppkey", (Object)"suppkey")))))));
        this.assertPlan("SELECT l.comment, p.partkey FROM lineitem l JOIN partsupp p ON l.suppkey = p.suppkey AND l.comment = p.comment WHERE l.comment = '42'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_suppkey", "p_suppkey")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("l_comment = '42'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_suppkey", (Object)"suppkey", (Object)"l_comment", (Object)"comment")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("p_comment = '42' ", PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"p_suppkey", (Object)"suppkey", (Object)"p_partkey", (Object)"partkey", (Object)"p_comment", (Object)"comment")))))));
    }

    @Test
    public void testSimplifyJoinWithEmptyInput() {
        Session applyEmptyJoinOptimization = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("simplify_plan_with_empty_input", Boolean.toString(true)).build();
        Session disableEmptyJoinOptimization = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("simplify_plan_with_empty_input", Boolean.toString(false)).build();
        this.assertPlanWithSession("SELECT orderkey FROM orders join (select custkey from orders where 1=0) on 1=1", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("SELECT orderkey FROM (select custkey from orders where 1=0) join orders on 1=1", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("SELECT O1.orderkey FROM orders O1 join (select custkey C from orders where 1=0) ON O1.custkey = C join orders on 1=1", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("SELECT O1 FROM (select orderkey O1 from orders group by orderkey) join (select custkey C from orders where 1=0) ON O1 = C join orders on 1=1", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("SELECT O1.orderkey FROM orders O1 join orders O2 ON 1=1 join (select custkey C from orders where 1=0) ON O1.custkey = C", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey FROM (select custkey from orders where 1=0) join orders on 1=1) SELECT * FROM DT LIMIT 2", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("SELECT orderkey FROM (select custkey from orders limit 0) join orders on 1=1", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("SELECT orderkey FROM (select custkey from orders TABLESAMPLE BERNOULLI (0)) join orders on 1=1", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey FROM (select custkey C from orders limit 0) left outer join orders on orderkey=C) SELECT * FROM DT LIMIT 2", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey FROM (select custkey C from orders limit 0) left outer join orders on orderkey=C   left outer join customer C2 on C2.custkey = C)  SELECT * FROM DT LIMIT 2", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey FROM orders right outer join (select custkey C from orders limit 0) on orderkey=C) SELECT * FROM DT LIMIT 2", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey FROM orders left outer join (select custkey C from orders limit 0) on orderkey=C) SELECT * FROM DT", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
        this.assertPlanWithSession("WITH DT AS (SELECT C, orderkey FROM (select custkey C from orders limit 0) right outer join orders on orderkey=C) SELECT * FROM DT", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey, C FROM orders left outer join (select custkey C from orders limit 0) on orderkey=C) SELECT * FROM DT", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))));
        this.assertPlanWithSession("WITH DT AS (SELECT orderkey, C FROM orders full outer join (select custkey C from orders limit 0) on orderkey=C) SELECT * FROM DT", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))));
        this.assertPlanWithSession("SELECt orderkey,custkey FROM (SELECT orderkey FROM orders where 1=0) full outer join (select custkey from orders where 1=0) on orderkey=custkey", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0", "custkey_0")));
        this.assertPlanWithSession("SELECT orderkey FROM (select custkey as C from orders where 1>0) join orders on orderkey=C", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))));
        this.assertPlanWithSession("SELECT orderkey FROM (select custkey as C from orders TABLESAMPLE BERNOULLI (1)) join orders on orderkey=C", applyEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))));
        this.assertPlanWithSession("SELECT C, orderkey FROM (select orderkey as C from orders where 1=0) join orders on 1=1", disableEmptyJoinOptimization, true, PlanMatchPattern.output(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.values("orderkey_0"), PlanMatchPattern.values("orderkey_3"))));
    }

    @Test
    public void testLimitZero() {
        this.assertPlan("SELECT orderkey FROM orders LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlan("SELECT orderkey FROM orders ORDER BY orderkey ASC LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlan("SELECT orderkey FROM orders GROUP BY 1 ORDER BY 1 DESC LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlan("SELECT DISTINCT orderkey FROM orders LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.values("orderkey_0")));
        this.assertPlan("SELECT * FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey > r1.regionkey LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.values("expr_8", "expr_9", "expr_10", "expr_11")));
    }

    @Test
    public void testTopN() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC LIMIT 1", PlanMatchPattern.output(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))));
        this.assertDistributedPlan("SELECT orderkey FROM orders GROUP BY 1 ORDER BY 1 DESC LIMIT 1", PlanMatchPattern.output(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testComplexOrderBy() {
        this.assertDistributedPlan("SELECT COUNT(*) FROM (values ARRAY['a', 'b']) as t(col1) ORDER BY   IF(     SUM(REDUCE(col1, ROW(0),(l, r) -> l, x -> 1)) > 0,     COUNT(*),     SUM(REDUCE(col1, ROW(0),(l, r) -> l, x -> 1))   )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.exchange(PlanMatchPattern.exchange(PlanMatchPattern.sort(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.values("col1")))))))))));
    }

    @Test
    public void testSizeBasedJoin() {
        this.assertDistributedPlan("SELECT custkey FROM local.\"sf42.5\".nation, local.\"sf42.5\".orders WHERE nation.nationkey = orders.custkey", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("NATIONKEY", "CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey")))))));
        this.assertDistributedPlan("SELECT custkey FROM (VALUES CAST(1 AS BIGINT), CAST(2 AS BIGINT)) t(a), local.\"sf42.5\".orders WHERE t.a = orders.custkey", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("CUSTKEY", "T_A")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.values("T_A"))))));
    }

    @Test
    public void testSizeBasedSemiJoin() {
        this.assertDistributedPlan("SELECT custkey FROM local.\"sf42.5\".orders WHERE orders.custkey NOT IN (SELECT nationkey FROM local.\"sf42.5\".nation)", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("CUSTKEY", "NATIONKEY", "OUT", Optional.of(SemiJoinNode.DistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey")))))));
        this.assertDistributedPlan("SELECT custkey FROM local.\"sf42.5\".orders WHERE orders.custkey NOT IN (SELECT t.a FROM (VALUES CAST(1 AS BIGINT), CAST(2 AS BIGINT)) t(a))", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("CUSTKEY", "T_A", "OUT", Optional.of(SemiJoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.values("T_A"))))));
    }

    @Test
    public void testEnforceFixedDistributionForOutputOperator() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("task_concurrency", "2").setSystemProperty("enforce_fixed_distribution_for_output_operator", "true").build();
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"))))))))));
        this.assertDistributedPlan("SELECT orderstatus FROM (SELECT orderstatus, row_number() OVER (PARTITION BY orderstatus ORDER BY custkey) n FROM orders) WHERE n = 1", session, PlanMatchPattern.anyTree(PlanMatchPattern.topNRowNumber(topNRowNumber -> topNRowNumber.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)).partial(false), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.topNRowNumber(topNRowNumber -> topNRowNumber.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)).partial(true), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"custkey", (Object)"custkey"))))))))));
    }

    @Test
    public void testOffset() {
        Session enableOffset = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("offset_clause_enabled", "true").build();
        this.assertPlanWithSession("SELECT name FROM nation OFFSET 2 ROWS", enableOffset, true, PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name")), PlanMatchPattern.filter("(row_num > BIGINT '2')", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlanWithSession("SELECT name FROM nation ORDER BY regionkey OFFSET 2 ROWS", enableOffset, true, PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    public void testRedundantLimitNodeRemoval() {
        String query = "SELECT count(*) FROM orders LIMIT 10";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, Optimizer.PlanStage.OPTIMIZED).getRoot()).where(LimitNode.class::isInstance).matches(), (String)String.format("Unexpected limit node for query: '%s'", query));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT * FROM (VALUES 1,2,3,4,5,6) AS t1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"))));
    }

    @Test
    public void testRemoveSingleRowSort() {
        Session exploitConstraints = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("exploit_constraints", Boolean.toString(true)).build();
        String query = "SELECT count(*) FROM orders ORDER BY 1";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, Optimizer.PlanStage.OPTIMIZED, exploitConstraints).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{SortNode.class})).matches(), (String)String.format("Unexpected sort node for query: '%s'", query));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testRedundantTopNNodeRemoval() {
        Session exploitConstraints = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("exploit_constraints", Boolean.toString(true)).build();
        String query = "SELECT count(*) FROM orders ORDER BY 1 LIMIT 10";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, Optimizer.PlanStage.OPTIMIZED, exploitConstraints).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{TopNNode.class, SortNode.class})).matches(), (String)String.format("Unexpected TopN node for query: '%s'", query));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testRedundantDistinctLimitNodeRemoval() {
        Session exploitConstraints = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("exploit_constraints", Boolean.toString(true)).build();
        String query = "SELECT distinct(c) FROM (SELECT count(*) as c FROM orders) LIMIT 10";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, Optimizer.PlanStage.OPTIMIZED, exploitConstraints).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{DistinctLimitNode.class})).matches(), (String)String.format("Unexpected DistinctLimit node for query: '%s'", query));
        this.assertPlan("SELECT distinct(c) FROM (SELECT count(*) as c FROM orders GROUP BY orderkey) LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testLeafNodeInPlanExceedException() {
        Session enableLeafNodeInPlanExceedException = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_leaf_nodes_in_plan", Integer.toString(10)).setSystemProperty("leaf_node_limit_enabled", Boolean.toString(true)).build();
        String expectedMessageRegExp = String.format("Number of leaf nodes in logical plan exceeds threshold %s set in max_leaf_nodes_in_plan", SystemSessionProperties.getMaxLeafNodesInPlan((Session)enableLeafNodeInPlanExceedException));
        String joinQuery = "WITH t1 AS (    SELECT * FROM ( VALUES (1, 'a'), (2, 'b'), (3, 'c') ) AS t (id, name) ), t2 AS (     SELECT A.id, B.name FROM t1 A Join t1 B On A.id = B.id ), t3 AS (     SELECT A.id, B.name FROM t2 A Join t2 B On A.id = B.id ), t4 AS (     SELECT A.id, B.name FROM t3 A Join t3 B On A.id = B.id ), t5 AS (     SELECT A.id, B.name FROM t4 A Join t4 B On A.id = B.id ) SELECT * FROM t5";
        this.assertPlanFailedWithException(joinQuery, enableLeafNodeInPlanExceedException, expectedMessageRegExp);
        enableLeafNodeInPlanExceedException = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_leaf_nodes_in_plan", Integer.toString(100)).setSystemProperty("leaf_node_limit_enabled", Boolean.toString(true)).build();
        String joinQuery2 = "WITH t1 AS (    SELECT * FROM ( VALUES (1, 'a'), (2, 'b'), (3, 'c') ) AS t (id, name) ), t2 AS (     SELECT A.id, B.name FROM t1 A Join t1 B On A.id = B.id ), t3 AS (     SELECT A.id, B.name FROM t2 A Join t2 B On A.id = B.id ), t4 AS (     SELECT A.id, B.name FROM t3 A Join t3 B On A.id = B.id ), t5 AS (     SELECT A.id, B.name FROM t4 A Join t4 B On A.id = B.id ) SELECT * FROM t5";
        this.assertPlanSucceeded(joinQuery2, enableLeafNodeInPlanExceedException);
    }

    @Test
    public void testJsonBasedFunctions() {
        this.getQueryRunner().getFunctionAndTypeManager().createFunction(TestExpressionInterpreter.SQUARE_UDF_CPP, false);
        this.assertPlan("SELECT json.test_schema.square(orderkey) from orders", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"out", (Object)PlanMatchPattern.expression("json.test_schema.square(orderkey)")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
    }

    @Test
    public void testJsonBasedAggregateFunctions() {
        this.getQueryRunner().getFunctionAndTypeManager().createFunction(TestExpressionInterpreter.AVG_UDAF_CPP, false);
        this.assertDistributedPlan("SELECT orderstatus, json.test_schema.avg(totalprice) FROM orders GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_result", PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"partial_result"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_result", PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
    }

    private void setupJsonFunctionNamespaceManager(QueryRunner queryRunner) {
        queryRunner.installPlugin((Plugin)new FunctionNamespaceManagerPlugin());
        queryRunner.loadFunctionNamespaceManager("json_file", "json", (Map)ImmutableMap.of((Object)"supported-function-languages", (Object)"CPP", (Object)"function-implementation-type", (Object)"CPP", (Object)"json-based-function-manager.path-to-function-definition", (Object)""));
    }

    @Test
    public void testDuplicateUnnestItem() {
        this.assertPlanSucceeded("SELECT * from (select * FROM (values 1) as t(k)) CROSS JOIN unnest(array[2, 3], ARRAY[2, 3]) AS r(r1, r2)", this.getQueryRunner().getDefaultSession());
    }

    @Test
    public void testCorrelatedSubqueriesWithOuterJoins() {
        this.assertPlan("SELECT COUNT(*) FROM part p LEFT JOIN partsupp ps ON p.partkey=ps.partkey AND EXISTS (SELECT 1 FROM supplier s WHERE s.suppkey=ps.suppkey)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "partkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("suppkey", "suppkey_4")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"partkey_0", (Object)"partkey", (Object)"suppkey", (Object)"suppkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"suppkey_4", (Object)"suppkey"))))))));
        String expectedErrorMsg = "Unexpected UnresolvedSymbolExpression in logical plan: ";
        this.assertPlanFailedWithException("SELECT COUNT(*) FROM part p RIGHT JOIN partsupp ps ON p.partkey=ps.partkey AND EXISTS (SELECT 1 FROM supplier s WHERE s.suppkey=ps.suppkey)", this.getQueryRunner().getDefaultSession(), expectedErrorMsg + "ps.suppkey");
        this.assertPlan("SELECT COUNT(*) FROM part p RIGHT JOIN partsupp ps ON p.partkey=ps.partkey AND EXISTS (SELECT 1 FROM supplier s WHERE s.suppkey=p.partkey)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "partkey_0")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "suppkey_4")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"suppkey_4", (Object)"suppkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"partkey_0", (Object)"partkey"))))));
        this.assertPlan("SELECT COUNT(*) FROM part p LEFT JOIN (SELECT * FROM partsupp ps, supplier s WHERE ps.suppkey=s.suppkey) sq ON sq.partkey=p.partkey AND NOT EXISTS (SELECT 1 FROM lineitem l WHERE sq.supplycost+sq.acctbal = l.extendedprice)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "partkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("add", "extendedprice")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"add", (Object)new ExpressionMatcher("supplycost + acctbal")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("suppkey", "suppkey_3")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"suppkey", (Object)"suppkey", (Object)"supplycost", (Object)"supplycost", (Object)"partkey_0", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"suppkey_3", (Object)"suppkey", (Object)"acctbal", (Object)"acctbal")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"extendedprice", (Object)"extendedprice"))))))));
        this.assertPlanFailedWithException("SELECT COUNT(*) FROM part p RIGHT JOIN (SELECT * FROM partsupp ps, supplier s WHERE ps.suppkey=s.suppkey) sq ON sq.partkey=p.partkey AND NOT EXISTS (SELECT 1 FROM lineitem l WHERE sq.supplycost+sq.acctbal = l.extendedprice)", this.getQueryRunner().getDefaultSession(), expectedErrorMsg + "sq.supplycost");
        this.assertPlan("SELECT COUNT(*) FROM part p LEFT JOIN partsupp ps ON p.partkey=ps.partkey AND EXISTS (SELECT 1 FROM supplier s WHERE s.suppkey=ps.suppkey) AND ps.availqty<1000", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "partkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("suppkey", "suppkey_4")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"partkey_0", (Object)"partkey", (Object)"suppkey", (Object)"suppkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"suppkey_4", (Object)"suppkey")))))))));
    }
}

