/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPredicatePushdown
extends BasePlanTest {
    public TestPredicatePushdown() {
    }

    public TestPredicatePushdown(Map<String, String> sessionProperties) {
        super(sessionProperties);
    }

    @Test
    public void testNonStraddlingJoinExpression() {
        this.assertPlan("SELECT * FROM orders JOIN lineitem ON orders.orderkey = lineitem.orderkey AND cast(lineitem.linenumber AS varchar) = '2'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("cast('2' as varchar) = cast(LINEITEM_LINENUMBER as varchar)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_LINENUMBER", (Object)"linenumber")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testPushDownToLhsOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders)) WHERE linenumber = 2", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_NUMBER = 2", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_NUMBER", (Object)"linenumber", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testNonDeterministicPredicatePropagatesOnlyToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testNonDeterministicPredicateDoesNotPropagateFromFilteringSideToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = random(5))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.filter("ORDERS_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testGreaterPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualsPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testGreaterPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromSourceSideNotPropagatesToFilterSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinUsedInProjection() {
        this.assertPlan("SELECT orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2) FROM lineitem", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testFilteredSelectFromPartitionedTable() {
        List allOptimizers = this.getQueryRunner().getPlanOptimizers(false);
        this.assertPlan("SELECT DISTINCT orderstatus FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'O'", PlanMatchPattern.output(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders"))), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'no_such_partition_value'", PlanMatchPattern.output(PlanMatchPattern.values("orderstatus")), allOptimizers);
    }

    @Test
    public void testPredicatePushDownThroughMarkDistinct() {
        this.assertPlan("SELECT (SELECT a FROM (VALUES 1, 2, 3) t(a) WHERE a = b) FROM (VALUES 0, 1) p(b) WHERE b = 1", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A", "B")), PlanMatchPattern.project(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.filter("A = 1", PlanMatchPattern.values("A")))), PlanMatchPattern.project(PlanMatchPattern.filter("1 = B", PlanMatchPattern.values("B"))))));
    }

    @Test
    public void testPredicatePushDownOverProjection() {
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x + x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("((expr + expr) > BIGINT '1')", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey * BIGINT '2'")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, 1 y FROM orders) SELECT * FROM t WHERE x + y + y >1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("(((orderkey * BIGINT '2') + BIGINT '1') + BIGINT '1') > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("(orderkey * BIGINT '2') > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, orderkey y FROM orders) SELECT * FROM t WHERE x + y > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("((orderkey * BIGINT '2') + orderkey) > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey x FROM orders) SELECT * FROM t WHERE x >1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("WITH t AS (SELECT rand() * orderkey x FROM orders) SELECT * FROM t WHERE x > 5000", PlanMatchPattern.anyTree(PlanMatchPattern.filter("expr > 5E3", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("rand() * CAST(orderkey AS double)")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))));
    }

    @Test
    public void testConjunctsOrder() {
        this.assertPlan("select partkey from (  select    partkey,    100/(size-1) x  from part  where size <> 1) where x = 2", PlanMatchPattern.anyTree(PlanMatchPattern.filter("size <> 1 AND 100/(size - 1) = 2", PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"size", (Object)"size")))));
    }

    @Test
    public void testPredicateOnPartitionSymbolsPushedThroughWindow() {
        PlanMatchPattern tableScan = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey", (Object)"ORDER_KEY", (Object)"orderkey"));
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey = 0 AND orderkey > 0", PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDER_KEY > BIGINT '0'", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("CUST_KEY = BIGINT '0'", tableScan)))))));
    }

    @Test
    public void testPredicateOnNonDeterministicSymbolsPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT random_column, orderkey, rank() OVER (PARTITION BY random_column  ORDER BY orderdate ASC)FROM (select round(custkey*rand()) random_column, * from orders) ) WHERE random_column > 100", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("\"ROUND\" > 1E2", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ROUND", (Object)PlanMatchPattern.expression("round(CAST(CUST_KEY AS double) * rand())")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testNonDeterministicPredicateNotPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey > 100*rand()", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(\"CUST_KEY\" AS double) > (1E2 * \"rand\"())", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testNoPushdownWithTry() {
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE try(custkey) = 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))))));
    }

    @Test
    public void testPredicatePushDownCreatesValidJoin() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new PredicatePushDown(tester.getMetadata(), tester.getSqlParser())).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.filter((RowExpression)p.comparison(OperatorType.EQUAL, (RowExpression)p.variable("a1"), (RowExpression)Expressions.constant((Object)1L, (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.variable("a1"))), (PlanNode)p.values(p.variable("b1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("a1"), p.variable("b1"))), (List<VariableReferenceExpression>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map<String, VariableReferenceExpression>)ImmutableMap.of())).matches(PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.project(PlanMatchPattern.filter("a1=1", PlanMatchPattern.values("a1"))), PlanMatchPattern.project(PlanMatchPattern.filter("1=b1", PlanMatchPattern.values("b1"))))));
    }
}

