/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.type.ColorType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowExpressionDomainTranslator {
    private static final VariableReferenceExpression C_BIGINT = new VariableReferenceExpression(Optional.empty(), "x1", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression C_DOUBLE = new VariableReferenceExpression(Optional.empty(), "x2", (Type)DoubleType.DOUBLE);
    private static final VariableReferenceExpression C_VARCHAR = new VariableReferenceExpression(Optional.empty(), "x3", (Type)VarcharType.VARCHAR);
    private static final VariableReferenceExpression C_BOOLEAN = new VariableReferenceExpression(Optional.empty(), "x4", (Type)BooleanType.BOOLEAN);
    private static final VariableReferenceExpression C_BIGINT_1 = new VariableReferenceExpression(Optional.empty(), "x5", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression C_DOUBLE_1 = new VariableReferenceExpression(Optional.empty(), "x6", (Type)DoubleType.DOUBLE);
    private static final VariableReferenceExpression C_VARCHAR_1 = new VariableReferenceExpression(Optional.empty(), "x7", (Type)VarcharType.VARCHAR);
    private static final VariableReferenceExpression C_TIMESTAMP = new VariableReferenceExpression(Optional.empty(), "x8", (Type)TimestampType.TIMESTAMP);
    private static final VariableReferenceExpression C_DATE = new VariableReferenceExpression(Optional.empty(), "x9", (Type)DateType.DATE);
    private static final VariableReferenceExpression C_COLOR = new VariableReferenceExpression(Optional.empty(), "x10", (Type)ColorType.COLOR);
    private static final VariableReferenceExpression C_HYPER_LOG_LOG = new VariableReferenceExpression(Optional.empty(), "x11", (Type)HyperLogLogType.HYPER_LOG_LOG);
    private static final VariableReferenceExpression C_VARBINARY = new VariableReferenceExpression(Optional.empty(), "x12", (Type)VarbinaryType.VARBINARY);
    private static final VariableReferenceExpression C_DECIMAL_26_5 = new VariableReferenceExpression(Optional.empty(), "x13", (Type)DecimalType.createDecimalType((int)26, (int)5));
    private static final VariableReferenceExpression C_DECIMAL_23_4 = new VariableReferenceExpression(Optional.empty(), "x14", (Type)DecimalType.createDecimalType((int)23, (int)4));
    private static final VariableReferenceExpression C_INTEGER = new VariableReferenceExpression(Optional.empty(), "x15", (Type)IntegerType.INTEGER);
    private static final VariableReferenceExpression C_CHAR = new VariableReferenceExpression(Optional.empty(), "x16", (Type)CharType.createCharType((long)10L));
    private static final VariableReferenceExpression C_DECIMAL_21_3 = new VariableReferenceExpression(Optional.empty(), "x17", (Type)DecimalType.createDecimalType((int)21, (int)3));
    private static final VariableReferenceExpression C_DECIMAL_12_2 = new VariableReferenceExpression(Optional.empty(), "x18", (Type)DecimalType.createDecimalType((int)12, (int)2));
    private static final VariableReferenceExpression C_DECIMAL_6_1 = new VariableReferenceExpression(Optional.empty(), "x19", (Type)DecimalType.createDecimalType((int)6, (int)1));
    private static final VariableReferenceExpression C_DECIMAL_3_0 = new VariableReferenceExpression(Optional.empty(), "x20", (Type)DecimalType.createDecimalType((int)3, (int)0));
    private static final VariableReferenceExpression C_DECIMAL_2_0 = new VariableReferenceExpression(Optional.empty(), "x21", (Type)DecimalType.createDecimalType((int)2, (int)0));
    private static final VariableReferenceExpression C_SMALLINT = new VariableReferenceExpression(Optional.empty(), "x22", (Type)SmallintType.SMALLINT);
    private static final VariableReferenceExpression C_TINYINT = new VariableReferenceExpression(Optional.empty(), "x23", (Type)TinyintType.TINYINT);
    private static final VariableReferenceExpression C_REAL = new VariableReferenceExpression(Optional.empty(), "x24", (Type)RealType.REAL);
    private static final long TIMESTAMP_VALUE = new DateTime(2013, 3, 30, 1, 5, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_VALUE = TimeUnit.MILLISECONDS.toDays(new DateTime(2001, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC).getMillis());
    private static final long COLOR_VALUE_1 = 1L;
    private static final long COLOR_VALUE_2 = 2L;
    private Metadata metadata;
    private RowExpressionDomainTranslator domainTranslator;

    @BeforeClass
    public void setup() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.domainTranslator = new RowExpressionDomainTranslator(this.metadata);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.metadata = null;
        this.domainTranslator = null;
    }

    @Test
    public void testNoneRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.none();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testAllRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.all();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true)).put((Object)C_BIGINT_1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)C_DOUBLE_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)1.1), (Range[])new Range[]{Range.equal((Type)DoubleType.DOUBLE, (Object)2.0), Range.range((Type)DoubleType.DOUBLE, (Object)3.0, (boolean)false, (Object)3.5, (boolean)true)}), (boolean)true)).put((Object)C_VARCHAR_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-01-01")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-10-01"))}), (boolean)false)).put((Object)C_TIMESTAMP, (Object)Domain.singleValue((Type)TimestampType.TIMESTAMP, (Object)TIMESTAMP_VALUE)).put((Object)C_DATE, (Object)Domain.singleValue((Type)DateType.DATE, (Object)DATE_VALUE)).put((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L)).put((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)).build());
        this.assertPredicateTranslates(this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (TupleDomain<VariableReferenceExpression>)tupleDomain);
    }

    @Test
    public void testInOptimization() {
        Domain testDomain = Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)})), (boolean)false);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.not(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(4L)), this.not(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)true, (Object)7L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)true)}), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.between((RowExpression)C_BIGINT, this.bigintLiteral(1L), this.bigintLiteral(3L)), this.between((RowExpression)C_BIGINT, this.bigintLiteral(5L), this.bigintLiteral(7L)), this.between((RowExpression)C_BIGINT, this.bigintLiteral(9L), this.bigintLiteral(11L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[0])), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(4L)), this.not(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), this.between((RowExpression)C_BIGINT, this.bigintLiteral(7L), this.bigintLiteral(9L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)false, (Object)9L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)11L, (boolean)false, (Object)13L, (boolean)false)})), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(4L)), this.not(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(7L)), this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(9L))}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(11L)), this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(13L))})}));
    }

    @Test
    public void testToPredicateNone() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.none((Type)BooleanType.BOOLEAN)).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.FALSE_CONSTANT);
    }

    @Test
    public void testToPredicateAllIgnored() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.all((Type)BooleanType.BOOLEAN)).build());
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).build()));
    }

    @Test
    public void testToPredicate() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.isNotNull((RowExpression)C_BIGINT));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)TestRowExpressionDomainTranslator.isNull((RowExpression)C_BIGINT));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.none((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.FALSE_CONSTANT);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.all((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.greaterThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(0L)), this.lessThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(1L))}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.lessThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), TestRowExpressionDomainTranslator.isNull((RowExpression)C_BIGINT)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_COLOR, this.colorLiteral(1L)), TestRowExpressionDomainTranslator.isNull((RowExpression)C_COLOR)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.not(this.equal((RowExpression)C_COLOR, this.colorLiteral(1L))), TestRowExpressionDomainTranslator.isNull((RowExpression)C_COLOR)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)TestRowExpressionDomainTranslator.isNull((RowExpression)C_HYPER_LOG_LOG));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)tupleDomain), (Object)this.isNotNull((RowExpression)C_HYPER_LOG_LOG));
    }

    @Test
    public void testFromUnknownPredicate() {
        this.assertUnsupportedPredicate(this.unprocessableExpression1(C_BIGINT));
        this.assertUnsupportedPredicate(this.not(this.unprocessableExpression1(C_BIGINT)));
    }

    @Test
    public void testFromAndPredicate() {
        RowExpression originalPredicate = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.unprocessableExpression1(C_BIGINT), this.unprocessableExpression2(C_BIGINT)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
        this.assertUnsupportedPredicate(this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)})})));
        originalPredicate = this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)})), this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testFromOrPredicate() {
        RowExpression originalPredicate = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        originalPredicate = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(2L)), this.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        originalPredicate = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(2L)), this.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)this.unprocessableExpression1(C_BIGINT));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertUnsupportedPredicate(LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_DOUBLE, this.doubleLiteral(2.0)), this.unprocessableExpression1(C_BIGINT)})}));
        originalPredicate = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.greaterThan((RowExpression)C_DOUBLE, this.doubleLiteral(1.0)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(2L)), this.greaterThan((RowExpression)C_DOUBLE, this.doubleLiteral(2.0)), this.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)this.unprocessableExpression1(C_BIGINT));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false), (Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)1.0), (Range[])new Range[0]), (boolean)false))));
        originalPredicate = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.randPredicate(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(2L)), this.randPredicate(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        originalPredicate = this.not(LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)}), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)})}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)})), this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)}))}));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = this.not(LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)})), this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(5L)), this.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.unprocessableExpression1(C_BIGINT), this.unprocessableExpression2(C_BIGINT)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromNotPredicate() {
        this.assertUnsupportedPredicate(this.not(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L)), this.unprocessableExpression1(C_BIGINT)})));
        this.assertUnsupportedPredicate(this.not(this.unprocessableExpression1(C_BIGINT)));
        this.assertPredicateIsAlwaysFalse(this.not((RowExpression)LogicalRowExpressions.TRUE_CONSTANT));
        this.assertPredicateTranslates(this.not(this.equal((RowExpression)C_BIGINT, this.bigintLiteral(1L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false))));
    }

    @Test
    public void testFromUnprocessableComparison() {
        this.assertUnsupportedPredicate(this.greaterThan(this.unprocessableExpression1(C_BIGINT), this.unprocessableExpression2(C_BIGINT)));
        this.assertUnsupportedPredicate(this.not(this.greaterThan(this.unprocessableExpression1(C_BIGINT), this.unprocessableExpression2(C_BIGINT))));
    }

    @Test
    public void testFromBasicComparisons() {
        this.assertPredicateTranslates(this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.equal((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.notEqual((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.isDistinctFrom((RowExpression)C_BIGINT, this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true))));
        this.assertPredicateTranslates(this.equal((RowExpression)C_COLOR, this.colorLiteral(1L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
        this.assertPredicateTranslates(this.in((RowExpression)C_COLOR, (List<RowExpression>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false))));
        this.assertPredicateTranslates(this.isDistinctFrom((RowExpression)C_COLOR, this.colorLiteral(1L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true))));
        this.assertPredicateTranslates(this.not(this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.greaterThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.lessThan((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.lessThanOrEqual((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.equal((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.notEqual((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.isDistinctFrom((RowExpression)C_BIGINT, this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.equal((RowExpression)C_COLOR, this.colorLiteral(1L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.in((RowExpression)C_COLOR, (List<RowExpression>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L)))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.isDistinctFrom((RowExpression)C_COLOR, this.colorLiteral(1L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
    }

    @Test
    public void testFromFlippedBasicComparisons() {
        this.assertPredicateTranslates(this.greaterThan(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThanOrEqual(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThan(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThanOrEqual(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.equal(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.equal(this.colorLiteral(1L), (RowExpression)C_COLOR), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
        this.assertPredicateTranslates(this.notEqual(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.notEqual(this.colorLiteral(1L), (RowExpression)C_COLOR), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false))));
        this.assertPredicateTranslates(this.isDistinctFrom(this.bigintLiteral(2L), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true))));
        this.assertPredicateTranslates(this.isDistinctFrom(this.colorLiteral(1L), (RowExpression)C_COLOR), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true))));
        this.assertPredicateTranslates(this.isDistinctFrom(this.nullLiteral((Type)BigintType.BIGINT), (RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testFromBasicComparisonsWithNulls() {
        this.assertPredicateIsAlwaysFalse(this.greaterThan((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates(this.greaterThan((RowExpression)C_VARCHAR, this.nullLiteral((Type)VarcharType.VARCHAR)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.none((Type)VarcharType.VARCHAR), (boolean)false))));
        this.assertPredicateIsAlwaysFalse(this.greaterThanOrEqual((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse(this.lessThan((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse(this.lessThanOrEqual((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse(this.equal((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse(this.equal((RowExpression)C_COLOR, this.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse(this.notEqual((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse(this.notEqual((RowExpression)C_COLOR, this.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateTranslates(this.isDistinctFrom((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(this.isDistinctFrom((RowExpression)C_COLOR, this.nullLiteral((Type)ColorType.COLOR)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.notNull((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse(this.not(this.greaterThan((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse(this.not(this.greaterThanOrEqual((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse(this.not(this.lessThan((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse(this.not(this.lessThanOrEqual((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse(this.not(this.equal((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse(this.not(this.equal((RowExpression)C_COLOR, this.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse(this.not(this.notEqual((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse(this.not(this.notEqual((RowExpression)C_COLOR, this.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateTranslates(this.not(this.isDistinctFrom((RowExpression)C_BIGINT, this.nullLiteral((Type)BigintType.BIGINT))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(this.not(this.isDistinctFrom((RowExpression)C_COLOR, this.nullLiteral((Type)ColorType.COLOR))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.onlyNull((Type)ColorType.COLOR))));
    }

    @Test
    void testNonImplicitCastOnSymbolSide() {
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_TIMESTAMP, (Type)DateType.DATE), LiteralEncoder.toRowExpression((Object)DATE_VALUE, (Type)DateType.DATE)));
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_DECIMAL_12_2, (Type)BigintType.BIGINT), this.bigintLiteral(135L)));
    }

    @Test
    void testNoSaturatedFloorCastFromUnsupportedApproximateDomain() {
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_DECIMAL_12_2, (Type)DoubleType.DOUBLE), this.doubleLiteral(12345.56)));
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_BIGINT, (Type)DoubleType.DOUBLE), this.doubleLiteral(12345.56)));
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_BIGINT, (Type)RealType.REAL), this.realLiteral(12345.56f)));
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_INTEGER, (Type)RealType.REAL), this.realLiteral(12345.56f)));
    }

    @Test
    public void testFromComparisonsWithCoercions() {
        this.assertPredicateTranslates(this.greaterThan((RowExpression)C_DOUBLE, this.cast(this.bigintLiteral(2L), (Type)DoubleType.DOUBLE)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThan((RowExpression)C_VARCHAR, this.stringLiteral("test")), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.greaterThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.lessThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.equal(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.equal(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.none((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates(this.notEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.notEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.notNull((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates(this.isDistinctFrom(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)true))));
        this.assertPredicateIsAlwaysTrue(this.isDistinctFrom(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)));
        this.assertPredicateTranslates(this.not(this.greaterThan((RowExpression)C_DOUBLE, this.cast(this.bigintLiteral(2L), (Type)DoubleType.DOUBLE))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.greaterThan((RowExpression)C_VARCHAR, this.stringLiteral("test"))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.greaterThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.greaterThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.greaterThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.greaterThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.lessThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.lessThan(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.lessThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.lessThanOrEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.equal(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.equal(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.notNull((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates(this.not(this.notEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.notEqual(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.none((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates(this.not(this.isDistinctFrom(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.0))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse(this.not(this.isDistinctFrom(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))));
    }

    @Test
    public void testFromUnprocessableInPredicate() {
        this.assertUnsupportedPredicate(this.in(this.unprocessableExpression1(C_BIGINT), (List<RowExpression>)ImmutableList.of((Object)LogicalRowExpressions.TRUE_CONSTANT)));
        this.assertUnsupportedPredicate(this.in((RowExpression)C_BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)this.unprocessableExpression1(C_BOOLEAN))));
        this.assertUnsupportedPredicate(this.in((RowExpression)C_BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)LogicalRowExpressions.TRUE_CONSTANT, (Object)this.unprocessableExpression1(C_BOOLEAN))));
        this.assertUnsupportedPredicate(this.not(this.in((RowExpression)C_BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)this.unprocessableExpression1(C_BOOLEAN)))));
    }

    @Test
    public void testFromInPredicate() {
        this.assertPredicateTranslates(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertPredicateTranslates(this.in((RowExpression)C_COLOR, (List<RowExpression>)ImmutableList.of((Object)this.colorLiteral(1L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L))));
        this.assertPredicateTranslates(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.in((RowExpression)C_COLOR, (List<RowExpression>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.bigintIn((RowExpression)C_BIGINT, (List<Long>)ImmutableList.of((Object)1L, (Object)2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.in((RowExpression)C_COLOR, (List<RowExpression>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L)))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false))));
    }

    @Test
    public void testFromBetweenPredicate() {
        this.assertPredicateTranslates(this.between((RowExpression)C_BIGINT, this.bigintLiteral(1L), this.bigintLiteral(2L)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates(this.between(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.cast(this.bigintLiteral(1L), (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse(this.between((RowExpression)C_BIGINT, this.bigintLiteral(1L), this.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates(this.not(this.between((RowExpression)C_BIGINT, this.bigintLiteral(1L), this.bigintLiteral(2L))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.between(this.cast((RowExpression)C_INTEGER, (Type)DoubleType.DOUBLE), this.cast(this.bigintLiteral(1L), (Type)DoubleType.DOUBLE), this.doubleLiteral(2.1))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates(this.not(this.between((RowExpression)C_BIGINT, this.bigintLiteral(1L), this.nullLiteral((Type)BigintType.BIGINT))), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromIsNullPredicate() {
        this.assertPredicateTranslates(TestRowExpressionDomainTranslator.isNull((RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(TestRowExpressionDomainTranslator.isNull((RowExpression)C_HYPER_LOG_LOG), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
        this.assertPredicateTranslates(this.not(TestRowExpressionDomainTranslator.isNull((RowExpression)C_BIGINT)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(this.not(TestRowExpressionDomainTranslator.isNull((RowExpression)C_HYPER_LOG_LOG)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
    }

    @Test
    public void testFromIsNotNullPredicate() {
        this.assertPredicateTranslates(this.isNotNull((RowExpression)C_BIGINT), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(this.isNotNull((RowExpression)C_HYPER_LOG_LOG), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
        this.assertPredicateTranslates(this.not(this.isNotNull((RowExpression)C_BIGINT)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(this.not(this.isNotNull((RowExpression)C_HYPER_LOG_LOG)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
    }

    @Test
    public void testFromBooleanLiteralPredicate() {
        this.assertPredicateIsAlwaysTrue((RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        this.assertPredicateIsAlwaysFalse(this.not((RowExpression)LogicalRowExpressions.TRUE_CONSTANT));
        this.assertPredicateIsAlwaysFalse((RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        this.assertPredicateIsAlwaysTrue(this.not((RowExpression)LogicalRowExpressions.FALSE_CONSTANT));
    }

    @Test
    public void testFromNullLiteralPredicate() {
        this.assertPredicateIsAlwaysFalse(this.nullLiteral((Type)UnknownType.UNKNOWN));
        this.assertPredicateIsAlwaysFalse(this.not(this.nullLiteral((Type)UnknownType.UNKNOWN)));
    }

    @Test
    public void testExpressionConstantFolding() {
        FunctionHandle hex = this.metadata.getFunctionAndTypeManager().lookupFunction("from_hex", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        RowExpression originalExpression = this.greaterThan((RowExpression)C_VARBINARY, (RowExpression)Expressions.call((String)"from_hex", (FunctionHandle)hex, (Type)VarbinaryType.VARBINARY, (RowExpression[])new RowExpression[]{this.stringLiteral("123456")}));
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Slice value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)"123456"));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARBINARY, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarbinaryType.VARBINARY, (Object)value), (Range[])new Range[0]), (boolean)false))));
        RowExpression expression = this.toPredicate((TupleDomain<VariableReferenceExpression>)result.getTupleDomain());
        Assert.assertEquals((Object)expression, (Object)this.greaterThan((RowExpression)C_VARBINARY, this.varbinaryLiteral(value)));
    }

    @Test
    public void testConjunctExpression() {
        RowExpression expression = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_DOUBLE, this.doubleLiteral(0.0)), this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(0L))});
        this.assertPredicateTranslates(expression, (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false), (Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)false))));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<VariableReferenceExpression>)this.fromPredicate(expression).getTupleDomain()), (Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)C_DOUBLE, this.doubleLiteral(0.0)), this.greaterThan((RowExpression)C_BIGINT, this.bigintLiteral(0L))}));
    }

    @Test
    void testMultipleCoercionsOnSymbolSide() {
        this.assertPredicateTranslates(this.greaterThan(this.cast(this.cast((RowExpression)C_SMALLINT, (Type)RealType.REAL), (Type)DoubleType.DOUBLE), this.doubleLiteral(3.7)), (TupleDomain<VariableReferenceExpression>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_SMALLINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)SmallintType.SMALLINT, (Object)3L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testNumericTypeTranslation() {
        this.testNumericTypeTranslationChain(new NumericValues(C_DECIMAL_26_5, TestRowExpressionDomainTranslator.longDecimal("-999999999999999999999.99999"), TestRowExpressionDomainTranslator.longDecimal("-22.00000"), TestRowExpressionDomainTranslator.longDecimal("-44.55569"), TestRowExpressionDomainTranslator.longDecimal("23.00000"), TestRowExpressionDomainTranslator.longDecimal("44.55567"), TestRowExpressionDomainTranslator.longDecimal("999999999999999999999.99999")), new NumericValues(C_DECIMAL_23_4, TestRowExpressionDomainTranslator.longDecimal("-9999999999999999999.9999"), TestRowExpressionDomainTranslator.longDecimal("-22.0000"), TestRowExpressionDomainTranslator.longDecimal("-44.5557"), TestRowExpressionDomainTranslator.longDecimal("23.0000"), TestRowExpressionDomainTranslator.longDecimal("44.5556"), TestRowExpressionDomainTranslator.longDecimal("9999999999999999999.9999")), new NumericValues(C_BIGINT, Long.MIN_VALUE, -22L, -45L, 23L, 44L, Long.MAX_VALUE), new NumericValues(C_DECIMAL_21_3, TestRowExpressionDomainTranslator.longDecimal("-999999999999999999.999"), TestRowExpressionDomainTranslator.longDecimal("-22.000"), TestRowExpressionDomainTranslator.longDecimal("-44.556"), TestRowExpressionDomainTranslator.longDecimal("23.000"), TestRowExpressionDomainTranslator.longDecimal("44.555"), TestRowExpressionDomainTranslator.longDecimal("999999999999999999.999")), new NumericValues(C_DECIMAL_12_2, TestRowExpressionDomainTranslator.shortDecimal("-9999999999.99"), TestRowExpressionDomainTranslator.shortDecimal("-22.00"), TestRowExpressionDomainTranslator.shortDecimal("-44.56"), TestRowExpressionDomainTranslator.shortDecimal("23.00"), TestRowExpressionDomainTranslator.shortDecimal("44.55"), TestRowExpressionDomainTranslator.shortDecimal("9999999999.99")), new NumericValues(C_INTEGER, Integer.MIN_VALUE, -22L, -45L, 23L, 44L, Integer.MAX_VALUE), new NumericValues(C_DECIMAL_6_1, TestRowExpressionDomainTranslator.shortDecimal("-99999.9"), TestRowExpressionDomainTranslator.shortDecimal("-22.0"), TestRowExpressionDomainTranslator.shortDecimal("-44.6"), TestRowExpressionDomainTranslator.shortDecimal("23.0"), TestRowExpressionDomainTranslator.shortDecimal("44.5"), TestRowExpressionDomainTranslator.shortDecimal("99999.9")), new NumericValues(C_SMALLINT, -32768L, -22L, -45L, 23L, 44L, 32767L), new NumericValues(C_DECIMAL_3_0, TestRowExpressionDomainTranslator.shortDecimal("-999"), TestRowExpressionDomainTranslator.shortDecimal("-22"), TestRowExpressionDomainTranslator.shortDecimal("-45"), TestRowExpressionDomainTranslator.shortDecimal("23"), TestRowExpressionDomainTranslator.shortDecimal("44"), TestRowExpressionDomainTranslator.shortDecimal("999")), new NumericValues(C_TINYINT, -128L, -22L, -45L, 23L, 44L, 127L), new NumericValues(C_DECIMAL_2_0, TestRowExpressionDomainTranslator.shortDecimal("-99"), TestRowExpressionDomainTranslator.shortDecimal("-22"), TestRowExpressionDomainTranslator.shortDecimal("-45"), TestRowExpressionDomainTranslator.shortDecimal("23"), TestRowExpressionDomainTranslator.shortDecimal("44"), TestRowExpressionDomainTranslator.shortDecimal("99")));
        this.testNumericTypeTranslationChain(new NumericValues(C_DOUBLE, -1.7976931348623157E308, -22.0, -44.5556836, 23.0, 44.5556789, Double.MAX_VALUE), new NumericValues(C_REAL, this.realValue(-3.4028235E38f), this.realValue(-22.0f), this.realValue(-44.555687f), this.realValue(23.0f), this.realValue(44.555676f), this.realValue(Float.MAX_VALUE)));
    }

    private void testNumericTypeTranslationChain(NumericValues ... translationChain) {
        for (int literalIndex = 0; literalIndex < translationChain.length; ++literalIndex) {
            for (int columnIndex = literalIndex + 1; columnIndex < translationChain.length; ++columnIndex) {
                NumericValues literal = translationChain[literalIndex];
                NumericValues column = translationChain[columnIndex];
                this.testNumericTypeTranslation(column, literal);
            }
        }
    }

    private void testNumericTypeTranslation(NumericValues columnValues, NumericValues literalValues) {
        VariableReferenceExpression columnSymbol;
        Type columnType = columnValues.getInput().getType();
        Type literalType = literalValues.getInput().getType();
        Type superType = (Type)this.metadata.getFunctionAndTypeManager().getCommonSuperType(columnType, literalType).orElseThrow(() -> new IllegalArgumentException("incompatible types in test (" + columnType + ", " + literalType + ")"));
        RowExpression max = LiteralEncoder.toRowExpression(literalValues.getMax(), (Type)literalType);
        RowExpression min = LiteralEncoder.toRowExpression(literalValues.getMin(), (Type)literalType);
        RowExpression integerPositive = LiteralEncoder.toRowExpression(literalValues.getIntegerPositive(), (Type)literalType);
        RowExpression integerNegative = LiteralEncoder.toRowExpression(literalValues.getIntegerNegative(), (Type)literalType);
        RowExpression fractionalPositive = LiteralEncoder.toRowExpression(literalValues.getFractionalPositive(), (Type)literalType);
        RowExpression fractionalNegative = LiteralEncoder.toRowExpression(literalValues.getFractionalNegative(), (Type)literalType);
        if (!literalType.equals(superType)) {
            max = this.cast(max, superType);
            min = this.cast(min, superType);
            integerPositive = this.cast(integerPositive, superType);
            integerNegative = this.cast(integerNegative, superType);
            fractionalPositive = this.cast(fractionalPositive, superType);
            fractionalNegative = this.cast(fractionalNegative, superType);
        }
        VariableReferenceExpression columnExpression = columnSymbol = columnValues.getInput();
        if (!columnType.equals(superType)) {
            columnExpression = this.cast((RowExpression)columnExpression, superType);
        }
        this.testSimpleComparison(this.greaterThanOrEqual((RowExpression)columnExpression, integerPositive), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison(this.greaterThanOrEqual((RowExpression)columnExpression, integerNegative), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison(this.greaterThanOrEqual((RowExpression)columnExpression, max), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison(this.greaterThanOrEqual((RowExpression)columnExpression, min), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.greaterThanOrEqual((RowExpression)columnExpression, fractionalPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison(this.greaterThanOrEqual((RowExpression)columnExpression, fractionalNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison(this.greaterThan((RowExpression)columnExpression, integerPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison(this.greaterThan((RowExpression)columnExpression, integerNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison(this.greaterThan((RowExpression)columnExpression, max), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison(this.greaterThan((RowExpression)columnExpression, min), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.greaterThan((RowExpression)columnExpression, fractionalPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison(this.greaterThan((RowExpression)columnExpression, fractionalNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison(this.lessThanOrEqual((RowExpression)columnExpression, integerPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison(this.lessThanOrEqual((RowExpression)columnExpression, integerNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison(this.lessThanOrEqual((RowExpression)columnExpression, max), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison(this.lessThanOrEqual((RowExpression)columnExpression, min), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.lessThanOrEqual((RowExpression)columnExpression, fractionalPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison(this.lessThanOrEqual((RowExpression)columnExpression, fractionalNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison(this.lessThan((RowExpression)columnExpression, integerPositive), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison(this.lessThan((RowExpression)columnExpression, integerNegative), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison(this.lessThan((RowExpression)columnExpression, max), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison(this.lessThan((RowExpression)columnExpression, min), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.lessThan((RowExpression)columnExpression, fractionalPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison(this.lessThan((RowExpression)columnExpression, fractionalNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison(this.equal((RowExpression)columnExpression, integerPositive), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison(this.equal((RowExpression)columnExpression, integerNegative), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison(this.equal((RowExpression)columnExpression, max), columnSymbol, Domain.none((Type)columnType));
        this.testSimpleComparison(this.equal((RowExpression)columnExpression, min), columnSymbol, Domain.none((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.equal((RowExpression)columnExpression, fractionalPositive), columnSymbol, Domain.none((Type)columnType));
            this.testSimpleComparison(this.equal((RowExpression)columnExpression, fractionalNegative), columnSymbol, Domain.none((Type)columnType));
        }
        this.testSimpleComparison(this.notEqual((RowExpression)columnExpression, integerPositive), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)false));
        this.testSimpleComparison(this.notEqual((RowExpression)columnExpression, integerNegative), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)false));
        this.testSimpleComparison(this.notEqual((RowExpression)columnExpression, max), columnSymbol, Domain.notNull((Type)columnType));
        this.testSimpleComparison(this.notEqual((RowExpression)columnExpression, min), columnSymbol, Domain.notNull((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.notEqual((RowExpression)columnExpression, fractionalPositive), columnSymbol, Domain.notNull((Type)columnType));
            this.testSimpleComparison(this.notEqual((RowExpression)columnExpression, fractionalNegative), columnSymbol, Domain.notNull((Type)columnType));
        }
        this.testSimpleComparison(this.isDistinctFrom((RowExpression)columnExpression, integerPositive), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)true));
        this.testSimpleComparison(this.isDistinctFrom((RowExpression)columnExpression, integerNegative), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)true));
        this.testSimpleComparison(this.isDistinctFrom((RowExpression)columnExpression, max), columnSymbol, Domain.all((Type)columnType));
        this.testSimpleComparison(this.isDistinctFrom((RowExpression)columnExpression, min), columnSymbol, Domain.all((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison(this.isDistinctFrom((RowExpression)columnExpression, fractionalPositive), columnSymbol, Domain.all((Type)columnType));
            this.testSimpleComparison(this.isDistinctFrom((RowExpression)columnExpression, fractionalNegative), columnSymbol, Domain.all((Type)columnType));
        }
    }

    @Test
    public void testLegacyCharComparedToVarcharExpression() {
        this.metadata = MetadataManager.createTestMetadataManager((FeaturesConfig)new FeaturesConfig().setLegacyCharToVarcharCoercion(true));
        this.domainTranslator = new RowExpressionDomainTranslator(this.metadata);
        String maxCodePoint = new String(Character.toChars(0x10FFFF));
        this.testSimpleComparison(this.greaterThanOrEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison(this.greaterThanOrEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Range.greaterThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.greaterThanOrEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.greaterThan(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison(this.greaterThan(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.greaterThan(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.lessThanOrEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison(this.lessThanOrEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.lessThanOrEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.lessThan(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison(this.lessThan(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Range.lessThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.lessThan(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.equal(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Domain.none((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison(this.equal(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Range.equal((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison(this.equal(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Domain.none((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison(this.notEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Domain.notNull((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison(this.notEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")), (Range[])new Range[]{Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890"))}), (boolean)false));
        this.testSimpleComparison(this.notEqual(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Domain.notNull((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison(this.isDistinctFrom(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("123456789")), C_CHAR, Domain.all((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison(this.isDistinctFrom(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("1234567890")), C_CHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")), (Range[])new Range[]{Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890"))}), (boolean)true));
        this.testSimpleComparison(this.isDistinctFrom(this.cast((RowExpression)C_CHAR, (Type)VarcharType.VARCHAR), this.stringLiteral("12345678901")), C_CHAR, Domain.all((Type)CharType.createCharType((long)10L)));
    }

    @Test
    public void testCharComparedToVarcharExpression() {
        CharType charType = CharType.createCharType((long)10L);
        this.testSimpleComparison(this.equal((RowExpression)C_CHAR, this.cast(this.stringLiteral("abc"), (Type)charType)), C_CHAR, Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"abc")));
        charType = CharType.createCharType((long)11L);
        this.assertUnsupportedPredicate(this.equal(this.cast((RowExpression)C_CHAR, (Type)charType), this.cast(this.stringLiteral("abc12345678"), (Type)charType)));
    }

    @Test
    public void testBooleanAll() {
        RowExpression rowExpression = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equal((RowExpression)C_BOOLEAN, (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN)), this.equal((RowExpression)C_BOOLEAN, (RowExpression)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN))}), TestRowExpressionDomainTranslator.isNull((RowExpression)C_BOOLEAN)});
        DomainTranslator.ExtractionResult result = this.fromPredicate(rowExpression);
        TupleDomain tupleDomain = result.getTupleDomain();
        Assert.assertTrue((boolean)tupleDomain.isAll());
    }

    @Test
    public void testFromPredicateBoolean() {
        this.testSimpleComparison((RowExpression)C_BOOLEAN, C_BOOLEAN, Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)Boolean.TRUE));
        this.testSimpleComparison(this.not((RowExpression)C_BOOLEAN), C_BOOLEAN, Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)Boolean.FALSE));
    }

    private void assertPredicateTranslates(RowExpression expression, TupleDomain<VariableReferenceExpression> tupleDomain) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Assert.assertEquals((Object)result.getTupleDomain(), tupleDomain);
    }

    private void assertPredicateIsAlwaysTrue(RowExpression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<VariableReferenceExpression>)TupleDomain.all());
    }

    private void assertPredicateIsAlwaysFalse(RowExpression expression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
    }

    private RowExpression toPredicate(TupleDomain<VariableReferenceExpression> tupleDomain) {
        return this.domainTranslator.toPredicate(tupleDomain);
    }

    private DomainTranslator.ExtractionResult fromPredicate(RowExpression originalPredicate) {
        return this.domainTranslator.fromPredicate(SessionTestUtils.TEST_SESSION.toConnectorSession(), originalPredicate, DomainTranslator.BASIC_COLUMN_EXTRACTOR);
    }

    private RowExpression nullLiteral(Type type) {
        return Expressions.constantNull((Type)type);
    }

    private RowExpression stringLiteral(String value) {
        return Expressions.constant((Object)Slices.utf8Slice((String)value), (Type)VarcharType.VARCHAR);
    }

    private RowExpression bigintLiteral(long value) {
        return Expressions.constant((Object)value, (Type)BigintType.BIGINT);
    }

    private RowExpression doubleLiteral(double value) {
        return Expressions.constant((Object)value, (Type)DoubleType.DOUBLE);
    }

    private RowExpression varbinaryLiteral(Slice value) {
        return Expressions.constant((Object)value, (Type)VarbinaryType.VARBINARY);
    }

    private long realValue(float value) {
        return Float.floatToIntBits(value);
    }

    private RowExpression realLiteral(float value) {
        return Expressions.constant((Object)this.realValue(value), (Type)RealType.REAL);
    }

    private RowExpression colorLiteral(long value) {
        return Expressions.constant((Object)value, (Type)ColorType.COLOR);
    }

    private static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    private static Slice longDecimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }

    private static RowExpression isNull(RowExpression expression) {
        return new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{expression});
    }

    private RowExpression cast(RowExpression expression, Type toType) {
        FunctionHandle cast = this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, expression.getType(), toType);
        return Expressions.call((String)CastType.CAST.name(), (FunctionHandle)cast, (Type)toType, (RowExpression[])new RowExpression[]{expression});
    }

    private RowExpression not(RowExpression expression) {
        return Expressions.call((String)"not", (FunctionHandle)new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).notFunction(), (Type)expression.getType(), (RowExpression[])new RowExpression[]{expression});
    }

    private RowExpression in(RowExpression value, List<RowExpression> inList) {
        return new SpecialFormExpression(SpecialFormExpression.Form.IN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.builder().add((Object)value).addAll(inList).build());
    }

    private RowExpression isNotNull(RowExpression expression) {
        return this.not(TestRowExpressionDomainTranslator.isNull(expression));
    }

    private RowExpression bigintIn(RowExpression value, List<Long> inList) {
        List arguments = (List)inList.stream().map(argument -> Expressions.constant((Object)argument, (Type)BigintType.BIGINT)).collect(ImmutableList.toImmutableList());
        return this.in(value, arguments);
    }

    private RowExpression binaryOperator(OperatorType operatorType, RowExpression left, RowExpression right) {
        return Expressions.call((String)operatorType.name(), (FunctionHandle)this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }

    private RowExpression between(RowExpression value, RowExpression min, RowExpression max) {
        return Expressions.call((String)OperatorType.BETWEEN.name(), (FunctionHandle)this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes((Type[])new Type[]{value.getType(), min.getType(), max.getType()})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{value, min, max});
    }

    private RowExpression isDistinctFrom(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.IS_DISTINCT_FROM, left, right);
    }

    private RowExpression greaterThan(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.GREATER_THAN, left, right);
    }

    private RowExpression lessThan(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.LESS_THAN, left, right);
    }

    private RowExpression greaterThanOrEqual(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.GREATER_THAN_OR_EQUAL, left, right);
    }

    private RowExpression lessThanOrEqual(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.LESS_THAN_OR_EQUAL, left, right);
    }

    private RowExpression equal(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.EQUAL, left, right);
    }

    private RowExpression notEqual(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.NOT_EQUAL, left, right);
    }

    private RowExpression unprocessableExpression1(VariableReferenceExpression expression) {
        return this.greaterThan((RowExpression)expression, (RowExpression)expression);
    }

    private RowExpression unprocessableExpression2(VariableReferenceExpression expression) {
        return this.lessThan((RowExpression)expression, (RowExpression)expression);
    }

    private RowExpression randPredicate(VariableReferenceExpression expression) {
        CallExpression random = Expressions.call((String)"random", (FunctionHandle)this.metadata.getFunctionAndTypeManager().lookupFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0])), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[0]);
        return this.greaterThan((RowExpression)expression, (RowExpression)Expressions.call((String)CastType.CAST.name(), (FunctionHandle)this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, (Type)DoubleType.DOUBLE, expression.getType()), (Type)expression.getType(), (RowExpression[])new RowExpression[]{random}));
    }

    private void assertUnsupportedPredicate(RowExpression expression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)expression);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.all());
    }

    private void testSimpleComparison(RowExpression expression, VariableReferenceExpression input, Range expectedDomainRange) {
        this.testSimpleComparison(expression, input, Domain.create((ValueSet)ValueSet.ofRanges((Range)expectedDomainRange, (Range[])new Range[0]), (boolean)false));
    }

    private void testSimpleComparison(RowExpression expression, VariableReferenceExpression input, Domain domain) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        TupleDomain actual = result.getTupleDomain();
        TupleDomain expected = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)input, (Object)domain));
        if (!actual.equals((Object)expected)) {
            Assert.fail((String)String.format("for comparison [%s] expected %s but found %s", expression.toString(), expected.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties()), actual.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties())));
        }
    }

    private static class NumericValues<T> {
        private final VariableReferenceExpression input;
        private final T min;
        private final T integerNegative;
        private final T fractionalNegative;
        private final T integerPositive;
        private final T fractionalPositive;
        private final T max;

        private NumericValues(VariableReferenceExpression input, T min, T integerNegative, T fractionalNegative, T integerPositive, T fractionalPositive, T max) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.min = Objects.requireNonNull(min, "min is null");
            this.integerNegative = Objects.requireNonNull(integerNegative, "integerNegative is null");
            this.fractionalNegative = Objects.requireNonNull(fractionalNegative, "fractionalNegative is null");
            this.integerPositive = Objects.requireNonNull(integerPositive, "integerPositive is null");
            this.fractionalPositive = Objects.requireNonNull(fractionalPositive, "fractionalPositive is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public VariableReferenceExpression getInput() {
            return this.input;
        }

        public T getMin() {
            return this.min;
        }

        public T getIntegerNegative() {
            return this.integerNegative;
        }

        public T getFractionalNegative() {
            return this.fractionalNegative;
        }

        public T getIntegerPositive() {
            return this.integerPositive;
        }

        public T getFractionalPositive() {
            return this.fractionalPositive;
        }

        public T getMax() {
            return this.max;
        }

        public boolean isFractional() {
            return this.input.getType() == DoubleType.DOUBLE || this.input.getType() == RealType.REAL || this.input.getType() instanceof DecimalType && ((DecimalType)this.input.getType()).getScale() > 0;
        }
    }
}

