/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.SchedulingOrderVisitor;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSchedulingOrderVisitor {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testJoinOrder() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        TableScanNode a = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        TableScanNode b = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        List order = SchedulingOrderVisitor.scheduleOrder((PlanNode)planBuilder.join(JoinNode.Type.INNER, (PlanNode)a, (PlanNode)b, new JoinNode.EquiJoinClause[0]));
        Assert.assertEquals((Collection)order, (Collection)ImmutableList.of((Object)b.getId(), (Object)a.getId()));
    }

    @Test
    public void testIndexJoinOrder() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        TableScanNode a = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        TableScanNode b = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        List order = SchedulingOrderVisitor.scheduleOrder((PlanNode)planBuilder.indexJoin(IndexJoinNode.Type.INNER, a, b));
        Assert.assertEquals((Collection)order, (Collection)ImmutableList.of((Object)b.getId(), (Object)a.getId()));
    }

    @Test
    public void testSemiJoinOrder() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        VariableReferenceExpression sourceJoin = planBuilder.variable("sourceJoin");
        TableScanNode a = planBuilder.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)sourceJoin), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)sourceJoin, (Object)new TestingColumnHandle("sourceJoin")));
        VariableReferenceExpression filteringSource = planBuilder.variable("filteringSource");
        TableScanNode b = planBuilder.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)filteringSource), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)filteringSource, (Object)new TestingColumnHandle("filteringSource")));
        List order = SchedulingOrderVisitor.scheduleOrder((PlanNode)planBuilder.semiJoin(sourceJoin, filteringSource, planBuilder.variable("semiJoinOutput"), Optional.empty(), Optional.empty(), (PlanNode)a, (PlanNode)b));
        Assert.assertEquals((Collection)order, (Collection)ImmutableList.of((Object)b.getId(), (Object)a.getId()));
    }
}

