/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestUseDefaultsforCorrelatedAggregations
extends BasePlanTest {
    private ImmutableMap<String, String> nationColumns = ImmutableMap.builder().put((Object)"regionkey", (Object)"regionkey").put((Object)"nationkey", (Object)"nationkey").put((Object)"name", (Object)"name").put((Object)"comment", (Object)"comment").build();

    @Test
    public void testConversionOfCrossJoinWithLeftOuterJoinToInnerJoin() {
        String query = "select * from nation n where (select count(*) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.project(PlanMatchPattern.filter("coalesce(count, 0) > 0", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"count_6"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_6", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey"))))))))));
        query = "select * from nation n where (select min(custkey) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.project(PlanMatchPattern.filter("min > 0", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"min", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"min_27"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"min_27", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"custkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"custkey", (Object)"custkey"))))))))));
        query = "select * from nation n where (select max(custkey) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.project(PlanMatchPattern.filter("max > 0", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"max_27"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max_27", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"custkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"custkey", (Object)"custkey"))))))))));
        query = "select * from nation n where (select sum(custkey) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.project(PlanMatchPattern.filter("sum > 0", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"sum_27"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum_27", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"custkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"custkey", (Object)"custkey"))))))))));
        query = "select * from nation n where (select avg(custkey) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.project(PlanMatchPattern.filter("avg > double '0.0'", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"avg", PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"avg_27"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"avg_27", PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"custkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"custkey", (Object)"custkey"))))))))));
        query = "select * from nation n where (select arbitrary(custkey) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.project(PlanMatchPattern.filter("arbitrary > 0", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"arbitrary", PlanMatchPattern.functionCall("arbitrary", (List<String>)ImmutableList.of((Object)"arbitrary_27"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"arbitrary_27", PlanMatchPattern.functionCall("arbitrary", (List<String>)ImmutableList.of((Object)"custkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"custkey", (Object)"custkey"))))))))));
        query = "select * from nation n where (select max_by(acctbal, nationkey) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.values("expr_25", "expr_26"))))));
        query = "select * from nation n where (select count_if(acctbal > 0) from customer c where n.nationkey=c.nationkey)>0";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "nationkey_1")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", this.nationColumns)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_1", (Object)"nationkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.values("expr_24"))))));
    }
}

