/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class BasePlanTest {
    private final LocalQueryRunnerSupplier queryRunnerSupplier;
    private final ObjectMapper objectMapper;
    private LocalQueryRunner queryRunner;

    public BasePlanTest() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public BasePlanTest(Map<String, String> sessionProperties) {
        this.queryRunnerSupplier = () -> BasePlanTest.createQueryRunner(sessionProperties);
        this.objectMapper = BasePlanTest.createObjectMapper();
    }

    public BasePlanTest(LocalQueryRunnerSupplier supplier) {
        this.queryRunnerSupplier = Objects.requireNonNull(supplier, "queryRunnerSupplier is null");
        this.objectMapper = BasePlanTest.createObjectMapper();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private static ObjectMapper createObjectMapper() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        return new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer((TypeManager)typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)blockEncodingSerde))).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    private static LocalQueryRunner createQueryRunner(Map<String, String> sessionProperties) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1");
        sessionProperties.entrySet().forEach(entry -> sessionBuilder.setSystemProperty((String)entry.getKey(), (String)entry.getValue()));
        LocalQueryRunner queryRunner = new LocalQueryRunner(sessionBuilder.build(), new FeaturesConfig(), new NodeSpillConfig(), false, false, BasePlanTest.createObjectMapper());
        queryRunner.createCatalog((String)queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @BeforeClass
    public final void initPlanTest() throws Exception {
        this.queryRunner = this.queryRunnerSupplier.get();
    }

    @AfterClass(alwaysRun=true)
    public final void destroyPlanTest() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    public ConnectorId getCurrentConnectorId() {
        return (ConnectorId)((Optional)this.queryRunner.inTransaction(transactionSession -> this.queryRunner.getMetadata().getCatalogHandle(transactionSession, (String)transactionSession.getCatalog().get()))).get();
    }

    protected LocalQueryRunner getQueryRunner() {
        return this.queryRunner;
    }

    protected void assertPlan(String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    protected void assertPlan(String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlan(sql, session, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, pattern, this.queryRunner.getPlanOptimizers(true));
    }

    protected void assertPlan(String sql, Session session, PlanMatchPattern pattern, boolean forceSingleNode) {
        this.assertPlan(sql, session, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, pattern, this.queryRunner.getPlanOptimizers(forceSingleNode));
    }

    protected void assertPlan(String sql, Optimizer.PlanStage stage, PlanMatchPattern pattern) {
        List optimizers = this.queryRunner.getPlanOptimizers(true);
        this.assertPlan(sql, this.queryRunner.getDefaultSession(), stage, pattern, optimizers);
    }

    protected void assertPlan(String sql, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.assertPlan(sql, this.queryRunner.getDefaultSession(), Optimizer.PlanStage.OPTIMIZED, pattern, optimizers);
    }

    protected void assertPlan(String sql, Optimizer.PlanStage stage, PlanMatchPattern pattern, Predicate<PlanOptimizer> optimizerPredicate) {
        List<PlanOptimizer> optimizers = this.queryRunner.getPlanOptimizers(true).stream().filter(optimizerPredicate).collect(Collectors.toList());
        this.assertPlan(sql, this.queryRunner.getDefaultSession(), stage, pattern, optimizers);
    }

    protected void assertPlan(String sql, Session session, Optimizer.PlanStage stage, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, optimizers, stage, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    protected void assertDistributedPlan(String sql, PlanMatchPattern pattern) {
        this.assertDistributedPlan(sql, this.getQueryRunner().getDefaultSession(), pattern);
    }

    protected void assertDistributedPlan(String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlanWithSession(sql, session, false, pattern);
    }

    protected void assertMinimallyOptimizedPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.queryRunner.getMetadata().getFunctionAndTypeManager()), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        this.assertPlan(sql, this.queryRunner.getDefaultSession(), Optimizer.PlanStage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            planValidator.accept(actualPlan);
            return null;
        });
    }

    protected void assertPlanValidatorWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, Consumer<Plan> planValidator) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            planValidator.accept(actualPlan);
            return null;
        });
    }

    protected void assertPlanFailedWithException(String sql, Session session, @Language(value="RegExp") String expectedExceptionRegex) {
        block2: {
            try {
                this.queryRunner.inTransaction(session, transactionSession -> this.queryRunner.createPlan(transactionSession, sql, Optimizer.PlanStage.CREATED, true, WarningCollector.NOOP));
                Assert.fail((String)String.format("Expected query to fail: %s", sql));
            }
            catch (RuntimeException ex) {
                if (Strings.nullToEmpty((String)ex.getMessage()).matches(expectedExceptionRegex)) break block2;
                Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", ex.getMessage(), expectedExceptionRegex, sql), (Throwable)ex);
            }
        }
    }

    protected void assertPlanSucceeded(String sql, Session session) {
        try {
            this.queryRunner.inTransaction(session, transactionSession -> this.queryRunner.createPlan(transactionSession, sql, Optimizer.PlanStage.CREATED, true, WarningCollector.NOOP));
        }
        catch (RuntimeException ex) {
            Assert.fail((String)String.format("Query %s failed with exception message '%s'", sql, ex.getMessage()), (Throwable)ex);
        }
    }

    protected Plan plan(String sql) {
        return this.plan(sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED);
    }

    protected Plan plan(String sql, Optimizer.PlanStage stage) {
        return this.plan(sql, stage, true);
    }

    protected Plan plan(String sql, Optimizer.PlanStage stage, boolean forceSingleNode) {
        try {
            return (Plan)this.queryRunner.inTransaction(transactionSession -> this.queryRunner.createPlan(transactionSession, sql, stage, forceSingleNode, WarningCollector.NOOP));
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    protected Plan plan(String sql, Optimizer.PlanStage stage, Session session) {
        return this.plan(sql, stage, true, session);
    }

    protected Plan plan(String sql, Optimizer.PlanStage stage, boolean forceSingleNode, Session session) {
        try {
            return (Plan)this.queryRunner.inTransaction(session, transactionSession -> this.queryRunner.createPlan(transactionSession, sql, stage, forceSingleNode, WarningCollector.NOOP));
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    protected SubPlan subplan(String sql, Optimizer.PlanStage stage, boolean forceSingleNode) {
        return this.subplan(sql, stage, forceSingleNode, this.getQueryRunner().getDefaultSession());
    }

    protected SubPlan subplan(String sql, Optimizer.PlanStage stage, boolean forceSingleNode, Session session) {
        try {
            return (SubPlan)this.queryRunner.inTransaction(session, transactionSession -> {
                Plan plan = this.queryRunner.createPlan(transactionSession, sql, stage, forceSingleNode, WarningCollector.NOOP);
                return this.queryRunner.createSubPlans(transactionSession, plan, forceSingleNode);
            });
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    protected Metadata getMetadata() {
        return this.getQueryRunner().getMetadata();
    }

    public static interface LocalQueryRunnerSupplier {
        public LocalQueryRunner get() throws Exception;
    }
}

