/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public abstract class BaseStrictSymbolsMatcher
implements Matcher {
    private final Function<PlanNode, Set<VariableReferenceExpression>> getActual;

    public BaseStrictSymbolsMatcher(Function<PlanNode, Set<VariableReferenceExpression>> getActual) {
        this.getActual = Objects.requireNonNull(getActual, "getActual is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        try {
            this.getActual.apply(node);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        return new MatchResult(this.match(this.getActual.apply(node), this.getExpectedVariables(node, session, metadata, symbolAliases)));
    }

    protected abstract Set<VariableReferenceExpression> getExpectedVariables(PlanNode var1, Session var2, Metadata var3, SymbolAliases var4);

    boolean match(Set<VariableReferenceExpression> actual, Set<VariableReferenceExpression> expected) {
        if (expected.stream().anyMatch(variable -> variable.getType().equals(UnknownType.UNKNOWN))) {
            return ((ImmutableSet)actual.stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet())).equals(expected.stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet()));
        }
        return actual.equals(expected);
    }
}

