/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.JoinNode;
import java.util.Objects;
import java.util.Optional;

class EquiJoinClauseProvider
implements ExpectedValueProvider<JoinNode.EquiJoinClause> {
    private final SymbolAlias left;
    private final SymbolAlias right;

    EquiJoinClauseProvider(SymbolAlias left, SymbolAlias right) {
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    @Override
    public JoinNode.EquiJoinClause getExpectedValue(SymbolAliases aliases) {
        return new JoinNode.EquiJoinClause(new VariableReferenceExpression(Optional.empty(), this.left.toSymbol(aliases).getName(), (Type)BigintType.BIGINT), new VariableReferenceExpression(Optional.empty(), this.right.toSymbol(aliases).getName(), (Type)BigintType.BIGINT));
    }

    public String toString() {
        return this.left + " = " + this.right;
    }
}

