/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MergeJoinNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MergeJoinMatcher
implements Matcher {
    private final JoinNode.Type joinType;
    private final List<ExpectedValueProvider<JoinNode.EquiJoinClause>> equiCriteria;
    private final Optional<Expression> filter;

    MergeJoinMatcher(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> equiCriteria, Optional<Expression> filter) {
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.equiCriteria = Objects.requireNonNull(equiCriteria, "equiCriteria is null");
        this.filter = Objects.requireNonNull(filter, "filter can not be null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof MergeJoinNode)) {
            return false;
        }
        MergeJoinNode joinNode = (MergeJoinNode)node;
        return joinNode.getType() == this.joinType;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        MergeJoinNode joinNode = (MergeJoinNode)node;
        if (this.filter.isPresent()) {
            if (!joinNode.getFilter().isPresent()) {
                return MatchResult.NO_MATCH;
            }
            RowExpression expression = (RowExpression)joinNode.getFilter().get();
            if (!((Boolean)new RowExpressionVerifier(symbolAliases, metadata, session).process((Node)this.filter.get(), expression)).booleanValue()) {
                return MatchResult.NO_MATCH;
            }
        } else if (joinNode.getFilter().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (joinNode.getCriteria().size() != this.equiCriteria.size()) {
            return MatchResult.NO_MATCH;
        }
        Set actual = (Set)joinNode.getCriteria().stream().map(criteria -> ImmutableList.of((Object)criteria.getLeft().getName(), (Object)criteria.getRight().getName())).collect(ImmutableSet.toImmutableSet());
        Set expected = (Set)this.equiCriteria.stream().map(maker -> (JoinNode.EquiJoinClause)maker.getExpectedValue(symbolAliases)).map(criteria -> ImmutableList.of((Object)criteria.getLeft().getName(), (Object)criteria.getRight().getName())).collect(ImmutableSet.toImmutableSet());
        if (!expected.equals(actual)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.joinType).add("equiCriteria", this.equiCriteria).add("filter", this.filter.orElse(null)).toString();
    }
}

