/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class RowExpressionVerifier
extends AstVisitor<Boolean, RowExpression> {
    private final SymbolAliases symbolAliases;
    private final Metadata metadata;
    private final Session session;
    private final FunctionResolution functionResolution;
    private final Set<String> lambdaArguments;

    RowExpressionVerifier(SymbolAliases symbolAliases, Metadata metadata, Session session) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolLayout is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.functionResolution = new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver());
        this.lambdaArguments = new HashSet<String>();
    }

    protected Boolean visitNode(Node node, RowExpression context) {
        throw new IllegalStateException(String.format("Node %s is not supported", node));
    }

    protected Boolean visitArrayConstructor(ArrayConstructor node, RowExpression context) {
        if (context instanceof CallExpression) {
            if (!((CallExpression)context).getFunctionHandle().getName().equals("presto.default.array_constructor")) {
                return false;
            }
            for (int i = 0; i < node.getValues().size(); ++i) {
                if (((Boolean)this.process((Node)node.getValues().get(i), ((CallExpression)context).getArguments().get(i))).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (context instanceof ConstantExpression && ((ConstantExpression)context).getValue() instanceof IntArrayBlock) {
            IntArrayBlock block = (IntArrayBlock)((ConstantExpression)context).getValue();
            if (block.getPositionCount() != node.getValues().size()) {
                return false;
            }
            for (int i = 0; i < node.getValues().size(); ++i) {
                if (((Boolean)this.process((Node)node.getValues().get(i), Expressions.constant((Object)block.getInt(i), (Type)BigintType.BIGINT))).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected Boolean visitTryExpression(TryExpression expected, RowExpression actual) {
        if (!(actual instanceof CallExpression) || !this.functionResolution.isTryFunction(((CallExpression)actual).getFunctionHandle())) {
            return false;
        }
        LambdaDefinitionExpression lambdaExpression = (LambdaDefinitionExpression)((CallExpression)actual).getArguments().get(0);
        return (Boolean)this.process((Node)expected.getInnerExpression(), lambdaExpression.getBody());
    }

    protected Boolean visitCast(Cast expected, RowExpression actual) {
        if (actual instanceof ConstantExpression && expected.getExpression() instanceof Literal && expected.getType().equals(actual.getType().toString())) {
            Literal literal = (Literal)expected.getExpression();
            if (literal instanceof StringLiteral) {
                Object value = LiteralInterpreter.evaluate((ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession(), (ConstantExpression)((ConstantExpression)actual));
                String actualString = value instanceof Slice ? ((Slice)value).toStringUtf8() : String.valueOf(value);
                return ((StringLiteral)literal).getValue().equals(actualString);
            }
            return RowExpressionVerifier.getValueFromLiteral((Node)literal).equals(String.valueOf(LiteralInterpreter.evaluate((ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession(), (ConstantExpression)((ConstantExpression)actual))));
        }
        if (!(actual instanceof CallExpression) || !this.functionResolution.isCastFunction(((CallExpression)actual).getFunctionHandle())) {
            return false;
        }
        if (!(expected.getType().equalsIgnoreCase(actual.getType().toString()) || expected.getType().toLowerCase(Locale.ENGLISH).equals("varchar") && actual.getType().getTypeSignature().getBase().equals("varchar"))) {
            return false;
        }
        return (Boolean)this.process((Node)expected.getExpression(), ((CallExpression)actual).getArguments().get(0));
    }

    protected Boolean visitIfExpression(IfExpression expected, RowExpression actual) {
        if (!(actual instanceof SpecialFormExpression) || !((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.IF)) {
            return false;
        }
        return (Boolean)this.process((Node)expected.getCondition(), ((SpecialFormExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getTrueValue(), ((SpecialFormExpression)actual).getArguments().get(1)) != false && (Boolean)this.process((Node)expected.getFalseValue().orElse(new NullLiteral()), ((SpecialFormExpression)actual).getArguments().get(2)) != false;
    }

    protected Boolean visitSubscriptExpression(SubscriptExpression expected, RowExpression actual) {
        if (!(actual instanceof CallExpression) || !this.functionResolution.isSubscriptFunction(((CallExpression)actual).getFunctionHandle())) {
            return false;
        }
        return (Boolean)this.process((Node)expected.getBase(), ((CallExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getIndex(), ((CallExpression)actual).getArguments().get(1)) != false;
    }

    protected Boolean visitIsNullPredicate(IsNullPredicate expected, RowExpression actual) {
        if (!(actual instanceof SpecialFormExpression) || !((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.IS_NULL)) {
            return false;
        }
        return (Boolean)this.process((Node)expected.getValue(), ((SpecialFormExpression)actual).getArguments().get(0));
    }

    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate expected, RowExpression actual) {
        if (!(actual instanceof CallExpression) || !this.functionResolution.notFunction().equals(((CallExpression)actual).getFunctionHandle())) {
            return false;
        }
        RowExpression argument = (RowExpression)((CallExpression)actual).getArguments().get(0);
        if (!(argument instanceof SpecialFormExpression) || !((SpecialFormExpression)argument).getForm().equals((Object)SpecialFormExpression.Form.IS_NULL)) {
            return false;
        }
        return (Boolean)this.process((Node)expected.getValue(), ((SpecialFormExpression)argument).getArguments().get(0));
    }

    protected Boolean visitInPredicate(InPredicate expected, RowExpression actual) {
        if (actual instanceof SpecialFormExpression && ((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.IN)) {
            List arguments = ((SpecialFormExpression)actual).getArguments();
            if (expected.getValueList() instanceof InListExpression) {
                return (Boolean)this.process((Node)expected.getValue(), arguments.get(0)) != false && this.process(((InListExpression)expected.getValueList()).getValues(), arguments.subList(1, arguments.size()));
            }
            Preconditions.checkState((arguments.size() == 2 ? 1 : 0) != 0, (String)"Multiple expressions in actual value list %s, but expected value is not a list", arguments.subList(1, arguments.size()), (Object)expected.getValue());
            return (Boolean)this.process((Node)expected.getValue(), arguments.get(0)) != false && (Boolean)this.process((Node)expected.getValueList(), arguments.get(1)) != false;
        }
        return false;
    }

    protected Boolean visitLambdaExpression(LambdaExpression expected, RowExpression actual) {
        if (!(actual instanceof LambdaDefinitionExpression)) {
            return false;
        }
        LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)actual;
        if (lambda.getArguments().size() != expected.getArguments().size()) {
            return false;
        }
        for (int i = 0; i < lambda.getArguments().size(); ++i) {
            this.lambdaArguments.add((String)lambda.getArguments().get(i));
            if (((String)lambda.getArguments().get(i)).equals(((LambdaArgumentDeclaration)expected.getArguments().get(i)).getName().getValue())) continue;
            return false;
        }
        Boolean value = (Boolean)this.process((Node)expected.getBody(), lambda.getBody());
        lambda.getArguments().forEach(argument -> this.lambdaArguments.remove(argument));
        return value;
    }

    protected Boolean visitComparisonExpression(ComparisonExpression expected, RowExpression actual) {
        if (actual instanceof CallExpression) {
            FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(((CallExpression)actual).getFunctionHandle());
            if (!functionMetadata.getOperatorType().isPresent() || !((OperatorType)functionMetadata.getOperatorType().get()).isComparisonOperator()) {
                return false;
            }
            OperatorType actualOperatorType = (OperatorType)functionMetadata.getOperatorType().get();
            OperatorType expectedOperatorType = RowExpressionVerifier.getOperatorType(expected.getOperator());
            if (expectedOperatorType.equals((Object)actualOperatorType)) {
                if (actualOperatorType == OperatorType.EQUAL) {
                    return (Boolean)this.process((Node)expected.getLeft(), ((CallExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getRight(), ((CallExpression)actual).getArguments().get(1)) != false || (Boolean)this.process((Node)expected.getLeft(), ((CallExpression)actual).getArguments().get(1)) != false && (Boolean)this.process((Node)expected.getRight(), ((CallExpression)actual).getArguments().get(0)) != false;
                }
                return (Boolean)this.process((Node)expected.getLeft(), ((CallExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getRight(), ((CallExpression)actual).getArguments().get(1)) != false;
            }
        }
        return false;
    }

    private static OperatorType getOperatorType(ComparisonExpression.Operator operator) {
        OperatorType operatorType;
        switch (operator) {
            case EQUAL: {
                operatorType = OperatorType.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                operatorType = OperatorType.NOT_EQUAL;
                break;
            }
            case LESS_THAN: {
                operatorType = OperatorType.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                break;
            }
            case GREATER_THAN: {
                operatorType = OperatorType.GREATER_THAN;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                operatorType = OperatorType.GREATER_THAN_OR_EQUAL;
                break;
            }
            case IS_DISTINCT_FROM: {
                operatorType = OperatorType.IS_DISTINCT_FROM;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported comparison operator type: " + operator);
            }
        }
        return operatorType;
    }

    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression expected, RowExpression actual) {
        if (actual instanceof CallExpression) {
            FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(((CallExpression)actual).getFunctionHandle());
            if (!functionMetadata.getOperatorType().isPresent() || !((OperatorType)functionMetadata.getOperatorType().get()).isArithmeticOperator()) {
                return false;
            }
            OperatorType actualOperatorType = (OperatorType)functionMetadata.getOperatorType().get();
            OperatorType expectedOperatorType = RowExpressionVerifier.getOperatorType(expected.getOperator());
            if (expectedOperatorType.equals((Object)actualOperatorType)) {
                return (Boolean)this.process((Node)expected.getLeft(), ((CallExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getRight(), ((CallExpression)actual).getArguments().get(1)) != false;
            }
        }
        return false;
    }

    private static OperatorType getOperatorType(ArithmeticBinaryExpression.Operator operator) {
        OperatorType operatorType;
        switch (operator) {
            case ADD: {
                operatorType = OperatorType.ADD;
                break;
            }
            case SUBTRACT: {
                operatorType = OperatorType.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                operatorType = OperatorType.MULTIPLY;
                break;
            }
            case DIVIDE: {
                operatorType = OperatorType.DIVIDE;
                break;
            }
            case MODULUS: {
                operatorType = OperatorType.MODULUS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown arithmetic operator: " + operator);
            }
        }
        return operatorType;
    }

    protected Boolean visitGenericLiteral(GenericLiteral expected, RowExpression actual) {
        return this.compareLiteral((Node)expected, actual);
    }

    protected Boolean visitLongLiteral(LongLiteral expected, RowExpression actual) {
        return this.compareLiteral((Node)expected, actual);
    }

    protected Boolean visitDoubleLiteral(DoubleLiteral expected, RowExpression actual) {
        return this.compareLiteral((Node)expected, actual);
    }

    protected Boolean visitDecimalLiteral(DecimalLiteral expected, RowExpression actual) {
        return this.compareLiteral((Node)expected, actual);
    }

    protected Boolean visitBooleanLiteral(BooleanLiteral expected, RowExpression actual) {
        return this.compareLiteral((Node)expected, actual);
    }

    protected Boolean visitDereferenceExpression(DereferenceExpression expected, RowExpression actual) {
        if (!(actual instanceof SpecialFormExpression) || !((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.DEREFERENCE)) {
            return false;
        }
        SpecialFormExpression actualDereference = (SpecialFormExpression)actual;
        if (actualDereference.getArguments().size() == 2 && ((RowExpression)actualDereference.getArguments().get(0)).getType() instanceof RowType && actualDereference.getArguments().get(1) instanceof ConstantExpression) {
            RowType rowType = (RowType)((RowExpression)actualDereference.getArguments().get(0)).getType();
            Object value = LiteralInterpreter.evaluate((ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession(), (ConstantExpression)((ConstantExpression)actualDereference.getArguments().get(1)));
            Preconditions.checkState((boolean)(value instanceof Long));
            long index = (Long)value;
            Preconditions.checkState((index >= 0L && index < (long)rowType.getFields().size() ? 1 : 0) != 0);
            RowType.Field field = (RowType.Field)rowType.getFields().get(Math.toIntExact(index));
            Preconditions.checkState((boolean)field.getName().isPresent());
            return expected.getField().getValue().equals(field.getName().get()) && (Boolean)this.process((Node)expected.getBase(), actualDereference.getArguments().get(0)) != false;
        }
        return false;
    }

    private static String getValueFromLiteral(Node expression) {
        if (expression instanceof LongLiteral) {
            return String.valueOf(((LongLiteral)expression).getValue());
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).getValue());
        }
        if (expression instanceof DoubleLiteral) {
            return String.valueOf(((DoubleLiteral)expression).getValue());
        }
        if (expression instanceof DecimalLiteral) {
            return String.valueOf(((DecimalLiteral)expression).getValue());
        }
        if (expression instanceof GenericLiteral) {
            return ((GenericLiteral)expression).getValue();
        }
        throw new IllegalArgumentException("Unsupported literal expression type: " + expression.getClass().getName());
    }

    private Boolean compareLiteral(Node expected, RowExpression actual) {
        if (actual instanceof CallExpression && this.functionResolution.isCastFunction(((CallExpression)actual).getFunctionHandle())) {
            return RowExpressionVerifier.getValueFromLiteral(expected).equals(String.valueOf(RowExpressionInterpreter.rowExpressionInterpreter((RowExpression)actual, (Metadata)this.metadata, (ConnectorSession)this.session.toConnectorSession()).evaluate()));
        }
        if (actual instanceof ConstantExpression) {
            return RowExpressionVerifier.getValueFromLiteral(expected).equals(String.valueOf(LiteralInterpreter.evaluate((ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession(), (ConstantExpression)((ConstantExpression)actual))));
        }
        return false;
    }

    protected Boolean visitStringLiteral(StringLiteral expected, RowExpression actual) {
        Object value;
        if (actual instanceof CallExpression && this.functionResolution.isCastFunction(((CallExpression)actual).getFunctionHandle()) && (value = RowExpressionInterpreter.rowExpressionInterpreter((RowExpression)actual, (Metadata)this.metadata, (ConnectorSession)this.session.toConnectorSession()).evaluate()) instanceof Slice) {
            return expected.getValue().equals(((Slice)value).toStringUtf8());
        }
        if (actual instanceof ConstantExpression && actual.getType().getJavaType() == Slice.class) {
            String actualString = (String)LiteralInterpreter.evaluate((ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession(), (ConstantExpression)((ConstantExpression)actual));
            return expected.getValue().equals(actualString);
        }
        return false;
    }

    protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression expected, RowExpression actual) {
        if (actual instanceof SpecialFormExpression) {
            SpecialFormExpression actualLogicalBinary = (SpecialFormExpression)actual;
            if (expected.getOperator() == LogicalBinaryExpression.Operator.OR && actualLogicalBinary.getForm() == SpecialFormExpression.Form.OR || expected.getOperator() == LogicalBinaryExpression.Operator.AND && actualLogicalBinary.getForm() == SpecialFormExpression.Form.AND) {
                return (Boolean)this.process((Node)expected.getLeft(), actualLogicalBinary.getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getRight(), actualLogicalBinary.getArguments().get(1)) != false;
            }
        }
        return false;
    }

    protected Boolean visitBetweenPredicate(BetweenPredicate expected, RowExpression actual) {
        if (actual instanceof CallExpression && this.functionResolution.isBetweenFunction(((CallExpression)actual).getFunctionHandle())) {
            return (Boolean)this.process((Node)expected.getValue(), ((CallExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getMin(), ((CallExpression)actual).getArguments().get(1)) != false && (Boolean)this.process((Node)expected.getMax(), ((CallExpression)actual).getArguments().get(2)) != false;
        }
        return false;
    }

    protected Boolean visitNotExpression(NotExpression expected, RowExpression actual) {
        if (!(actual instanceof CallExpression) || !this.functionResolution.notFunction().equals(((CallExpression)actual).getFunctionHandle())) {
            return false;
        }
        return (Boolean)this.process((Node)expected.getValue(), ((CallExpression)actual).getArguments().get(0));
    }

    protected Boolean visitSymbolReference(SymbolReference expected, RowExpression actual) {
        if (!(actual instanceof VariableReferenceExpression)) {
            return false;
        }
        if (this.lambdaArguments.contains(expected.getName())) {
            return ((VariableReferenceExpression)actual).getName().equals(expected.getName());
        }
        return this.symbolAliases.get(expected.getName()).getName().equals(((VariableReferenceExpression)actual).getName());
    }

    protected Boolean visitCoalesceExpression(CoalesceExpression expected, RowExpression actual) {
        if (!(actual instanceof SpecialFormExpression) || !((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.COALESCE)) {
            return false;
        }
        SpecialFormExpression actualCoalesce = (SpecialFormExpression)actual;
        if (expected.getOperands().size() == actualCoalesce.getArguments().size()) {
            boolean verified = true;
            for (int i = 0; i < expected.getOperands().size(); ++i) {
                verified &= ((Boolean)this.process((Node)expected.getOperands().get(i), actualCoalesce.getArguments().get(i))).booleanValue();
            }
            return verified;
        }
        return false;
    }

    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression expected, RowExpression actual) {
        Optional<Object> elseValue;
        List<RowExpression> whenClauses;
        if (!(actual instanceof SpecialFormExpression) || !((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.SWITCH)) {
            return false;
        }
        SpecialFormExpression actualCase = (SpecialFormExpression)actual;
        if (!((Boolean)this.process((Node)expected.getOperand(), actualCase.getArguments().get(0))).booleanValue()) {
            return false;
        }
        RowExpression last = (RowExpression)actualCase.getArguments().get(actualCase.getArguments().size() - 1);
        if (last instanceof SpecialFormExpression && ((SpecialFormExpression)last).getForm().equals((Object)SpecialFormExpression.Form.WHEN)) {
            whenClauses = actualCase.getArguments().subList(1, actualCase.getArguments().size());
            elseValue = Optional.empty();
        } else {
            whenClauses = actualCase.getArguments().subList(1, actualCase.getArguments().size() - 1);
            elseValue = Optional.of(last);
        }
        if (!this.process(expected.getWhenClauses(), whenClauses)) {
            return false;
        }
        return this.process(expected.getDefaultValue(), elseValue);
    }

    protected Boolean visitWhenClause(WhenClause expected, RowExpression actual) {
        if (!(actual instanceof SpecialFormExpression) || !((SpecialFormExpression)actual).getForm().equals((Object)SpecialFormExpression.Form.WHEN)) {
            return false;
        }
        SpecialFormExpression actualWhenClause = (SpecialFormExpression)actual;
        return (Boolean)this.process((Node)expected.getOperand(), ((SpecialFormExpression)actual).getArguments().get(0)) != false && (Boolean)this.process((Node)expected.getResult(), actualWhenClause.getArguments().get(1)) != false;
    }

    protected Boolean visitFunctionCall(FunctionCall expected, RowExpression actual) {
        if (!(actual instanceof CallExpression)) {
            return false;
        }
        CallExpression actualFunction = (CallExpression)actual;
        if (!expected.getName().getSuffix().equals(this.metadata.getFunctionAndTypeManager().getFunctionMetadata(actualFunction.getFunctionHandle()).getName().getObjectName())) {
            return false;
        }
        return this.process(expected.getArguments(), actualFunction.getArguments());
    }

    protected Boolean visitNullLiteral(NullLiteral node, RowExpression actual) {
        return actual instanceof ConstantExpression && ((ConstantExpression)actual).getValue() == null;
    }

    private <T extends Node> boolean process(List<T> expecteds, List<RowExpression> actuals) {
        if (expecteds.size() != actuals.size()) {
            return false;
        }
        for (int i = 0; i < expecteds.size(); ++i) {
            if (((Boolean)this.process((Node)expecteds.get(i), actuals.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean process(Optional<T> expected, Optional<RowExpression> actual) {
        if (expected.isPresent() != actual.isPresent()) {
            return false;
        }
        if (expected.isPresent()) {
            return (Boolean)this.process((Node)expected.get(), actual.get());
        }
        return true;
    }
}

