/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.Session;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIterativeOptimizer {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1").setSystemProperty("iterative_optimizer_enabled", "true").setSystemProperty("iterative_optimizer_timeout", "1ms");
        this.queryRunner = new LocalQueryRunner(sessionBuilder.build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }

    @Test(timeOut=8000L)
    public void optimizerTimeoutsOnNonConvergingPlan() {
        IterativeOptimizer optimizer = new IterativeOptimizer(new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new NonConvergingRule()));
        try {
            this.queryRunner.inTransaction(arg_0 -> this.lambda$optimizerTimeoutsOnNonConvergingPlan$0((PlanOptimizer)optimizer, arg_0));
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.OPTIMIZER_TIMEOUT.toErrorCode());
        }
    }

    private /* synthetic */ Object lambda$optimizerTimeoutsOnNonConvergingPlan$0(PlanOptimizer optimizer, Session transactionSession) {
        this.queryRunner.createPlan(transactionSession, "SELECT * FROM nation", (List)ImmutableList.of((Object)optimizer), WarningCollector.NOOP);
        Assert.fail((String)"The optimizer should not converge");
        return null;
    }

    private static class NonConvergingRule
    implements Rule<ProjectNode> {
        private NonConvergingRule() {
        }

        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
            if (NonConvergingRule.isIdentityProjection(project)) {
                return Rule.Result.ofPlanNode((PlanNode)project.getSource());
            }
            ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)project, AssignmentUtils.identityAssignments((Collection)project.getOutputVariables()));
            return Rule.Result.ofPlanNode((PlanNode)projectNode);
        }

        private static boolean isIdentityProjection(ProjectNode project) {
            return ImmutableSet.copyOf((Collection)project.getOutputVariables()).equals((Object)ImmutableSet.copyOf((Collection)project.getSource().getOutputVariables()));
        }
    }
}

