/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.AddNotNullFiltersToJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestAddNotNullFiltersToJoinNode
extends BasePlanTest {
    private static final Map<String, Type> testVariableTypeMap;
    private final TestingRowExpressionTranslator rowExpressionTranslator;
    private final FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();

    public TestAddNotNullFiltersToJoinNode() {
        super((Map<String, String>)ImmutableMap.of((Object)"optimize_nulls_in_join", (Object)Boolean.toString(false), (Object)"joins_not_null_inference_strategy", (Object)FeaturesConfig.JoinNotNullInferenceStrategy.USE_FUNCTION_METADATA.toString()));
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.rowExpressionTranslator = new TestingRowExpressionTranslator((Metadata)metadata);
    }

    @DataProvider
    public static Object[][] getExistingNotNullVarsTestCases() {
        return new Object[][]{{"a IS NOT NULL AND b IS NOT NULL", new String[]{"a", "b"}}, {"a > 10 AND b IS NOT NULL AND c is NOT NULL", new String[]{"b", "c"}}, {"a is NULL AND b IS NOT NULL", new String[]{"b"}}, {"NOT(a is NULL)", new String[]{"a"}}, {"NOT(a is NULL OR b is NULL)", new String[0]}, {"a is NOT NULL OR b is NOT NULL", new String[0]}};
    }

    @DataProvider
    public static Object[][] standardOperatorTestCases() {
        return new Object[][]{{"a + b > 10", new String[]{"a", "b"}}, {"a != 10 - b", new String[]{"a", "b"}}, {"a > b", new String[]{"a", "b"}}, {"a + NULL > b", new String[]{"a", "b"}}, {"a > b and c = d", new String[]{"a", "b", "c", "d"}}, {"a IS NULL and b > c", new String[]{"b", "c"}}, {"a > b OR c = d", new String[0]}, {"COALESCE(a,b)", new String[0]}, {"a IN (b,10,NULL)", new String[0]}, {"arr[3] = 10", new String[]{"arr"}}, {"c_struct.a = 10", new String[0]}, {"NOT (b + 10 > c)", new String[0]}, {"abs(b + c) > 10", new String[0]}, {"random(b) = ceil(c)", new String[0]}, {"d > e and abs(b + c) > 10", new String[]{"d", "e"}}};
    }

    @DataProvider
    public static Object[][] nonStandardOperatorTestCases() {
        return new Object[][]{{"NOT (b + 10 > c)", new String[]{"b", "c"}}, {"abs(b + c) > 10", new String[]{"b", "c"}}, {"random(b) = ceil(c)", new String[]{"b", "c"}}};
    }

    @Test
    public void testNotNullPredicatesAddedForSingleEquiJoinClause() {
        String query = "select 1 from lineitem l join orders o on l.orderkey = o.orderkey";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY IS NOT NULL", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY IS NOT NULL", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testNotNullPredicatesAddedForCrossJoinReducedToInnerJoin() {
        String query = "select 1 from lineitem l, orders o where l.orderkey = o.orderkey";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY IS NOT NULL", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY IS NOT NULL", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
        query = "select 1 from lineitem l join orders o on l.orderkey = o.orderkey, customer c where c.custkey = o.custkey";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY IS NOT NULL", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_CUSTOMER_KEY", "CUSTOMER_CUSTOMER_KEY")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_CUSTOMER_KEY IS NOT NULL AND ORDERS_ORDER_KEY IS NOT NULL", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey", (Object)"ORDERS_CUSTOMER_KEY", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("CUSTOMER_CUSTOMER_KEY IS NOT NULL", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"CUSTOMER_CUSTOMER_KEY", (Object)"custkey")))))))));
    }

    @Test
    public void testMultipleNotNullsAddedForMultipleEquiJoinClause() {
        String query = "select 1 from lineitem l join orders o on l.orderkey = o.orderkey and l.partkey = o.custkey";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY"), PlanMatchPattern.equiJoinClause("partkey", "custkey")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY IS NOT NULL AND partkey IS NOT NULL", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY IS NOT NULL AND custkey IS NOT NULL", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))))));
    }

    @Test
    public void testNotNullInferredForJoinFilter() {
        String query = "select 1 from lineitem l join orders o on l.orderkey = o.orderkey and partkey + custkey > 10";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY")), Optional.of("partkey + custkey > 10"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY IS NOT NULL AND partkey IS NOT NULL", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY IS NOT NULL AND custkey IS NOT NULL", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))))));
    }

    @Test
    public void testNotNullPredicatesAddedOnlyForInnerSideTablesVariableReferences() {
        String query = "select 1 from lineitem l left join orders o on l.orderkey = o.orderkey and partkey - custkey > 10";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY")), Optional.of("partkey - custkey > 10"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY IS NOT NULL and custkey IS NOT NULL", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))))));
        query = "select 1 from lineitem l right join orders o on l.orderkey = o.orderkey and custkey > partkey";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINE_ORDER_KEY", "ORDERS_ORDER_KEY")), Optional.of("custkey > partkey"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY IS NOT NULL and partkey IS NOT NULL", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey", (Object)"custkey", (Object)"custkey"))))));
    }

    @Test(dataProvider="standardOperatorTestCases")
    public void testNotNullInferenceForInferFromStandardOperatorsStrategy(String filterSql, String[] expectedInferredNotNullVariables) {
        this.assertInferredNotNullVariableRefsListMatch(FeaturesConfig.JoinNotNullInferenceStrategy.INFER_FROM_STANDARD_OPERATORS, filterSql, this.buildVariableReferencesList(expectedInferredNotNullVariables));
    }

    @Test(dataProvider="nonStandardOperatorTestCases")
    public void testNotNullInferenceForUseFunctionMetadataStrategy(String filterSql, String[] expectedInferredNotNullVariables) {
        this.assertInferredNotNullVariableRefsListMatch(FeaturesConfig.JoinNotNullInferenceStrategy.USE_FUNCTION_METADATA, filterSql, this.buildVariableReferencesList(expectedInferredNotNullVariables));
    }

    @Test(dataProvider="getExistingNotNullVarsTestCases")
    public void testGetExistingNotNullVars(String filterSql, String[] expectedNotNullVars) {
        Set actual = new AddNotNullFiltersToJoinNode(this.functionAndTypeManager).getExistingNotNullVariables(Optional.of(this.rowExpressionTranslator.translate(filterSql, testVariableTypeMap)));
        Assert.assertEquals((Collection)actual, this.buildVariableReferencesList(expectedNotNullVars));
    }

    private List<VariableReferenceExpression> buildVariableReferencesList(String ... var) {
        return Arrays.stream(var).map(x -> Expressions.variable((String)x, (Type)testVariableTypeMap.get(x))).collect(Collectors.toList());
    }

    private void assertInferredNotNullVariableRefsListMatch(FeaturesConfig.JoinNotNullInferenceStrategy notNullInferenceStrategy, String filterSql, List<VariableReferenceExpression> expectedInferredNotNullVariables) {
        AddNotNullFiltersToJoinNode.ExtractInferredNotNullVariablesVisitor visitor = new AddNotNullFiltersToJoinNode.ExtractInferredNotNullVariablesVisitor(this.functionAndTypeManager, notNullInferenceStrategy);
        RowExpression rowExpression = this.rowExpressionTranslator.translate(filterSql, testVariableTypeMap);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        rowExpression.accept((RowExpressionVisitor)visitor, (Object)builder);
        Assert.assertEquals((Collection)builder.build(), expectedInferredNotNullVariables);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"a", (Object)BigintType.BIGINT);
        builder.put((Object)"b", (Object)BigintType.BIGINT);
        builder.put((Object)"c", (Object)BigintType.BIGINT);
        builder.put((Object)"d", (Object)BigintType.BIGINT);
        builder.put((Object)"e", (Object)BigintType.BIGINT);
        builder.put((Object)"arr", (Object)new ArrayType((Type)BigintType.BIGINT));
        builder.put((Object)"c_struct", (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT))));
        testVariableTypeMap = builder.build();
    }
}

