/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.CombineApproxPercentileFunctions;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestCombineApproxPercentileFunctions
extends BaseRuleTest {
    public TestCombineApproxPercentileFunctions() {
        super(new Plugin[0]);
    }

    @Test
    public void testPercentile() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col")));
        })).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"approx_percentile_1", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 1)"), (Object)"approx_percentile_2", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 2)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"approx_percentile_3", PlanMatchPattern.functionCall("approx_percentile", (List<String>)ImmutableList.of((Object)"col", (Object)"percentile"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"col", (Object)PlanMatchPattern.expression("col"), (Object)"percentile", (Object)PlanMatchPattern.expression("array[0.1, 0.2]", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)), PlanMatchPattern.values("col")))));
    }

    @Test
    public void testMultiplePercentile() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            p.variable("col2", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_3"), p.rowExpression("approx_percentile(col2, 0.3)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_4"), p.rowExpression("approx_percentile(col2, 0.4)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_5"), p.rowExpression("approx_percentile(col2, 0.5)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col"), p.variable("col2")));
        })).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"approx_percentile_1", (Object)PlanMatchPattern.expression("element_at(approx_percentile_6, 1)"), (Object)"approx_percentile_2", (Object)PlanMatchPattern.expression("element_at(approx_percentile_6, 2)"), (Object)"approx_percentile_3", (Object)PlanMatchPattern.expression("element_at(approx_percentile_7, 1)"), (Object)"approx_percentile_4", (Object)PlanMatchPattern.expression("element_at(approx_percentile_7, 2)"), (Object)"approx_percentile_5", (Object)PlanMatchPattern.expression("element_at(approx_percentile_7, 3)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"approx_percentile_6", PlanMatchPattern.functionCall("approx_percentile", (List<String>)ImmutableList.of((Object)"col", (Object)"percentile")), (Object)"approx_percentile_7", PlanMatchPattern.functionCall("approx_percentile", (List<String>)ImmutableList.of((Object)"col2", (Object)"percentile2"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"col", (Object)PlanMatchPattern.expression("col"), (Object)"col2", (Object)PlanMatchPattern.expression("col2"), (Object)"percentile", (Object)PlanMatchPattern.expression("array[0.1, 0.2]", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE), (Object)"percentile2", (Object)PlanMatchPattern.expression("array[0.3, 0.4, 0.5]", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)), PlanMatchPattern.values("col", "col2")))));
    }

    @Test
    public void testArrayPercentile() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, array[0.1, 0.3])", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, array[0.4, 0.5])", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col")));
        })).doesNotFire();
    }

    @Test
    public void testMixedPercentile() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, array[0.1, 0.3])", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col")));
        })).doesNotFire();
    }

    @Test
    public void testPercentileAndAccuracy() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            p.variable("accuracy", (Type)DoubleType.DOUBLE);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1, accuracy)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, 0.2, accuracy)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col"), p.variable("accuracy", (Type)DoubleType.DOUBLE)));
        })).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"approx_percentile_1", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 1)"), (Object)"approx_percentile_2", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 2)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"approx_percentile_3", PlanMatchPattern.functionCall("approx_percentile", (List<String>)ImmutableList.of((Object)"col", (Object)"percentile", (Object)"accuracy"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"col", (Object)PlanMatchPattern.expression("col"), (Object)"percentile", (Object)PlanMatchPattern.expression("array[0.1, 0.2]", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE), (Object)"accuracy", (Object)PlanMatchPattern.expression("accuracy")), PlanMatchPattern.values("col", "accuracy")))));
    }

    @Test
    public void testWeightAndPercentile() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            p.variable("weight", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, weight, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, weight, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col"), p.variable("weight", (Type)BigintType.BIGINT)));
        })).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"approx_percentile_1", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 1)"), (Object)"approx_percentile_2", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 2)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"approx_percentile_3", PlanMatchPattern.functionCall("approx_percentile", (List<String>)ImmutableList.of((Object)"col", (Object)"weight", (Object)"percentile"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"col", (Object)PlanMatchPattern.expression("col"), (Object)"percentile", (Object)PlanMatchPattern.expression("array[0.1, 0.2]", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE), (Object)"weight", (Object)PlanMatchPattern.expression("weight")), PlanMatchPattern.values("col", "weight")))));
    }

    @Test
    public void testWeightPercentileAndAccuracy() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            p.variable("weight", (Type)BigintType.BIGINT);
            p.variable("accuracy", (Type)DoubleType.DOUBLE);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, weight, 0.1, accuracy)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, weight, 0.2, accuracy)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col"), p.variable("weight", (Type)BigintType.BIGINT), p.variable("accuracy", (Type)DoubleType.DOUBLE)));
        })).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"approx_percentile_1", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 1)"), (Object)"approx_percentile_2", (Object)PlanMatchPattern.expression("element_at(approx_percentile_3, 2)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"approx_percentile_3", PlanMatchPattern.functionCall("approx_percentile", (List<String>)ImmutableList.of((Object)"col", (Object)"weight", (Object)"percentile", (Object)"accuracy"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"col", (Object)PlanMatchPattern.expression("col"), (Object)"percentile", (Object)PlanMatchPattern.expression("array[0.1, 0.2]", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE), (Object)"weight", (Object)PlanMatchPattern.expression("weight"), (Object)"accuracy", (Object)PlanMatchPattern.expression("accuracy")), PlanMatchPattern.values("col", "weight", "accuracy")))));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col")));
        })).doesNotFire();
    }

    @Test
    public void testMixedWeightAndPercentile() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            p.variable("weight", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, weight, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col"), p.variable("weight", (Type)BigintType.BIGINT)));
        })).doesNotFire();
    }

    @Test
    public void testNoChange() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            p.variable("col2", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col2, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col"), p.variable("col2")));
        })).doesNotFire();
    }

    @Test
    public void testArrayLimit() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().source((PlanNode)p.values(p.variable("col")));
            int arraySize = 255;
            for (int i = 0; i < arraySize; ++i) {
                double percentile = (double)(i + 1) * 1.0 / (double)(arraySize + 1);
                String approxVariable = String.format("approx_percentile_%d", i + 1);
                String sql = String.format("approx_percentile(col, %f)", percentile);
                af.addAggregation(p.variable(approxVariable), p.rowExpression(sql, ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE));
            }
        })).doesNotFire();
    }

    @Test
    public void testWithDuplicate() {
        this.tester().assertThat((Rule)new CombineApproxPercentileFunctions(this.getMetadata().getFunctionAndTypeManager())).on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("approx_percentile_1"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_2"), p.rowExpression("approx_percentile(col, 0.1)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_3"), p.rowExpression("approx_percentile(col, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).addAggregation(p.variable("approx_percentile_4"), p.rowExpression("approx_percentile(col, 0.2)", ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)).source((PlanNode)p.values(p.variable("col")));
        })).doesNotFire();
    }
}

