/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.CrossJoinWithArrayContainsToInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushDownFilterExpressionEvaluationThroughCrossJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

public class TestCrossJoinWithArrayContainsToInnerJoin
extends BaseRuleTest {
    public TestCrossJoinWithArrayContainsToInnerJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTriggerForBigInt() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(left_array_k1, right_k1)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (PlanNode)p.values(p.variable("right_k1")), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("field", "right_k1")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(left_array_k1)")), PlanMatchPattern.values("left_array_k1"))), PlanMatchPattern.values("right_k1")));
    }

    @Test
    public void testTriggerForBigIntArrayRightSide() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(right_array_k1, left_k1)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1")), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("left_k1", "field")), PlanMatchPattern.values("left_k1"), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(right_array_k1)")), PlanMatchPattern.values("right_array_k1")))));
    }

    @Test
    public void testMultipleArrayContainsConditions() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(left_array_k1, right_k1) and contains(right_array_k2, left_k2)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT))), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.filter("contains(right_array_k2, left_k2)", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("field", "right_k1")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(left_array_k1)")), PlanMatchPattern.values("left_array_k1", "left_k2"))), PlanMatchPattern.values("right_k1", "right_array_k2"))));
    }

    @Test
    public void testMultipleInvalidArrayContainsConditions() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(left_array_k1, right_k1) or contains(right_array_k2, left_k2)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT))), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerForDouble() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)DoubleType.DOUBLE));
            p.variable("right_k1", (Type)DoubleType.DOUBLE);
            return p.filter(p.rowExpression("contains(left_array_k1, right_k1)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)DoubleType.DOUBLE))), (PlanNode)p.values(p.variable("right_k1", (Type)DoubleType.DOUBLE)), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testArrayContainsWithCast() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("contains(left_array_k1, CAST(right_k1 AS BIGINT))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR)), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testArrayContainsWithCastBothRules() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager()))).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("contains(left_array_k1, CAST(right_k1 AS BIGINT))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR)), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("field", "cast_r")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(left_array_k1)")), PlanMatchPattern.values("left_array_k1"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_r", (Object)PlanMatchPattern.expression("CAST(right_k1 AS bigint)")), PlanMatchPattern.values("right_k1")))));
    }

    @Test
    public void testArrayContainsWithCastBothRules2() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager()))).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("contains(CAST(left_array_k1 AS ARRAY<VARCHAR>), right_k1)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR)), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("field", "right_k1")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(cast_array)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_array", (Object)PlanMatchPattern.expression("cast(left_array_k1 as array<varchar>)")), PlanMatchPattern.values("left_array_k1")))), PlanMatchPattern.values("right_k1"))));
    }

    @Test
    public void testArrayContainsWithCastBothRulesArrayRightSide() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager()))).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(right_array_k1, CAST(left_k1 AS BIGINT))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("cast_l", "field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_l", (Object)PlanMatchPattern.expression("CAST(left_k1 AS bigint)")), PlanMatchPattern.values("left_k1")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(right_array_k1)")), PlanMatchPattern.values("right_array_k1"))))));
    }

    @Test
    public void testArrayContainsWithCoalesceBothRules() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager()))).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(left_array_k1, coalesce(CAST(right_k1 AS BIGINT), right_k2))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR), p.variable("right_k2", (Type)BigintType.BIGINT)), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("field", "expr")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(left_array_k1)")), PlanMatchPattern.values("left_array_k1"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("COALESCE(CAST(right_k1 AS bigint), right_k2)")), PlanMatchPattern.values("right_k1", "right_k2")))));
    }

    @Test
    public void testArrayContainsWithCoalesceBothRulesArrayOnRight() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager()))).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(right_array_k1, coalesce(CAST(left_k1 AS BIGINT), left_k2))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR), p.variable("left_k2", (Type)BigintType.BIGINT)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("COALESCE(CAST(left_k1 AS bigint), left_k2)")), PlanMatchPattern.values("left_k1", "left_k2")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(right_array_k1)")), PlanMatchPattern.values("right_array_k1"))))));
    }

    @Test
    public void testConditionWithAnd() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(left_array_k1, right_k1) and left_k2+right_k2 > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.filter("left_k2+right_k2 > 10", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("field", "right_k1")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(left_array_k1)")), PlanMatchPattern.values("left_array_k1", "left_k2"))), PlanMatchPattern.values("right_k1", "right_k2"))));
    }

    @Test
    public void testConditionWithAndArrayOnRight() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k2", (Type)BigintType.BIGINT);
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(right_array_k1, left_k1) and right_k2+left_k2 > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.filter("right_k2+left_k2 > 10", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("left_k1", "field")), PlanMatchPattern.values("left_k1", "left_k2"), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("array_distinct(right_array_k1)")), PlanMatchPattern.values("right_array_k1", "right_k2"))))));
    }

    @Test
    public void testNonMatchingCondition() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(left_array_k1, right_k1) or left_k2+right_k2 > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNonMatchingCondition2() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayContainsToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_contains_to_inner_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("contains(left_array_k1, left_k2)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }
}

