/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.CrossJoinWithOrFilterToInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushDownFilterExpressionEvaluationThroughCrossJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

public class TestCrossJoinWithOrFilterToInnerJoin
extends BaseRuleTest {
    public TestCrossJoinWithOrFilterToInnerJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTriggerForBigInt() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("left_k1 = right_k1 or left_k2 = right_k2"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("case left_idx when 1 then left_k1 = right_k1 when 2 then not(coalesce(left_k1 = right_k1, false)) and left_k2 = right_k2 else null end", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "expr_2"), PlanMatchPattern.equiJoinClause("left_idx", "right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("case left_idx when 1 then left_k1 when 2 then left_k2 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"left_array", (Object)ImmutableList.of((Object)"left_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"left_array", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.values("left_k1", "left_k2")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_2", (Object)PlanMatchPattern.expression("case right_idx when 1 then right_k1 when 2 then right_k2 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"right_array", (Object)ImmutableList.of((Object)"right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"right_array", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.values("right_k1", "right_k2"))))))));
    }

    @Test
    public void testMultipleOrConditions() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("left_k3", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            p.variable("right_k3", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("left_k1 = right_k1 or left_k2 = right_k2 or left_k3 = right_k3"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2"), p.variable("left_k3")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2"), p.variable("right_k3")), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("case left_idx when 1 then left_k1 = right_k1 when 2 then not(coalesce(left_k1 = right_k1, false)) and left_k2 = right_k2 when 3 then not(coalesce(left_k1 = right_k1, false)) and not(coalesce(left_k2 = right_k2, false)) and left_k3 = right_k3 else null end", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "expr_2"), PlanMatchPattern.equiJoinClause("left_idx", "right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("case left_idx when 1 then left_k1 when 2 then left_k2 when 3 then left_k3 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"left_array", (Object)ImmutableList.of((Object)"left_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"left_array", (Object)PlanMatchPattern.expression("array[1, 2, 3]")), PlanMatchPattern.values("left_k1", "left_k2", "left_k3")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_2", (Object)PlanMatchPattern.expression("case right_idx when 1 then right_k1 when 2 then right_k2 when 3 then right_k3 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"right_array", (Object)ImmutableList.of((Object)"right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"right_array", (Object)PlanMatchPattern.expression("array[1, 2, 3]")), PlanMatchPattern.values("right_k1", "right_k2", "right_k3"))))))));
    }

    @Test
    public void testNotTriggerForDouble() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)DoubleType.DOUBLE);
            p.variable("left_k2", (Type)DoubleType.DOUBLE);
            p.variable("right_k1", (Type)DoubleType.DOUBLE);
            p.variable("right_k2", (Type)DoubleType.DOUBLE);
            return p.filter(p.rowExpression("left_k1 = right_k1 or left_k2 = right_k2"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)DoubleType.DOUBLE), p.variable("left_k2", (Type)DoubleType.DOUBLE)), (PlanNode)p.values(p.variable("right_k1", (Type)DoubleType.DOUBLE), p.variable("right_k2", (Type)DoubleType.DOUBLE)), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerForCastToDouble() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("left_k2", (Type)VarcharType.VARCHAR);
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_k2", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("left_k1 = right_k1 or CAST(left_k2 AS DOUBLE) = CAST(right_k2 AS DOUBLE)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR), p.variable("left_k2", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR), p.variable("right_k2", (Type)VarcharType.VARCHAR)), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testOrWithCast() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("left_k1 = right_k1 or left_k2 = CAST(right_k2 AS BIGINT)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2", (Type)VarcharType.VARCHAR)), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testOrWithCastBothRules() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager()))).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("left_k1 = right_k1 or left_k2 = CAST(right_k2 AS BIGINT)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2", (Type)VarcharType.VARCHAR)), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.filter("case left_idx when 1 then left_k1 = right_k1 when 2 then not(coalesce(left_k1 = right_k1, false)) and left_k2 = cast_0 else null end", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "expr_2"), PlanMatchPattern.equiJoinClause("left_idx", "right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("case left_idx when 1 then left_k1 when 2 then left_k2 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"left_array", (Object)ImmutableList.of((Object)"left_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"left_array", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.values("left_k1", "left_k2")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_2", (Object)PlanMatchPattern.expression("case right_idx when 1 then right_k1 when 2 then cast_0 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"right_array", (Object)ImmutableList.of((Object)"right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"right_array", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_0", (Object)PlanMatchPattern.expression("CAST(right_k2 AS bigint)")), PlanMatchPattern.values("right_k1", "right_k2"))))))))));
    }

    @Test
    public void testConditionWithAnd() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("(left_k1 = right_k1 or left_k2 = right_k2) and left_k1+right_k2 > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("left_k1+right_k2 > 10", PlanMatchPattern.filter("case left_idx when 1 then left_k1 = right_k1 when 2 then not(coalesce(left_k1 = right_k1, false)) and left_k2 = right_k2 else null end", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "expr_2"), PlanMatchPattern.equiJoinClause("left_idx", "right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("case left_idx when 1 then left_k1 when 2 then left_k2 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"left_array", (Object)ImmutableList.of((Object)"left_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"left_array", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.values("left_k1", "left_k2")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_2", (Object)PlanMatchPattern.expression("case right_idx when 1 then right_k1 when 2 then right_k2 else null end")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"right_array", (Object)ImmutableList.of((Object)"right_idx")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"right_array", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.values("right_k1", "right_k2")))))))));
    }

    @Test
    public void testNonMatchingCondition() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("(left_k1 = right_k1 or left_k2 = right_k2) or left_k1+right_k2 > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNonMatchingCondition2() {
        this.tester().assertThat((Rule)new CrossJoinWithOrFilterToInnerJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("left_k1 = right_k1 or left_k2 > right_k2"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }
}

