/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinEnumerator {
    private LocalQueryRunner queryRunner;
    private Metadata metadata;
    private DeterminismEvaluator determinismEvaluator;
    private FunctionResolution functionResolution;

    @BeforeClass
    public void setUp() {
        this.queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().build());
        this.metadata = this.queryRunner.getMetadata();
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(this.metadata);
        this.functionResolution = new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test
    public void testGeneratePartitions() {
        Assert.assertEquals((Set)ReorderJoins.JoinEnumerator.generatePartitions((int)4), (Set)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)3), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)3), (Object[])new ImmutableSet[]{ImmutableSet.of((Object)0, (Object)2, (Object)3)}));
        Assert.assertEquals((Set)ReorderJoins.JoinEnumerator.generatePartitions((int)3), (Set)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2)));
    }

    @Test
    public void testDoesNotCreateJoinWhenPartitionedOnCrossJoin() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = new PlanBuilder(SessionTestUtils.TEST_SESSION, idAllocator, this.queryRunner.getMetadata());
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        ReorderJoins.MultiJoinNode multiJoinNode = new ReorderJoins.MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)p.values(a1), (Object)p.values(b1))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (List)ImmutableList.of((Object)a1, (Object)b1));
        ReorderJoins.JoinEnumerator joinEnumerator = new ReorderJoins.JoinEnumerator(new CostComparator(1.0, 1.0, 1.0), multiJoinNode.getFilter(), this.createContext(), this.determinismEvaluator, this.functionResolution, this.metadata);
        ReorderJoins.JoinEnumerationResult actual = joinEnumerator.createJoinAccordingToPartitioning(multiJoinNode.getSources(), multiJoinNode.getOutputVariables(), (Set)ImmutableSet.of((Object)0));
        Assert.assertFalse((boolean)actual.getPlanNode().isPresent());
        Assert.assertEquals((Object)actual.getCost(), (Object)PlanCostEstimate.infinite());
    }

    private Rule.Context createContext() {
        final PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        final VariableAllocator variableAllocator = new VariableAllocator();
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.queryRunner.getStatsCalculator(), Optional.empty(), Lookup.noLookup(), this.queryRunner.getDefaultSession(), TypeProvider.viewOf((Map)variableAllocator.getVariables()));
        final CachingCostProvider costProvider = new CachingCostProvider(this.queryRunner.getCostCalculator(), (StatsProvider)statsProvider, Optional.empty(), this.queryRunner.getDefaultSession());
        return new Rule.Context(){

            public Lookup getLookup() {
                return Lookup.noLookup();
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return planNodeIdAllocator;
            }

            public VariableAllocator getVariableAllocator() {
                return variableAllocator;
            }

            public Session getSession() {
                return TestJoinEnumerator.this.queryRunner.getDefaultSession();
            }

            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            public CostProvider getCostProvider() {
                return costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }

            public WarningCollector getWarningCollector() {
                return WarningCollector.NOOP;
            }

            public Optional<LogicalPropertiesProvider> getLogicalPropertiesProvider() {
                return Optional.empty();
            }
        };
    }
}

