/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneCrossJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneCrossJoinColumns
extends BaseRuleTest {
    public TestPruneCrossJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testLeftInputNotReferenced() {
        this.tester().assertThat((Rule)new PruneCrossJoinColumns()).on(p -> TestPruneCrossJoinColumns.buildProjectedCrossJoin(p, variable -> variable.getName().equals("rightValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightValue", (Object)PlanMatchPattern.expression("rightValue")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"leftValue"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rightValue"))).withExactOutputs("rightValue")));
    }

    @Test
    public void testRightInputNotReferenced() {
        this.tester().assertThat((Rule)new PruneCrossJoinColumns()).on(p -> TestPruneCrossJoinColumns.buildProjectedCrossJoin(p, variable -> variable.getName().equals("leftValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftValue", (Object)PlanMatchPattern.expression("leftValue")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"leftValue")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rightValue")))).withExactOutputs("leftValue")));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneCrossJoinColumns()).on(p -> TestPruneCrossJoinColumns.buildProjectedCrossJoin(p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).doesNotFire();
    }

    private static PlanNode buildProjectedCrossJoin(PlanBuilder p, Predicate<VariableReferenceExpression> projectionFilter) {
        VariableReferenceExpression leftValue = p.variable("leftValue");
        VariableReferenceExpression rightValue = p.variable("rightValue");
        ImmutableList outputs = ImmutableList.of((Object)leftValue, (Object)rightValue);
        return p.project(AssignmentUtils.identityAssignments((Collection)((Collection)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftValue), (PlanNode)p.values(rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)outputs, Optional.empty(), Optional.empty(), Optional.empty()));
    }
}

