/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneFilterColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestPruneFilterColumns
extends BaseRuleTest {
    public TestPruneFilterColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneFilterColumns()).on(p -> this.buildProjectedFilter((PlanBuilder)p, variable -> variable.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.filter("b > 5", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneFilterColumns()).on(p -> this.buildProjectedFilter((PlanBuilder)p, symbol -> symbol.getName().equals("a"))).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneFilterColumns()).on(p -> this.buildProjectedFilter((PlanBuilder)p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).doesNotFire();
    }

    private ProjectNode buildProjectedFilter(PlanBuilder planBuilder, Predicate<VariableReferenceExpression> projectionFilter) {
        VariableReferenceExpression a = planBuilder.variable("a");
        VariableReferenceExpression b = planBuilder.variable("b");
        return planBuilder.project(AssignmentUtils.identityAssignments((Collection)((Collection)Stream.of(a, b).filter(projectionFilter).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.filter(planBuilder.rowExpression("b > 5"), (PlanNode)planBuilder.values(a, b)));
    }
}

