/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneJoinChildrenColumns
extends BaseRuleTest {
    public TestPruneJoinChildrenColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsRereferenced() {
        this.tester().assertThat((Rule)new PruneJoinChildrenColumns()).on(p -> TestPruneJoinChildrenColumns.buildJoin(p, variable -> variable.getName().equals("leftValue"))).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), Optional.of("leftValue > 5"), PlanMatchPattern.values("leftKey", "leftKeyHash", "leftValue"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightKey", (Object)PlanMatchPattern.expression("rightKey"), (Object)"rightKeyHash", (Object)PlanMatchPattern.expression("rightKeyHash")), PlanMatchPattern.values("rightKey", "rightKeyHash", "rightValue"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneJoinChildrenColumns()).on(p -> TestPruneJoinChildrenColumns.buildJoin(p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testCrossJoinDoesNotFire() {
        this.tester().assertThat((Rule)new PruneJoinColumns()).on(p -> {
            VariableReferenceExpression leftValue = p.variable("leftValue");
            VariableReferenceExpression rightValue = p.variable("rightValue");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftValue), (PlanNode)p.values(rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)leftValue, (Object)rightValue), Optional.empty(), Optional.empty(), Optional.empty());
        }).doesNotFire();
    }

    private static PlanNode buildJoin(PlanBuilder p, Predicate<VariableReferenceExpression> joinOutputFilter) {
        VariableReferenceExpression leftKey = p.variable("leftKey");
        VariableReferenceExpression leftKeyHash = p.variable("leftKeyHash");
        VariableReferenceExpression leftValue = p.variable("leftValue");
        VariableReferenceExpression rightKey = p.variable("rightKey");
        VariableReferenceExpression rightKeyHash = p.variable("rightKeyHash");
        VariableReferenceExpression rightValue = p.variable("rightValue");
        ImmutableList outputs = ImmutableList.of((Object)leftValue, (Object)rightValue);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftKey, leftKeyHash, leftValue), (PlanNode)p.values(rightKey, rightKeyHash, rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(leftKey, rightKey)), (List)outputs.stream().filter(joinOutputFilter).collect(ImmutableList.toImmutableList()), Optional.of(p.rowExpression("leftValue > 5")), Optional.of(leftKeyHash), Optional.of(rightKeyHash));
    }
}

