/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushLimitThroughOuterJoin
extends BaseRuleTest {
    public TestPushLimitThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushLimitThroughLeftJoin() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            VariableReferenceExpression leftKey = p.variable("leftKey");
            VariableReferenceExpression rightKey = p.variable("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.limit(1L, true, PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey"))));
    }

    @Test
    public void testDoesNotPushThroughFullOuterJoin() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            VariableReferenceExpression leftKey = p.variable("leftKey");
            VariableReferenceExpression rightKey = p.variable("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenAlreadyLimited() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            VariableReferenceExpression leftKey = p.variable("leftKey");
            VariableReferenceExpression rightKey = p.variable("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.limit(1L, (PlanNode)p.values(5, leftKey)), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }
}

