/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushPartialAggregationThroughExchange
extends BaseRuleTest {
    public TestPushPartialAggregationThroughExchange() {
        super(new Plugin[0]);
    }

    @Test
    public void testPartialAggregationAdded() {
        this.tester().assertThat((Rule)new PushPartialAggregationThroughExchange(this.getFunctionManager())).setSystemProperty("partial_aggregation_strategy", "AUTOMATIC").on(p -> {
            VariableReferenceExpression a = p.variable("a");
            return p.aggregation(ab -> ab.source((PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).singleDistributionPartitioningScheme(a))).addAggregation(p.variable("SUM", (Type)DoubleType.DOUBLE), p.rowExpression("SUM(a)")).globalGrouping().step(AggregationNode.Step.PARTIAL));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"SUM", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.values("a")))));
    }

    @Test
    public void testNoPartialAggregationWhenDisabled() {
        this.tester().assertThat((Rule)new PushPartialAggregationThroughExchange(this.getFunctionManager())).setSystemProperty("partial_aggregation_strategy", "NEVER").on(p -> {
            VariableReferenceExpression a = p.variable("a");
            return p.aggregation(ab -> ab.source((PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).singleDistributionPartitioningScheme(a))).addAggregation(p.variable("SUM", (Type)DoubleType.DOUBLE), p.rowExpression("SUM(a)")).globalGrouping().step(AggregationNode.Step.PARTIAL));
        }).doesNotFire();
    }

    @Test
    public void testNoPartialAggregationWhenReductionBelowThreshold() {
        this.tester().assertThat((Rule)new PushPartialAggregationThroughExchange(this.getFunctionManager())).setSystemProperty("partial_aggregation_strategy", "AUTOMATIC").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)DoubleType.DOUBLE);
            VariableReferenceExpression b = p.variable("b", (Type)DoubleType.DOUBLE);
            return p.aggregation(ab -> ab.source((PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(new PlanNodeId("values"), a, b)).addInputsSet(a, b).singleDistributionPartitioningScheme(a, b))).addAggregation(p.variable("SUM", (Type)DoubleType.DOUBLE), p.rowExpression("SUM(a)")).singleGroupingSet(b).step(AggregationNode.Step.SINGLE));
        }).overrideStats("values", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics(Expressions.variable((String)"b", (Type)DoubleType.DOUBLE), new VariableStatsEstimate(0.0, 100.0, 0.0, 8.0, 800.0)).setConfident(true).build()).doesNotFire();
    }

    @Test
    public void testPartialAggregationEnabledWhenNotConfident() {
        this.tester().assertThat((Rule)new PushPartialAggregationThroughExchange(this.getFunctionManager())).setSystemProperty("partial_aggregation_strategy", "AUTOMATIC").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)DoubleType.DOUBLE);
            VariableReferenceExpression b = p.variable("b", (Type)DoubleType.DOUBLE);
            return p.aggregation(ab -> ab.source((PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(new PlanNodeId("values"), a, b)).addInputsSet(a, b).singleDistributionPartitioningScheme(a, b))).addAggregation(p.variable("SUM", (Type)DoubleType.DOUBLE), p.rowExpression("SUM(a)")).singleGroupingSet(b).step(AggregationNode.Step.PARTIAL));
        }).overrideStats("values", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics(Expressions.variable((String)"b", (Type)DoubleType.DOUBLE), new VariableStatsEstimate(0.0, 100.0, 0.0, 8.0, 800.0)).setConfident(false).build()).matches(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"SUM", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.values("a", "b")))));
    }
}

