/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.PlanTestSymbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithDistinct;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantAggregateDistinct;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantDistinct;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantAggregateDistinctRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantAggregateDistinctRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"use_mark_distinct", (Object)Boolean.toString(false), (Object)"exploit_constraints", (Object)Boolean.toString(true)), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void singleTableTests() {
        ImmutableMap aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct linenumber), avg(distinct tax) FROM lineitem GROUP BY orderkey").matches(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.tableScan("lineitem")))));
        aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct linenumber), avg(tax) FROM lineitem GROUP BY orderkey").matches(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.tableScan("lineitem")))));
        aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct quantity), avg(distinct tax) FROM lineitem GROUP BY orderkey, linenumber").matches(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.tableScan("lineitem")))));
        aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct quantity), avg(distinct tax) FROM lineitem where orderkey = 10 and linenumber=100 GROUP BY orderkey").matches(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem"))))));
        aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct quantity), avg(distinct tax) FROM lineitem where orderkey = 10 GROUP BY orderkey").matches(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem"))))));
        aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct linenumber), avg(distinct tax) FROM lineitem GROUP BY orderkey").doesNotMatch(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.tableScan("lineitem")))));
    }

    @Test
    public void complexQueryTests() {
        ImmutableMap aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithDistinct(), (Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select count(distinct totalprice) from orders o inner join customer c on o.custkey = c.custkey group by orderkey").matches(PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")), PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey_0", (Object)"custkey")))))));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new RemoveRedundantDistinct(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            return p.aggregation(builder -> builder.singleGroupingSet(c).source((PlanNode)p.limit(5L, (PlanNode)p.values(5, c))));
        }).doesNotFire();
    }

    @Test
    public void testFeatureDisabled() {
        RuleTester newTester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"use_mark_distinct", (Object)Boolean.toString(false), (Object)"exploit_constraints", (Object)Boolean.toString(false)));
        ImmutableMap aggregations = ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())), (Object)"avg", PlanMatchPattern.functionCall("avg", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol())));
        newTester.assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantAggregateDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(distinct linenumber), avg(distinct tax) FROM lineitem GROUP BY orderkey").matches(PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)aggregations, PlanMatchPattern.tableScan("lineitem")))));
    }
}

