/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestFullOuterJoinWithCoalesce
extends BasePlanTest {
    @Test
    public void testFullOuterJoinWithCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(r.a, ts.a) FROM (   SELECT coalesce(t.a, s.a) AS a    FROM (VALUES (1), (2), (3)) t(a)    FULL OUTER JOIN (VALUES (1), (4)) s(a)   ON t.a = s.a) ts FULL OUTER JOIN (VALUES (2), (5)) r(a) ON ts.a = r.a", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(r, ts)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ts", "r")), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ts", (Object)PlanMatchPattern.expression("coalesce(t, s)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "s")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s"))))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))));
    }

    @Test
    public void testDuplicateJoinClause() {
        this.assertDistributedPlan("SELECT coalesce(r.a, ts.a) FROM (   SELECT coalesce(t.a, s.a) AS a    FROM (VALUES (1), (2), (3)) t(a)    FULL OUTER JOIN (VALUES (1), (4)) s(a)   ON t.a = s.a AND t.a = s.a) ts FULL OUTER JOIN (VALUES (2), (5)) r(a) ON ts.a = r.a", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(r, ts)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ts", "r")), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ts", (Object)PlanMatchPattern.expression("coalesce(t, s)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "s"), PlanMatchPattern.equiJoinClause("t", "s")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s"))))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))));
    }

    @Test
    public void testDuplicatePartitionColumn() {
        this.assertDistributedPlan("SELECT coalesce(r.a, ts.a), coalesce(ts.b, r.b) FROM (   SELECT coalesce(t.a, s.a) AS a, coalesce(t.a, s.b) AS b   FROM (VALUES (1), (2), (3)) t(a)    FULL OUTER JOIN (VALUES (1, 1), (4, 4)) s(a, b)   ON t.a = s.a AND t.a = s.b) ts FULL OUTER JOIN (VALUES (2, 2), (5, 5)) r(a, b) ON ts.a = r.a and ts.b = r.b", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build(), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"tsra", (Object)PlanMatchPattern.expression("coalesce(ra, tsa)"), (Object)"tsrb", (Object)PlanMatchPattern.expression("coalesce(tsb, rb)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("tsa", "ra"), PlanMatchPattern.equiJoinClause("tsb", "rb")), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"tsa", (Object)PlanMatchPattern.expression("coalesce(ta, sa)"), (Object)"tsb", (Object)PlanMatchPattern.expression("coalesce(ta, sb)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ta", "sa"), PlanMatchPattern.equiJoinClause("ta", "sb")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"ta")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"sa", (Object)"sb"))))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"ra", (Object)"rb"))))))));
    }

    @Test
    public void testCoalesceWithManyArgumentsAndGroupBy() {
        this.assertDistributedPlan("SELECT coalesce(t.a, s.a, r.a) FROM (VALUES (1), (2), (3)) t(a) FULL OUTER JOIN (VALUES (1), (4)) s(a) ON t.a = s.a FULL OUTER JOIN (VALUES (2), (5)) r(a) ON t.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(t, s, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "s")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s")))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))))));
    }

    @Test
    public void testCoalesceWithNonSymbolArguments() {
        this.assertDistributedPlan("SELECT coalesce(t.a, s.a + 1, r.a) FROM (VALUES (1), (2), (3)) t(a) FULL OUTER JOIN (VALUES (1), (4)) s(a) ON t.a = s.a FULL OUTER JOIN (VALUES (2), (5)) r(a) ON t.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(t, s + 1, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "s")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s")))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))))));
    }
}

