/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRandomizeNullKeyInOuterJoin
extends BasePlanTest {
    private Session getSessionAlwaysEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("randomize_outer_join_null_key", "true").setSystemProperty("join_distribution_type", "PARTITIONED").build();
    }

    private Session getSessionEnabledWhenJoinKeyFromOuterJoin() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("randomize_outer_join_null_key", "false").setSystemProperty("randomize_outer_join_null_key_strategy", "key_from_outer_join").setSystemProperty("join_distribution_type", "PARTITIONED").build();
    }

    @Test
    public void testLeftJoin() {
        this.assertPlan("SELECT * FROM orders LEFT JOIN lineitem ON orders.orderkey = lineitem.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftRandom", "rightRandom")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftCol", (Object)PlanMatchPattern.expression("leftCol"), (Object)"leftRandom", (Object)PlanMatchPattern.expression("coalesce(cast(leftCol as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"leftCol", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightCol", (Object)PlanMatchPattern.expression("rightCol"), (Object)"rightRandom", (Object)PlanMatchPattern.expression("coalesce(cast(rightCol as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"rightCol", (Object)"orderkey")))))), false);
    }

    @Test
    public void testRightJoin() {
        this.assertPlan("SELECT * FROM orders RIGHT JOIN lineitem ON orders.orderkey = lineitem.orderkey ", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftRandom", "rightRandom")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftCol", (Object)PlanMatchPattern.expression("leftCol"), (Object)"leftRandom", (Object)PlanMatchPattern.expression("coalesce(cast(leftCol as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"leftCol", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightCol", (Object)PlanMatchPattern.expression("rightCol"), (Object)"rightRandom", (Object)PlanMatchPattern.expression("coalesce(cast(rightCol as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"rightCol", (Object)"orderkey")))))), false);
    }

    @Test
    public void testLeftJoinOnSameKey() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey left join lineitem l on ps.partkey = l.partkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "l_partkey_random")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "p_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey")))))), false);
    }

    @Test
    public void testLeftJoinOnDifferentKey() {
        this.assertPlan("select * from part p left join lineitem l on p.partkey = l.partkey left join orders o on l.orderkey = o.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey_random", "o_orderkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_orderkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("p_partkey_random", "l_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_orderkey", (Object)"orderkey"))))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"o_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(o_orderkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testLeftJoinOnMixedKey() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey left join lineitem l on ps.partkey = l.partkey left join orders o on l.orderkey = o.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey_random", "o_orderkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_orderkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "l_partkey_random")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "p_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_orderkey", (Object)"orderkey"))))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"o_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(o_orderkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testJoinKeyFromOuterJoin() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey left join lineitem l on ps.partkey = l.partkey left join orders o on l.orderkey = o.orderkey", this.getSessionEnabledWhenJoinKeyFromOuterJoin(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey_random", "o_orderkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_orderkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey", "l_partkey")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey", "p_partkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_orderkey", (Object)"orderkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"o_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(o_orderkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testCrossJoin() {
        this.assertPlan("SELECT * FROM orders CROSS JOIN lineitem", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"leftCol", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"rightCol", (Object)"orderkey"))))), false);
    }

    @Test
    public void testCrossJoinOverLeftJoin() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey CROSS JOIN lineitem l", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "p_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey", (Object)PlanMatchPattern.expression("ps_partkey"), (Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey", (Object)PlanMatchPattern.expression("p_partkey"), (Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey"))))), false);
    }
}

