/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRemoveRedundantDistinctAggregation
extends BasePlanTest {
    @Test
    public void testDistinctOverSingleGroupBy() {
        this.assertPlan("SELECT DISTINCT orderpriority, SUM(totalprice) FROM orders GROUP BY orderpriority", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finalsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority")))))))));
    }

    @Test
    public void testDistinctOverSingleGroupingSet() {
        this.assertPlan("SELECT DISTINCT orderpriority, SUM(totalprice) FROM orders GROUP BY GROUPING SETS ((orderpriority))", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finalsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority")))))))));
    }

    @Test
    public void testDistinctOverMultipleGroupingSet() {
        this.assertPlan("SELECT DISTINCT orderpriority, orderstatus, SUM(totalprice) FROM orders GROUP BY GROUPING SETS ((orderpriority), (orderstatus))", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finalsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.groupingSet((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"orderpriority"), (Object)ImmutableList.of((Object)"orderstatus")), (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"), "groupid", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority", (Object)"orderstatus", (Object)"orderstatus"))))))))))));
    }

    @Test
    public void testDistinctWithRandom() {
        this.assertPlan("SELECT DISTINCT orderpriority, random(), SUM(totalprice) FROM orders GROUP BY orderpriority", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finalsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority")))))))));
    }

    @Test
    public void testDistinctWithRandomFromGroupBy() {
        this.assertPlan("SELECT DISTINCT orderpriority, random(), sum from (select orderpriority, SUM(totalprice) as sum FROM orders GROUP BY orderpriority)", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finalsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority")))))))));
    }

    @Test
    public void testDistinctOverSubsetOfGroupBy() {
        this.assertPlan("SELECT DISTINCT orderpriority, sum FROM (SELECT orderpriority, orderstatus, SUM(totalprice) AS sum FROM orders GROUP BY orderpriority, orderstatus)", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finalsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority", (Object)"orderstatus", (Object)"orderstatus")))))))))));
    }

    @Test
    public void testDistinctExpressionWithGroupBy() {
        this.assertPlan("SELECT DISTINCT orderkey+1 AS orderkey, sum FROM (SELECT orderkey, SUM(totalprice) AS sum FROM orders GROUP BY orderkey)", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey+1")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderkey", (Object)"orderkey")))))))))));
    }

    @Test
    public void testJoinWithGroupByKey() {
        this.assertPlan("select distinct orderkey, avg, tax from (select orderkey, sum(totalprice) avg from orders group by orderkey) as t1 join lineitem using(orderkey)", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey", "orderkey")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey", (Object)"tax", (Object)"tax"))), PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"finallsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderkey", (Object)"orderkey"))))))))))));
    }

    @Test
    public void testJoinWithGroupByOnDifferentKey() {
        this.assertPlan("select distinct orderstatus, orderkey from (select orderstatus, max_by(orderkey, totalprice) orderkey from orders group by orderstatus) as t1 join lineitem using(orderkey)", this.useDefaultJoinSelectivity(false), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("max_by", "orderkey_10")), PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max_by", PlanMatchPattern.functionCall("max_by", (List<String>)ImmutableList.of((Object)"max_by_24"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max_by_24", PlanMatchPattern.functionCall("max_by", (List<String>)ImmutableList.of((Object)"orderkey", (Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderkey", (Object)"orderkey"))))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_10", (Object)"orderkey"))))))))));
    }

    @Test
    public void testJoinWithGroupByOnDifferentKeyUsingDefaultJoinSelectivityEnabled() {
        this.assertPlan("select distinct orderstatus, orderkey from (select orderstatus, max_by(orderkey, totalprice) orderkey from orders group by orderstatus) as t1 join lineitem using(orderkey)", this.useDefaultJoinSelectivity(true), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey_10", "max_by")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_10", (Object)"orderkey"))), PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max_by", PlanMatchPattern.functionCall("max_by", (List<String>)ImmutableList.of((Object)"max_by_24"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max_by_24", PlanMatchPattern.functionCall("max_by", (List<String>)ImmutableList.of((Object)"orderkey", (Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderkey", (Object)"orderkey")))))))))))));
    }

    private Session useDefaultJoinSelectivity(boolean useJoinSelectivity) {
        if (useJoinSelectivity) {
            return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("default_join_selectivity_coefficient", "0.1").build();
        }
        return this.getQueryRunner().getDefaultSession();
    }

    @Test
    public void testAggregationOverDistinct() {
        this.assertPlan("select orderstatus, max_by(orderpriority, sum) from (select distinct orderstatus, orderpriority, sum(totalprice) as sum from orders group by orderstatus, orderpriority) group by orderstatus", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"max_by", PlanMatchPattern.functionCall("max_by", (List<String>)ImmutableList.of((Object)"orderpriority", (Object)"sum"))), PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"paritialsum"))), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"paritialsum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"orderpriority", (Object)"orderpriority", (Object)"orderstatus", (Object)"orderstatus")))))))))));
    }
}

