/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.planPrinter.JsonRenderer;
import com.facebook.presto.sql.planner.planPrinter.NodeRepresentation;
import com.facebook.presto.sql.planner.planPrinter.PlanRepresentation;
import com.facebook.presto.testing.TestingEnvironment;
import com.facebook.presto.testing.TestingHandle;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonRenderer {
    private static final PlanBuilder PLAN_BUILDER = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
    private static final VariableReferenceExpression COLUMN_VARIABLE = new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR);
    private static final ColumnHandle COLUMN_HANDLE = new TestingMetadata.TestingColumnHandle("column");
    private static final VariableAllocator VARIABLE_ALLOCATOR = new VariableAllocator();
    private static final JsonRenderer JSON_RENDERER = new JsonRenderer(TestingEnvironment.FUNCTION_AND_TYPE_MANAGER);
    private static final TableHandle TABLE_HANDLE_WITH_LAYOUT = new TableHandle(new ConnectorId("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE));
    private static final JsonCodec<JsonRenderer.JsonRenderedNode> PLAN_CODEC;

    @Test
    public void testRoundtrip() {
        Map<PlanRepresentation, JsonRenderer.JsonRenderedNode> mapper = this.buildSimpleNodePlan();
        this.verify(mapper);
        mapper = this.buildMultiNodePlan();
        this.verify(mapper);
    }

    private PlanRepresentation getPlanRepresentation(PlanNode root) {
        return new PlanRepresentation(root, TypeProvider.viewOf((Map)VARIABLE_ALLOCATOR.getVariables()), Optional.empty(), Optional.empty());
    }

    private NodeRepresentation getNodeRepresentation(PlanNode root, List<PlanNodeId> planNodeIds) {
        return new NodeRepresentation(Optional.empty(), root.getId(), root.getClass().getName(), root.getClass().getSimpleName(), "", root.getOutputVariables(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), planNodeIds, (List)ImmutableList.of());
    }

    private Map<PlanRepresentation, JsonRenderer.JsonRenderedNode> buildPlanResult(PlanNode root) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        List childrenIds = (List)root.getSources().stream().map(PlanNode::getId).collect(ImmutableList.toImmutableList());
        PlanRepresentation key = this.getPlanRepresentation(root);
        NodeRepresentation nodeRepresentation = this.getNodeRepresentation(root, childrenIds);
        key.addNode(nodeRepresentation);
        JsonRenderer.JsonRenderedNode value = JSON_RENDERER.renderJson(key, nodeRepresentation);
        result.put((Object)key, (Object)value);
        return result.build();
    }

    private Map<PlanRepresentation, JsonRenderer.JsonRenderedNode> buildSimpleNodePlan() {
        TableScanNode scanNode = PLAN_BUILDER.tableScan(TABLE_HANDLE_WITH_LAYOUT, (List<VariableReferenceExpression>)ImmutableList.of((Object)COLUMN_VARIABLE), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)COLUMN_VARIABLE, (Object)COLUMN_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all());
        List childrenIds = (List)scanNode.getSources().stream().map(PlanNode::getId).collect(ImmutableList.toImmutableList());
        PlanRepresentation key = this.getPlanRepresentation((PlanNode)scanNode);
        NodeRepresentation nodeRepresentation = this.getNodeRepresentation((PlanNode)scanNode, childrenIds);
        key.addNode(nodeRepresentation);
        return this.buildPlanResult((PlanNode)scanNode);
    }

    private Map<PlanRepresentation, JsonRenderer.JsonRenderedNode> buildMultiNodePlan() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableMap map = ImmutableMap.of((Object)COLUMN_VARIABLE, (Object)COLUMN_VARIABLE);
        TableScanNode scan = PLAN_BUILDER.tableScan(TABLE_HANDLE_WITH_LAYOUT, (List<VariableReferenceExpression>)ImmutableList.of((Object)COLUMN_VARIABLE), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)COLUMN_VARIABLE, (Object)COLUMN_HANDLE));
        LimitNode limit = PLAN_BUILDER.limit(10L, (PlanNode)scan);
        ProjectNode root = PLAN_BUILDER.project(new Assignments((Map)map), (PlanNode)limit);
        return this.buildPlanResult((PlanNode)root);
    }

    private void verify(Map<PlanRepresentation, JsonRenderer.JsonRenderedNode> mapper) {
        for (PlanRepresentation key : mapper.keySet()) {
            String originKey = JSON_RENDERER.render(key);
            JsonRenderer.JsonRenderedNode result = (JsonRenderer.JsonRenderedNode)PLAN_CODEC.fromJson(originKey);
            JsonRenderer.JsonRenderedNode originValue = mapper.get(key);
            Assert.assertEquals((Object)result, (Object)originValue);
        }
    }

    static {
        JsonObjectMapperProvider provider = new JsonObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)new Serialization.VariableReferenceExpressionDeserializer((TypeManager)TestingEnvironment.FUNCTION_AND_TYPE_MANAGER)));
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider, true);
        PLAN_CODEC = codecFactory.jsonCodec(JsonRenderer.JsonRenderedNode.class);
    }
}

