/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingAggregations;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateStreamingAggregations
extends BasePlanTest {
    private Metadata metadata;
    private SqlParser sqlParser;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TableHandle nationTableHandle;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.sqlParser = this.getQueryRunner().getSqlParser();
        TpchTableHandle nationTpchTableHandle = new TpchTableHandle("nation", 1.0);
        ConnectorId connectorId = this.getCurrentConnectorId();
        this.nationTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)nationTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(nationTpchTableHandle, TupleDomain.all())));
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.variable("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))));
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.variable("unique"), p.variable("nationkey")).preGroupedVariables(p.variable("unique"), p.variable("nationkey")).source((PlanNode)p.assignUniqueId(p.variable("unique"), (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)))))));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Streaming aggregation with input not grouped on the grouping keys")
    public void testValidateFailed() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.variable("nationkey")).preGroupedVariables(p.variable("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))));
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder builder = new PlanBuilder(SessionTestUtils.TEST_SESSION, this.idAllocator, this.metadata);
        PlanNode planNode = planProvider.apply(builder);
        TypeProvider types = builder.getTypes();
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateStreamingAggregations().validate(planNode, session, this.metadata, this.sqlParser, types, WarningCollector.NOOP);
            return null;
        });
    }
}

