/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ttl;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ttl.ConfidenceBasedTtlInfo;
import com.facebook.presto.spi.ttl.NodeInfo;
import com.facebook.presto.spi.ttl.NodeTtl;
import com.facebook.presto.spi.ttl.NodeTtlFetcherFactory;
import com.facebook.presto.spi.ttl.TestingNodeTtlFetcherFactory;
import com.facebook.presto.ttl.nodettlfetchermanagers.ConfidenceBasedNodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManagerConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConfidenceBasedNodeTtlFetcherManager {
    private final InternalNode node1 = new InternalNode("node_1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true);
    private final InternalNode node2 = new InternalNode("node_2", URI.create("local://127.0.0.2"), NodeVersion.UNKNOWN, false);
    private final InternalNode node3 = new InternalNode("node_3", URI.create("local://127.0.0.3"), NodeVersion.UNKNOWN, false);
    private final NodeTtl ttl1 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(10L, 90.0)));
    private final NodeTtl ttl2 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(20L, 80.0)));
    private final NodeTtl ttl3 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(30L, 70.0)));
    private final Map<NodeInfo, NodeTtl> nodeToTtl = ImmutableMap.of((Object)new NodeInfo(this.node1.getNodeIdentifier(), this.node1.getHost()), (Object)this.ttl1, (Object)new NodeInfo(this.node2.getNodeIdentifier(), this.node2.getHost()), (Object)this.ttl2, (Object)new NodeInfo(this.node3.getNodeIdentifier(), this.node3.getHost()), (Object)this.ttl3);
    private InMemoryNodeManager nodeManager;
    private ConfidenceBasedNodeTtlFetcherManager nodeTtlFetcherManager;

    @BeforeClass
    public void setup() {
        this.nodeManager = new InMemoryNodeManager();
        this.nodeManager.addNode(new ConnectorId("prism"), (Iterable)ImmutableSet.of((Object)this.node1, (Object)this.node2, (Object)this.node3));
        this.nodeTtlFetcherManager = new ConfidenceBasedNodeTtlFetcherManager((InternalNodeManager)this.nodeManager, new NodeSchedulerConfig(), new NodeTtlFetcherManagerConfig());
        TestingNodeTtlFetcherFactory factory = new TestingNodeTtlFetcherFactory(this.nodeToTtl);
        this.nodeTtlFetcherManager.addNodeTtlFetcherFactory((NodeTtlFetcherFactory)factory);
        this.nodeTtlFetcherManager.load(factory.getName(), (Map)ImmutableMap.of());
        this.nodeTtlFetcherManager.refreshTtlInfo();
    }

    @Test
    public void testEmptyTtlInfo() {
        Assert.assertFalse((boolean)this.nodeTtlFetcherManager.getTtlInfo(this.nodeManager.getCurrentNode()).isPresent());
    }

    @Test
    public void testNonEmptyTtlInfo() {
        Assert.assertEquals((Object)this.nodeTtlFetcherManager.getTtlInfo(this.node2), Optional.of(new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(20L, 80.0)))));
        Assert.assertEquals((Object)this.nodeTtlFetcherManager.getTtlInfo(this.node3), Optional.of(new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(30L, 70.0)))));
    }

    @Test
    public void testGetAllTtls() {
        Assert.assertEquals((Map)this.nodeTtlFetcherManager.getAllTtls(), (Map)ImmutableMap.of((Object)this.node1, (Object)this.ttl1, (Object)this.node2, (Object)this.ttl2, (Object)this.node3, (Object)this.ttl3));
    }
}

