/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockSerdeUtil;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestType {
    private static final BlockEncodingSerde blockEncodingSerde = new BlockEncodingManager();
    protected static final FunctionAndTypeManager functionAndTypeManager = new FunctionAndTypeManager(InMemoryTransactionManager.createTestTransactionManager(), blockEncodingSerde, new FeaturesConfig(), new HandleResolver(), (Set)ImmutableSet.of());
    private final Class<?> objectValueType;
    private final Block testBlock;
    private final Type type;
    private final SortedMap<Integer, Object> expectedStackValues;
    private final SortedMap<Integer, Object> expectedObjectValues;
    private final Block testBlockWithNulls;

    protected AbstractTestType(Type type, Class<?> objectValueType, Block testBlock) {
        this(type, objectValueType, testBlock, testBlock);
    }

    protected AbstractTestType(Type type, Class<?> objectValueType, Block testBlock, Block expectedValues) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.objectValueType = Objects.requireNonNull(objectValueType, "objectValueType is null");
        this.testBlock = Objects.requireNonNull(testBlock, "testBlock is null");
        Objects.requireNonNull(expectedValues, "expectedValues is null");
        this.expectedStackValues = AbstractTestType.indexStackValues(type, expectedValues);
        this.expectedObjectValues = AbstractTestType.indexObjectValues(type, expectedValues);
        this.testBlockWithNulls = this.createAlternatingNullsBlock(testBlock);
    }

    private Block createAlternatingNullsBlock(Block testBlock) {
        BlockBuilder nullsBlockBuilder = this.type.createBlockBuilder(null, testBlock.getPositionCount());
        for (int position = 0; position < testBlock.getPositionCount(); ++position) {
            if (testBlock.isNull(position)) {
                Preconditions.checkState((boolean)(this.type instanceof UnknownType));
                nullsBlockBuilder.appendNull();
            } else if (this.type.getJavaType() == Boolean.TYPE) {
                this.type.writeBoolean(nullsBlockBuilder, this.type.getBoolean(testBlock, position));
            } else if (this.type.getJavaType() == Long.TYPE) {
                this.type.writeLong(nullsBlockBuilder, this.type.getLong(testBlock, position));
            } else if (this.type.getJavaType() == Double.TYPE) {
                this.type.writeDouble(nullsBlockBuilder, this.type.getDouble(testBlock, position));
            } else if (this.type.getJavaType() == Slice.class) {
                Slice slice = this.type.getSlice(testBlock, position);
                this.type.writeSlice(nullsBlockBuilder, slice, 0, slice.length());
            } else {
                this.type.writeObject(nullsBlockBuilder, this.type.getObject(testBlock, position));
            }
            nullsBlockBuilder.appendNull();
        }
        return nullsBlockBuilder.build();
    }

    @Test
    public void testBlock() {
        for (Map.Entry<Integer, Object> entry : this.expectedStackValues.entrySet()) {
            this.assertPositionEquals(this.testBlock, entry.getKey(), entry.getValue(), this.expectedObjectValues.get(entry.getKey()));
        }
        for (Map.Entry<Integer, Object> entry : this.expectedStackValues.entrySet()) {
            this.assertPositionEquals(this.testBlockWithNulls, entry.getKey() * 2, entry.getValue(), this.expectedObjectValues.get(entry.getKey()));
            this.assertPositionEquals(this.testBlockWithNulls, entry.getKey() * 2 + 1, null, null);
        }
    }

    protected void assertPositionEquals(Block block, int position, Object expectedStackValue, Object expectedObjectValue) {
        long hash = 0L;
        if (this.type.isComparable()) {
            hash = TypeUtils.hashPosition((Type)this.type, (Block)block, (int)position);
        }
        this.assertPositionValue(block, position, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getSingleValueBlock(position), 0, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(position, 1), 0, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(0, position + 1), position, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedStackValue, hash, expectedObjectValue);
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        this.type.appendTo(block, position, blockBuilder);
        this.assertPositionValue(blockBuilder.build(), 0, expectedStackValue, hash, expectedObjectValue);
    }

    private void assertPositionValue(Block block, int position, Object expectedStackValue, long expectedHash, Object expectedObjectValue) {
        Object objectValue = this.type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position);
        Assert.assertEquals((Object)objectValue, (Object)expectedObjectValue);
        if (objectValue != null) {
            Assertions.assertInstanceOf((Object)objectValue, this.objectValueType);
        }
        if (this.type.isComparable()) {
            Assert.assertEquals((long)TypeUtils.hashPosition((Type)this.type, (Block)block, (int)position), (long)expectedHash);
        } else {
            try {
                this.type.hash(block, position);
                Assert.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        Block expectedBlock = AbstractTestType.createBlock(this.type, expectedStackValue);
        if (this.type.isComparable()) {
            Assert.assertTrue((boolean)TypeUtils.positionEqualsPosition((Type)this.type, (Block)block, (int)position, (Block)block, (int)position));
            Assert.assertTrue((boolean)TypeUtils.positionEqualsPosition((Type)this.type, (Block)block, (int)position, (Block)expectedBlock, (int)0));
            Assert.assertTrue((boolean)TypeUtils.positionEqualsPosition((Type)this.type, (Block)expectedBlock, (int)0, (Block)block, (int)position));
        }
        Assert.assertEquals((boolean)block.isNull(position), (expectedStackValue == null ? 1 : 0) != 0);
        if (this.type.isOrderable()) {
            Assert.assertTrue((SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.ASC_NULLS_LAST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.DESC_NULLS_FIRST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.DESC_NULLS_LAST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
        } else {
            try {
                this.type.compareTo(block, position, expectedBlock, 0);
                Assert.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.verifyInvalidPositionHandling(block);
        if (block.isNull(position)) {
            if (this.type.isOrderable() && !(this.type instanceof UnknownType)) {
                Block nonNullValue = this.toBlock(this.getNonNullValue());
                Assert.assertTrue((SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, position, nonNullValue, 0) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((SortOrder.ASC_NULLS_LAST.compareBlockValue(this.type, block, position, nonNullValue, 0) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((SortOrder.DESC_NULLS_FIRST.compareBlockValue(this.type, block, position, nonNullValue, 0) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((SortOrder.DESC_NULLS_LAST.compareBlockValue(this.type, block, position, nonNullValue, 0) > 0 ? 1 : 0) != 0);
            }
            return;
        }
        if (this.type.isOrderable() && expectedStackValue != Boolean.TRUE) {
            Block greaterValue = this.toBlock(this.getGreaterValue(expectedStackValue));
            Assertions.assertLessThan((Comparable)Integer.valueOf(SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, position, greaterValue, 0)), (Comparable)Integer.valueOf(0));
            Assertions.assertLessThan((Comparable)Integer.valueOf(SortOrder.ASC_NULLS_LAST.compareBlockValue(this.type, block, position, greaterValue, 0)), (Comparable)Integer.valueOf(0));
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(SortOrder.DESC_NULLS_FIRST.compareBlockValue(this.type, block, position, greaterValue, 0)), (Comparable)Integer.valueOf(0));
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(SortOrder.DESC_NULLS_LAST.compareBlockValue(this.type, block, position, greaterValue, 0)), (Comparable)Integer.valueOf(0));
        }
        if (this.type.getJavaType() == Boolean.TYPE) {
            Assert.assertEquals((Object)this.type.getBoolean(block, position), (Object)expectedStackValue);
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getObject(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {}
        } else if (this.type.getJavaType() == Long.TYPE) {
            Assert.assertEquals((Object)this.type.getLong(block, position), (Object)expectedStackValue);
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getObject(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {}
        } else if (this.type.getJavaType() == Double.TYPE) {
            Assert.assertEquals((Object)this.type.getDouble(block, position), (Object)expectedStackValue);
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getObject(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {}
        } else if (this.type.getJavaType() == Slice.class) {
            Assert.assertEquals((Object)this.type.getSlice(block, position), (Object)expectedStackValue);
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {
                // empty catch block
            }
            try {
                this.type.getObject(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException greaterValue) {}
        } else {
            DynamicSliceOutput actualSliceOutput = new DynamicSliceOutput(100);
            BlockSerdeUtil.writeBlock((BlockEncodingSerde)blockEncodingSerde, (SliceOutput)actualSliceOutput, (Block)((Block)this.type.getObject(block, position)));
            DynamicSliceOutput expectedSliceOutput = new DynamicSliceOutput(actualSliceOutput.size());
            BlockSerdeUtil.writeBlock((BlockEncodingSerde)blockEncodingSerde, (SliceOutput)expectedSliceOutput, (Block)((Block)expectedStackValue));
            Assert.assertEquals((Object)actualSliceOutput.slice(), (Object)expectedSliceOutput.slice());
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getSlice(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
        }
    }

    private void verifyInvalidPositionHandling(Block block) {
        Block other;
        try {
            this.type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, -1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, block.getPositionCount());
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.type.hash(block, -1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.type.hash(block, block.getPositionCount());
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.type.isComparable() && !(this.type instanceof UnknownType)) {
            other = this.toBlock(this.getNonNullValue());
            try {
                this.type.equalTo(block, -1, other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.type.equalTo(block, block.getPositionCount(), other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.type.isOrderable() && !(this.type instanceof UnknownType)) {
            other = this.toBlock(this.getNonNullValue());
            try {
                SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, -1, other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, block.getPositionCount(), other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.type.getJavaType() == Boolean.TYPE) {
            try {
                this.type.getBoolean(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getBoolean(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {}
        } else if (this.type.getJavaType() == Long.TYPE) {
            try {
                this.type.getLong(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getLong(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {}
        } else if (this.type.getJavaType() == Double.TYPE) {
            try {
                this.type.getDouble(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {}
        } else if (this.type.getJavaType() == Slice.class) {
            try {
                this.type.getSlice(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.type.getSlice(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private static Block createBlock(Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        Class javaType = type.getJavaType();
        if (value == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
        return blockBuilder.build();
    }

    protected abstract Object getGreaterValue(Object var1);

    protected Object getNonNullValue() {
        return AbstractTestType.getNonNullValueForType(this.type);
    }

    private static Object getNonNullValueForType(Type type) {
        if (type.getJavaType() == Boolean.TYPE) {
            return true;
        }
        if (type.getJavaType() == Long.TYPE) {
            return 1L;
        }
        if (type.getJavaType() == Double.TYPE) {
            return 1.0;
        }
        if (type.getJavaType() == Slice.class) {
            return Slices.utf8Slice((String)"_");
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            Object elementNonNullValue = AbstractTestType.getNonNullValueForType(elementType);
            return StructuralTestUtil.arrayBlockOf(elementType, elementNonNullValue);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            Object keyNonNullValue = AbstractTestType.getNonNullValueForType(keyType);
            Object valueNonNullValue = AbstractTestType.getNonNullValueForType(valueType);
            ImmutableMap map = ImmutableMap.of((Object)keyNonNullValue, (Object)valueNonNullValue);
            return StructuralTestUtil.mapBlockOf(keyType, valueType, map);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List elementTypes = rowType.getTypeParameters();
            Object[] elementNonNullValues = elementTypes.stream().map(AbstractTestType::getNonNullValueForType).toArray(Object[]::new);
            return OperatorAssertion.toRow(elementTypes, elementNonNullValues);
        }
        throw new IllegalStateException("Unsupported Java type " + type.getJavaType() + " (for type " + type + ")");
    }

    private Block toBlock(Object value) {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        Class javaType = this.type.getJavaType();
        if (value == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            this.type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            this.type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            this.type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            this.type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            this.type.writeObject(blockBuilder, value);
        }
        return blockBuilder.build();
    }

    private static SortedMap<Integer, Object> indexStackValues(Type type, Block block) {
        TreeMap<Integer, Object> values = new TreeMap<Integer, Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                values.put(position, null);
                continue;
            }
            if (type.getJavaType() == Boolean.TYPE) {
                values.put(position, type.getBoolean(block, position));
                continue;
            }
            if (type.getJavaType() == Long.TYPE) {
                values.put(position, type.getLong(block, position));
                continue;
            }
            if (type.getJavaType() == Double.TYPE) {
                values.put(position, type.getDouble(block, position));
                continue;
            }
            if (type.getJavaType() == Slice.class) {
                values.put(position, type.getSlice(block, position));
                continue;
            }
            values.put(position, type.getObject(block, position));
        }
        return Collections.unmodifiableSortedMap(values);
    }

    private static SortedMap<Integer, Object> indexObjectValues(Type type, Block block) {
        TreeMap<Integer, Object> values = new TreeMap<Integer, Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.put(position, type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position));
        }
        return Collections.unmodifiableSortedMap(values);
    }
}

