/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogAggregationFunction;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestKHyperLogLogAggregationFunction {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final String NAME = KHyperLogLogAggregationFunction.class.getAnnotation(AggregationFunction.class).value();

    @Test
    public void testSimpleKHyperLogLog() {
        int sampleSize = 100;
        List<Long> longs = this.generateLongs(sampleSize);
        List<Slice> strings = this.generateStringSlices(sampleSize);
        List<Double> doubles = this.generateDoubles(sampleSize);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)VarcharType.VARCHAR, strings);
    }

    @Test
    public void testBigKHyperLogLog() {
        int sampleSize = 100000;
        List<Long> longs = this.generateLongs(sampleSize);
        List<Slice> strings = this.generateStringSlices(sampleSize);
        List<Double> doubles = this.generateDoubles(sampleSize);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)VarcharType.VARCHAR, strings);
    }

    @Test
    public void testKHyperLogLogWithSomeNulls() {
        int sampleSize = 3;
        List<Long> longs = this.generateLongs(sampleSize);
        List<Slice> strings = this.generateStringSlices(sampleSize);
        List<Double> doubles = this.generateDoubles(sampleSize);
        this.includeNulls(longs);
        this.includeNulls(strings);
        this.includeNulls(doubles);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)VarcharType.VARCHAR, strings);
    }

    @Test
    public void testKHyperLogLogWithNullColumn() {
        int sampleSize = 3;
        List<Long> longs = this.generateLongs(sampleSize);
        List<Slice> strings = this.generateStringSlices(sampleSize);
        List<Double> doubles = this.generateDoubles(sampleSize);
        List<Object> nulls = this.generateNulls(sampleSize);
        this.testAggregation((Type)BigintType.BIGINT, nulls, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)BigintType.BIGINT, nulls);
        this.testAggregation((Type)BigintType.BIGINT, nulls, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)BigintType.BIGINT, longs, (Type)VarcharType.VARCHAR, nulls);
        this.testAggregation((Type)VarcharType.VARCHAR, nulls, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)BigintType.BIGINT, nulls);
        this.testAggregation((Type)VarcharType.VARCHAR, nulls, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)VarcharType.VARCHAR, strings, (Type)VarcharType.VARCHAR, nulls);
        this.testAggregation((Type)DoubleType.DOUBLE, nulls, (Type)BigintType.BIGINT, longs);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)BigintType.BIGINT, nulls);
        this.testAggregation((Type)DoubleType.DOUBLE, nulls, (Type)VarcharType.VARCHAR, strings);
        this.testAggregation((Type)DoubleType.DOUBLE, doubles, (Type)VarcharType.VARCHAR, nulls);
    }

    private void testAggregation(Type valueType, List<?> values, Type uiiType, List<?> uiis) {
        JavaAggregationFunctionImplementation aggregationFunction = TestKHyperLogLogAggregationFunction.getAggregation(valueType, uiiType);
        KHyperLogLog khll = null;
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null || uiis.get(i) == null) continue;
            if (khll == null) {
                khll = new KHyperLogLog();
            }
            long value = this.toLong(values.get(i), valueType);
            long uii = this.toLong(uiis.get(i), uiiType);
            if (valueType == VarcharType.VARCHAR) {
                khll.add((Slice)values.get(i), uii);
                continue;
            }
            khll.add(value, uii);
        }
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)(khll == null ? null : new SqlVarbinary(khll.serialize().getBytes())), this.buildBlock(values, valueType), this.buildBlock(uiis, uiiType));
    }

    private long toLong(Object value, Type type) {
        if (type == DoubleType.DOUBLE) {
            return Double.doubleToLongBits((Double)value);
        }
        if (type == VarcharType.VARCHAR) {
            return XxHash64.hash((Slice)((Slice)value));
        }
        return (Long)value;
    }

    private Block buildBlock(List<?> values, Type type) {
        if (type == DoubleType.DOUBLE) {
            return BlockAssertions.createDoublesBlock(values.stream().map(o -> (Double)o).collect(Collectors.toList()));
        }
        if (type == VarcharType.VARCHAR) {
            return BlockAssertions.createSlicesBlock(values.stream().map(o -> (Slice)o).collect(Collectors.toList()));
        }
        return BlockAssertions.createLongsBlock(values.stream().map(o -> (Long)o).collect(Collectors.toList()));
    }

    private List<Slice> buildStringSliceList(List<String> strings) {
        return strings.stream().map(this::stringToSlice).collect(Collectors.toList());
    }

    private Slice stringToSlice(String s) {
        if (s == null) {
            return null;
        }
        return Slices.utf8Slice((String)s);
    }

    private static JavaAggregationFunctionImplementation getAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(NAME, TypeSignatureProvider.fromTypes((Type[])arguments)));
    }

    private List<Long> generateLongs(int size) {
        Random generator = new Random(13L);
        return generator.longs(size).boxed().collect(Collectors.toList());
    }

    private List<Slice> generateStringSlices(int size) {
        Random generator = new Random(123L);
        return this.buildStringSliceList(generator.longs(size).boxed().map(Long::toHexString).collect(Collectors.toList()));
    }

    private List<Double> generateDoubles(int size) {
        Random generator = new Random(123L);
        return generator.doubles(size).boxed().collect(Collectors.toList());
    }

    private List<Object> generateNulls(int size) {
        return Arrays.asList(new Object[size]);
    }

    private <K> List<K> includeNulls(List<K> values) {
        Random generator = new Random(123L);
        for (int i = 0; i < values.size(); ++i) {
            if (!(generator.nextDouble() < 0.2)) continue;
            values.set(i, null);
        }
        return values;
    }
}

