/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FullConnectorSession
implements ConnectorSession {
    private final Session session;
    private final ConnectorIdentity identity;
    private final Map<String, String> properties;
    private final ConnectorId connectorId;
    private final String catalog;
    private final SessionPropertyManager sessionPropertyManager;
    private final SqlFunctionProperties sqlFunctionProperties;
    private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;

    public FullConnectorSession(Session session, ConnectorIdentity identity) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.properties = null;
        this.connectorId = null;
        this.catalog = null;
        this.sessionPropertyManager = null;
        this.sqlFunctionProperties = session.getSqlFunctionProperties();
        this.sessionFunctions = ImmutableMap.copyOf(session.getSessionFunctions());
    }

    public FullConnectorSession(Session session, ConnectorIdentity identity, Map<String, String> properties, ConnectorId connectorId, String catalog, SessionPropertyManager sessionPropertyManager) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.sqlFunctionProperties = session.getSqlFunctionProperties();
        this.sessionFunctions = ImmutableMap.copyOf(session.getSessionFunctions());
    }

    public Session getSession() {
        return this.session;
    }

    public String getQueryId() {
        return this.session.getQueryId().toString();
    }

    public Optional<String> getSource() {
        return this.session.getSource();
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public Locale getLocale() {
        return this.session.getLocale();
    }

    public long getStartTime() {
        return this.session.getStartTime();
    }

    public Optional<String> getTraceToken() {
        return this.session.getTraceToken();
    }

    public Optional<String> getClientInfo() {
        return this.session.getClientInfo();
    }

    public Set<String> getClientTags() {
        return this.session.getClientTags();
    }

    public SqlFunctionProperties getSqlFunctionProperties() {
        return this.sqlFunctionProperties;
    }

    public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions() {
        return this.sessionFunctions;
    }

    public <T> T getProperty(String propertyName, Class<T> type) {
        if (this.properties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unknown session property: %s.%s", this.catalog, propertyName));
        }
        return this.sessionPropertyManager.decodeCatalogPropertyValue(this.connectorId, this.catalog, propertyName, this.properties.get(propertyName), type);
    }

    public Optional<String> getSchema() {
        return this.session.getSchema();
    }

    public boolean isReadConstraints() {
        return SystemSessionProperties.isExploitConstraints(this.session);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.getQueryId()).add("user", (Object)this.getUser()).add("source", this.getSource().orElse(null)).add("traceToken", this.getTraceToken().orElse(null)).add("locale", (Object)this.getLocale()).add("startTime", this.getStartTime()).add("properties", this.properties).omitNullValues().toString();
    }

    public WarningCollector getWarningCollector() {
        return this.session.getWarningCollector();
    }
}

