/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoricalPlanStatisticsEntry;
import com.facebook.presto.spi.statistics.PlanStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HistoricalPlanStatisticsUtil {
    private HistoricalPlanStatisticsUtil() {
    }

    public static PlanStatistics getPredictedPlanStatistics(HistoricalPlanStatistics historicalPlanStatistics, List<PlanStatistics> inputTableStatistics, HistoryBasedOptimizationConfig config) {
        List lastRunsStatistics = historicalPlanStatistics.getLastRunsStatistics();
        if (lastRunsStatistics.isEmpty()) {
            return PlanStatistics.empty();
        }
        Optional<Integer> similarStatsIndex = HistoricalPlanStatisticsUtil.getSimilarStatsIndex(historicalPlanStatistics, inputTableStatistics, config.getHistoryMatchingThreshold());
        if (similarStatsIndex.isPresent()) {
            return ((HistoricalPlanStatisticsEntry)lastRunsStatistics.get(similarStatsIndex.get())).getPlanStatistics();
        }
        return PlanStatistics.empty();
    }

    public static HistoricalPlanStatistics updatePlanStatistics(HistoricalPlanStatistics historicalPlanStatistics, List<PlanStatistics> inputTableStatistics, PlanStatistics current, HistoryBasedOptimizationConfig config) {
        int maxLastRuns;
        List lastRunsStatistics = historicalPlanStatistics.getLastRunsStatistics();
        ArrayList<HistoricalPlanStatisticsEntry> newLastRunsStatistics = new ArrayList<HistoricalPlanStatisticsEntry>(lastRunsStatistics);
        Optional<Integer> similarStatsIndex = HistoricalPlanStatisticsUtil.getSimilarStatsIndex(historicalPlanStatistics, inputTableStatistics, config.getHistoryMatchingThreshold());
        if (similarStatsIndex.isPresent()) {
            newLastRunsStatistics.remove(similarStatsIndex.get());
        }
        newLastRunsStatistics.add(new HistoricalPlanStatisticsEntry(current, inputTableStatistics));
        int n = maxLastRuns = inputTableStatistics.isEmpty() ? 1 : config.getMaxLastRunsHistory();
        if (newLastRunsStatistics.size() > maxLastRuns) {
            newLastRunsStatistics.remove(0);
        }
        return new HistoricalPlanStatistics(newLastRunsStatistics);
    }

    private static Optional<Integer> getSimilarStatsIndex(HistoricalPlanStatistics historicalPlanStatistics, List<PlanStatistics> inputTableStatistics, double threshold) {
        List lastRunsStatistics = historicalPlanStatistics.getLastRunsStatistics();
        if (lastRunsStatistics.isEmpty()) {
            return Optional.empty();
        }
        for (int lastRunsIndex = 0; lastRunsIndex < lastRunsStatistics.size(); ++lastRunsIndex) {
            if (inputTableStatistics.size() != ((HistoricalPlanStatisticsEntry)lastRunsStatistics.get(lastRunsIndex)).getInputTableStatistics().size()) continue;
            boolean rowSimilarity = true;
            boolean outputSizeSimilarity = true;
            for (int inputTablesIndex = 0; inputTablesIndex < inputTableStatistics.size(); ++inputTablesIndex) {
                PlanStatistics currentInputStatistics = inputTableStatistics.get(inputTablesIndex);
                PlanStatistics historicalInputStatistics = (PlanStatistics)((HistoricalPlanStatisticsEntry)lastRunsStatistics.get(lastRunsIndex)).getInputTableStatistics().get(inputTablesIndex);
                rowSimilarity = rowSimilarity && HistoricalPlanStatisticsUtil.similarStats(currentInputStatistics.getRowCount().getValue(), historicalInputStatistics.getRowCount().getValue(), threshold);
                outputSizeSimilarity = outputSizeSimilarity && HistoricalPlanStatisticsUtil.similarStats(currentInputStatistics.getOutputSize().getValue(), historicalInputStatistics.getOutputSize().getValue(), threshold);
            }
            if (!rowSimilarity || !outputSizeSimilarity) continue;
            return Optional.of(lastRunsIndex);
        }
        return Optional.empty();
    }

    private static boolean similarStats(double stats1, double stats2, double threshold) {
        if (Double.isNaN(stats1) && Double.isNaN(stats2)) {
            return true;
        }
        return stats1 >= (1.0 - threshold) * stats2 && stats1 <= (1.0 + threshold) * stats2;
    }
}

