/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.HistoricalPlanStatisticsUtil;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedStatisticsCacheManager;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Plans;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class HistoryBasedPlanStatisticsCalculator
implements StatsCalculator {
    private static final List<Class<? extends PlanNode>> PRECOMPUTE_PLAN_NODES = ImmutableList.of(JoinNode.class, SemiJoinNode.class, AggregationNode.class);
    private final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider;
    private final HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager;
    private final StatsCalculator delegate;
    private final PlanCanonicalInfoProvider planCanonicalInfoProvider;
    private final HistoryBasedOptimizationConfig config;

    public HistoryBasedPlanStatisticsCalculator(Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager, StatsCalculator delegate, PlanCanonicalInfoProvider planCanonicalInfoProvider, HistoryBasedOptimizationConfig config) {
        this.historyBasedPlanStatisticsProvider = Objects.requireNonNull(historyBasedPlanStatisticsProvider, "historyBasedPlanStatisticsProvider is null");
        this.historyBasedStatisticsCacheManager = Objects.requireNonNull(historyBasedStatisticsCacheManager, "historyBasedStatisticsCacheManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.planCanonicalInfoProvider = Objects.requireNonNull(planCanonicalInfoProvider, "planHasher is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    @Override
    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate delegateStats = this.delegate.calculateStats(node, sourceStats, lookup, session, types);
        return this.getStatistics(node, session, lookup, delegateStats);
    }

    @Override
    public void registerPlan(PlanNode root, Session session) {
        if (!PlanNodeSearcher.searchFrom(root).where(node -> PRECOMPUTE_PLAN_NODES.stream().anyMatch(clazz -> clazz.isInstance(node))).matches()) {
            return;
        }
        ImmutableList.Builder planNodesWithHash = ImmutableList.builder();
        Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root).forEach(plan -> {
            if (plan.getStatsEquivalentPlanNode().isPresent()) {
                planNodesWithHash.addAll(this.getPlanNodeHashes((PlanNode)plan, session).values());
            }
        });
        try {
            this.historyBasedStatisticsCacheManager.getStatisticsCache(session.getQueryId(), this.historyBasedPlanStatisticsProvider).getAll((Iterable)planNodesWithHash.build());
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to register plan: ", e.getCause());
        }
    }

    @VisibleForTesting
    public PlanCanonicalInfoProvider getPlanCanonicalInfoProvider() {
        return this.planCanonicalInfoProvider;
    }

    private Map<PlanCanonicalizationStrategy, PlanNodeWithHash> getPlanNodeHashes(PlanNode plan, Session session) {
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session) || !plan.getStatsEquivalentPlanNode().isPresent()) {
            return ImmutableMap.of();
        }
        PlanNode statsEquivalentPlanNode = (PlanNode)plan.getStatsEquivalentPlanNode().get();
        ImmutableMap.Builder allHashesBuilder = ImmutableMap.builder();
        for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
            Optional<String> hash = this.planCanonicalInfoProvider.hash(session, statsEquivalentPlanNode, strategy);
            allHashesBuilder.put((Object)strategy, (Object)new PlanNodeWithHash(statsEquivalentPlanNode, hash));
        }
        return allHashesBuilder.build();
    }

    private PlanNodeStatsEstimate getStatistics(PlanNode planNode, Session session, Lookup lookup, PlanNodeStatsEstimate delegateStats) {
        PlanNode plan = Plans.resolveGroupReferences(planNode, lookup);
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session)) {
            return delegateStats;
        }
        Map<PlanCanonicalizationStrategy, PlanNodeWithHash> allHashes = this.getPlanNodeHashes(plan, session);
        ImmutableMap statistics = ImmutableMap.of();
        try {
            statistics = this.historyBasedStatisticsCacheManager.getStatisticsCache(session.getQueryId(), this.historyBasedPlanStatisticsProvider).getAll((Iterable)allHashes.values().stream().distinct().collect(ImmutableList.toImmutableList()));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(String.format("Unable to get plan statistics for %s", planNode), e.getCause());
        }
        for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
            for (Map.Entry entry : statistics.entrySet()) {
                PlanStatistics predictedPlanStatistics;
                Optional<List<PlanStatistics>> inputTableStatistics;
                if (!allHashes.containsKey(strategy) || !((PlanNodeWithHash)entry.getKey()).getHash().isPresent() || !allHashes.get(strategy).equals(entry.getKey()) || !(inputTableStatistics = this.getPlanNodeInputTableStatistics(plan, session)).isPresent() || !((predictedPlanStatistics = HistoricalPlanStatisticsUtil.getPredictedPlanStatistics((HistoricalPlanStatistics)entry.getValue(), inputTableStatistics.get(), this.config)).getConfidence() > 0.0)) continue;
                return delegateStats.combineStats(predictedPlanStatistics, (SourceInfo)new HistoryBasedSourceInfo(((PlanNodeWithHash)entry.getKey()).getHash(), inputTableStatistics));
            }
        }
        return delegateStats;
    }

    private Optional<List<PlanStatistics>> getPlanNodeInputTableStatistics(PlanNode plan, Session session) {
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session) || !plan.getStatsEquivalentPlanNode().isPresent()) {
            return Optional.empty();
        }
        PlanNode statsEquivalentPlanNode = (PlanNode)plan.getStatsEquivalentPlanNode().get();
        return this.planCanonicalInfoProvider.getInputTableStatistics(session, statsEquivalentPlanNode);
    }
}

