/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.CreateRole;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class CreateRoleTask
implements DDLDefinitionTask<CreateRole> {
    @Override
    public String getName() {
        return "CREATE ROLE";
    }

    @Override
    public ListenableFuture<?> execute(CreateRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        String catalog = MetadataUtil.createCatalogName(session, (Node)statement);
        String role = statement.getName().getValue().toLowerCase(Locale.ENGLISH);
        Optional<PrestoPrincipal> grantor = statement.getGrantor().map(specification -> MetadataUtil.createPrincipal(session, specification));
        accessControl.checkCanCreateRole(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), role, grantor, catalog);
        Set<String> existingRoles = metadata.listRoles(session, catalog);
        if (existingRoles.contains(role)) {
            throw new SemanticException(SemanticErrorCode.ROLE_ALREADY_EXIST, (Node)statement, "Role '%s' already exists", new Object[]{role});
        }
        if (grantor.isPresent() && grantor.get().getType() == PrincipalType.ROLE && !existingRoles.contains(grantor.get().getName())) {
            throw new SemanticException(SemanticErrorCode.MISSING_ROLE, (Node)statement, "Role '%s' does not exist", new Object[]{grantor.get().getName()});
        }
        metadata.createRole(session, role, grantor, catalog);
        return Futures.immediateFuture(null);
    }
}

