/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@ThriftStruct
@Immutable
public class TaskInfo {
    private final TaskId taskId;
    private final TaskStatus taskStatus;
    private final DateTime lastHeartbeat;
    private final OutputBufferInfo outputBuffers;
    private final Set<PlanNodeId> noMoreSplits;
    private final TaskStats stats;
    private final boolean needsPlan;
    private final MetadataUpdates metadataUpdates;
    private final String nodeId;

    @JsonCreator
    @ThriftConstructor
    public TaskInfo(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="outputBuffers") OutputBufferInfo outputBuffers, @JsonProperty(value="noMoreSplits") Set<PlanNodeId> noMoreSplits, @JsonProperty(value="stats") TaskStats stats, @JsonProperty(value="needsPlan") boolean needsPlan, @JsonProperty(value="metadataUpdates") MetadataUpdates metadataUpdates, @JsonProperty(value="nodeId") String nodeId) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskStatus = Objects.requireNonNull(taskStatus, "taskStatus is null");
        this.lastHeartbeat = Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        this.noMoreSplits = Objects.requireNonNull(noMoreSplits, "noMoreSplits is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.needsPlan = needsPlan;
        this.metadataUpdates = metadataUpdates;
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
    }

    @JsonProperty
    @ThriftField(value=1)
    public TaskId getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    @ThriftField(value=2)
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @JsonProperty
    @ThriftField(value=3)
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonProperty
    @ThriftField(value=4)
    public OutputBufferInfo getOutputBuffers() {
        return this.outputBuffers;
    }

    @JsonProperty
    @ThriftField(value=5)
    public Set<PlanNodeId> getNoMoreSplits() {
        return this.noMoreSplits;
    }

    @JsonProperty
    @ThriftField(value=6)
    public TaskStats getStats() {
        return this.stats;
    }

    @JsonProperty
    @ThriftField(value=7)
    public boolean isNeedsPlan() {
        return this.needsPlan;
    }

    @JsonProperty
    @ThriftField(value=8)
    public MetadataUpdates getMetadataUpdates() {
        return this.metadataUpdates;
    }

    @JsonProperty
    @ThriftField(value=9)
    public String getNodeId() {
        return this.nodeId;
    }

    public TaskInfo summarize() {
        if (this.taskStatus.getState().isDone()) {
            return new TaskInfo(this.taskId, this.taskStatus, this.lastHeartbeat, this.outputBuffers.summarize(), this.noMoreSplits, this.stats.summarizeFinal(), this.needsPlan, this.metadataUpdates, this.nodeId);
        }
        return new TaskInfo(this.taskId, this.taskStatus, this.lastHeartbeat, this.outputBuffers.summarize(), this.noMoreSplits, this.stats.summarize(), this.needsPlan, this.metadataUpdates, this.nodeId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("state", (Object)this.taskStatus.getState()).toString();
    }

    public static TaskInfo createInitialTask(TaskId taskId, URI location, List<BufferInfo> bufferStates, TaskStats taskStats, String nodeId) {
        return new TaskInfo(taskId, TaskStatus.initialTaskStatus(location), DateTime.now(), new OutputBufferInfo("UNINITIALIZED", BufferState.OPEN, true, true, 0L, 0L, 0L, 0L, bufferStates), (Set<PlanNodeId>)ImmutableSet.of(), taskStats, true, MetadataUpdates.DEFAULT_METADATA_UPDATES, nodeId);
    }

    public TaskInfo withTaskStatus(TaskStatus newTaskStatus) {
        return new TaskInfo(this.taskId, newTaskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats, this.needsPlan, this.metadataUpdates, this.nodeId);
    }
}

