/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.presto.util.PowerOfTwo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.big-query-max-task-memory", "task.max-memory", "task.http-notification-threads", "task.info-refresh-max-wait", "task.operator-pre-allocated-memory", "sink.new-implementation", "task.legacy-scheduling-behavior", "task.level-absolute-priority"})
public class TaskManagerConfig {
    private boolean perOperatorCpuTimerEnabled = true;
    private boolean taskCpuTimerEnabled = true;
    private boolean statisticsCpuTimerEnabled = true;
    private boolean perOperatorAllocationTrackingEnabled;
    private boolean taskAllocationTrackingEnabled;
    private DataSize maxPartialAggregationMemoryUsage = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize maxLocalExchangeBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private DataSize maxIndexMemoryUsage = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private boolean shareIndexLoading;
    private int maxWorkerThreads = Runtime.getRuntime().availableProcessors() * 2;
    private Integer minDrivers;
    private Integer initialSplitsPerNode;
    private int minDriversPerTask = 3;
    private int maxDriversPerTask = Integer.MAX_VALUE;
    private int maxTasksPerStage = Integer.MAX_VALUE;
    private Duration splitConcurrencyAdjustmentInterval = new Duration(100.0, TimeUnit.MILLISECONDS);
    private DataSize sinkMaxBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private DataSize maxPagePartitioningBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private Duration clientTimeout = new Duration(2.0, TimeUnit.MINUTES);
    private Duration infoMaxAge = new Duration(15.0, TimeUnit.MINUTES);
    private Duration statusRefreshMaxWait = new Duration(1.0, TimeUnit.SECONDS);
    private Duration infoRefreshMaxWait = new Duration(0.0, TimeUnit.SECONDS);
    private Duration infoUpdateInterval = new Duration(3.0, TimeUnit.SECONDS);
    private int writerCount = 1;
    private Integer partitionedWriterCount;
    private int taskConcurrency = 16;
    private int httpResponseThreads = 100;
    private int httpTimeoutConcurrency = 3;
    private int httpTimeoutThreads = 3;
    private int taskNotificationThreads = 5;
    private int taskYieldThreads = 3;
    private BigDecimal levelTimeMultiplier = new BigDecimal(2.0);
    private boolean legacyLifespanCompletionCondition;
    private TaskPriorityTracking taskPriorityTracking = TaskPriorityTracking.TASK_FAIR;
    private Duration interruptRunawaySplitsTimeout = new Duration(600.0, TimeUnit.SECONDS);

    @MinDuration(value="1ms")
    @MaxDuration(value="10s")
    @NotNull
    public Duration getStatusRefreshMaxWait() {
        return this.statusRefreshMaxWait;
    }

    @Config(value="task.status-refresh-max-wait")
    public TaskManagerConfig setStatusRefreshMaxWait(Duration statusRefreshMaxWait) {
        this.statusRefreshMaxWait = statusRefreshMaxWait;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="10s")
    @NotNull
    public Duration getInfoUpdateInterval() {
        return this.infoUpdateInterval;
    }

    @Config(value="task.info-update-interval")
    @ConfigDescription(value="Interval between updating task data")
    public TaskManagerConfig setInfoUpdateInterval(Duration infoUpdateInterval) {
        this.infoUpdateInterval = infoUpdateInterval;
        return this;
    }

    @NotNull
    public Duration getInfoRefreshMaxWait() {
        return this.infoRefreshMaxWait;
    }

    @Config(value="experimental.task.info-update-refresh-max-wait")
    @ConfigDescription(value="When this is set to non-zero, task info update request will be a long polling with given maximum update refresh wait time. This is an experimental config to reduce unnecessary task info update.")
    public TaskManagerConfig setInfoRefreshMaxWait(Duration infoRefreshMaxWait) {
        this.infoRefreshMaxWait = infoRefreshMaxWait;
        return this;
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.perOperatorCpuTimerEnabled;
    }

    @LegacyConfig(value={"task.verbose-stats"})
    @Config(value="task.per-operator-cpu-timer-enabled")
    public TaskManagerConfig setPerOperatorCpuTimerEnabled(boolean perOperatorCpuTimerEnabled) {
        this.perOperatorCpuTimerEnabled = perOperatorCpuTimerEnabled;
        return this;
    }

    public boolean isTaskCpuTimerEnabled() {
        return this.taskCpuTimerEnabled;
    }

    @Config(value="task.cpu-timer-enabled")
    public TaskManagerConfig setTaskCpuTimerEnabled(boolean taskCpuTimerEnabled) {
        this.taskCpuTimerEnabled = taskCpuTimerEnabled;
        return this;
    }

    public boolean isStatisticsCpuTimerEnabled() {
        return this.statisticsCpuTimerEnabled;
    }

    @Config(value="task.statistics-cpu-timer-enabled")
    public TaskManagerConfig setStatisticsCpuTimerEnabled(boolean statisticsCpuTimerEnabled) {
        this.statisticsCpuTimerEnabled = statisticsCpuTimerEnabled;
        return this;
    }

    public boolean isPerOperatorAllocationTrackingEnabled() {
        return this.perOperatorAllocationTrackingEnabled;
    }

    @Config(value="task.per-operator-allocation-tracking-enabled")
    public TaskManagerConfig setPerOperatorAllocationTrackingEnabled(boolean perOperatorAllocationTrackingEnabled) {
        this.perOperatorAllocationTrackingEnabled = perOperatorAllocationTrackingEnabled;
        return this;
    }

    public boolean isTaskAllocationTrackingEnabled() {
        return this.taskAllocationTrackingEnabled;
    }

    @Config(value="task.allocation-tracking-enabled")
    public TaskManagerConfig setTaskAllocationTrackingEnabled(boolean taskAllocationTrackingEnabled) {
        this.taskAllocationTrackingEnabled = taskAllocationTrackingEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxPartialAggregationMemoryUsage() {
        return this.maxPartialAggregationMemoryUsage;
    }

    @Config(value="task.max-partial-aggregation-memory")
    public TaskManagerConfig setMaxPartialAggregationMemoryUsage(DataSize maxPartialAggregationMemoryUsage) {
        this.maxPartialAggregationMemoryUsage = maxPartialAggregationMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getMaxLocalExchangeBufferSize() {
        return this.maxLocalExchangeBufferSize;
    }

    @Config(value="task.max-local-exchange-buffer-size")
    public TaskManagerConfig setMaxLocalExchangeBufferSize(DataSize size) {
        this.maxLocalExchangeBufferSize = size;
        return this;
    }

    @NotNull
    public DataSize getMaxIndexMemoryUsage() {
        return this.maxIndexMemoryUsage;
    }

    @Config(value="task.max-index-memory")
    public TaskManagerConfig setMaxIndexMemoryUsage(DataSize maxIndexMemoryUsage) {
        this.maxIndexMemoryUsage = maxIndexMemoryUsage;
        return this;
    }

    @NotNull
    public boolean isShareIndexLoading() {
        return this.shareIndexLoading;
    }

    @Config(value="task.share-index-loading")
    public TaskManagerConfig setShareIndexLoading(boolean shareIndexLoading) {
        this.shareIndexLoading = shareIndexLoading;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) BigDecimal getLevelTimeMultiplier() {
        return this.levelTimeMultiplier;
    }

    @Config(value="task.level-time-multiplier")
    @ConfigDescription(value="Factor that determines the target scheduled time for a level relative to the next")
    public TaskManagerConfig setLevelTimeMultiplier(BigDecimal levelTimeMultiplier) {
        this.levelTimeMultiplier = levelTimeMultiplier;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxWorkerThreads() {
        return this.maxWorkerThreads;
    }

    @LegacyConfig(value={"task.shard.max-threads"})
    @Config(value="task.max-worker-threads")
    public TaskManagerConfig setMaxWorkerThreads(int maxWorkerThreads) {
        this.maxWorkerThreads = maxWorkerThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getInitialSplitsPerNode() {
        if (this.initialSplitsPerNode == null) {
            return this.maxWorkerThreads;
        }
        return this.initialSplitsPerNode;
    }

    @Config(value="task.initial-splits-per-node")
    public TaskManagerConfig setInitialSplitsPerNode(int initialSplitsPerNode) {
        this.initialSplitsPerNode = initialSplitsPerNode;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getSplitConcurrencyAdjustmentInterval() {
        return this.splitConcurrencyAdjustmentInterval;
    }

    @Config(value="task.split-concurrency-adjustment-interval")
    public TaskManagerConfig setSplitConcurrencyAdjustmentInterval(Duration splitConcurrencyAdjustmentInterval) {
        this.splitConcurrencyAdjustmentInterval = splitConcurrencyAdjustmentInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinDrivers() {
        if (this.minDrivers == null) {
            return 2 * this.maxWorkerThreads;
        }
        return this.minDrivers;
    }

    @Config(value="task.min-drivers")
    public TaskManagerConfig setMinDrivers(int minDrivers) {
        this.minDrivers = minDrivers;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxDriversPerTask() {
        return this.maxDriversPerTask;
    }

    @Config(value="task.max-drivers-per-task")
    @ConfigDescription(value="Maximum number of drivers a task can run")
    public TaskManagerConfig setMaxDriversPerTask(int maxDriversPerTask) {
        this.maxDriversPerTask = maxDriversPerTask;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinDriversPerTask() {
        return this.minDriversPerTask;
    }

    @Config(value="task.min-drivers-per-task")
    @ConfigDescription(value="Minimum number of drivers guaranteed to run per task given there is sufficient work to do")
    public TaskManagerConfig setMinDriversPerTask(int minDriversPerTask) {
        this.minDriversPerTask = minDriversPerTask;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxTasksPerStage() {
        return this.maxTasksPerStage;
    }

    @Config(value="stage.max-tasks-per-stage")
    @ConfigDescription(value="Maximum number of tasks for a non source distributed stage")
    public TaskManagerConfig setMaxTasksPerStage(int maxTasksPerStage) {
        this.maxTasksPerStage = maxTasksPerStage;
        return this;
    }

    @NotNull
    public DataSize getSinkMaxBufferSize() {
        return this.sinkMaxBufferSize;
    }

    @Config(value="sink.max-buffer-size")
    public TaskManagerConfig setSinkMaxBufferSize(DataSize sinkMaxBufferSize) {
        this.sinkMaxBufferSize = sinkMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getMaxPagePartitioningBufferSize() {
        return this.maxPagePartitioningBufferSize;
    }

    @Config(value="driver.max-page-partitioning-buffer-size")
    public TaskManagerConfig setMaxPagePartitioningBufferSize(DataSize size) {
        this.maxPagePartitioningBufferSize = size;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="task.client.timeout")
    public TaskManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @NotNull
    public Duration getInfoMaxAge() {
        return this.infoMaxAge;
    }

    @Config(value="task.info.max-age")
    public TaskManagerConfig setInfoMaxAge(Duration infoMaxAge) {
        this.infoMaxAge = infoMaxAge;
        return this;
    }

    @Min(value=1L)
    @PowerOfTwo
    public @Min(value=1L) int getWriterCount() {
        return this.writerCount;
    }

    @Config(value="task.writer-count")
    @ConfigDescription(value="Number of writers per task")
    public TaskManagerConfig setWriterCount(int writerCount) {
        this.writerCount = writerCount;
        return this;
    }

    @Min(value=1L)
    @PowerOfTwo
    public @Min(value=1L) Integer getPartitionedWriterCount() {
        return this.partitionedWriterCount;
    }

    @Config(value="task.partitioned-writer-count")
    @ConfigDescription(value="Number of writers per task for partitioned writes. If not set, the number set by task.writer-count will be used")
    public TaskManagerConfig setPartitionedWriterCount(Integer partitionedWriterCount) {
        this.partitionedWriterCount = partitionedWriterCount;
        return this;
    }

    @Min(value=1L)
    @PowerOfTwo
    public @Min(value=1L) int getTaskConcurrency() {
        return this.taskConcurrency;
    }

    @Config(value="task.concurrency")
    @ConfigDescription(value="Default number of local parallel jobs per worker")
    public TaskManagerConfig setTaskConcurrency(int taskConcurrency) {
        this.taskConcurrency = taskConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttpResponseThreads() {
        return this.httpResponseThreads;
    }

    @Config(value="task.http-response-threads")
    public TaskManagerConfig setHttpResponseThreads(int httpResponseThreads) {
        this.httpResponseThreads = httpResponseThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttpTimeoutThreads() {
        return this.httpTimeoutThreads;
    }

    @Config(value="task.http-timeout-threads")
    @ConfigDescription(value="Total number of timeout threads across all timeout thread pools")
    public TaskManagerConfig setHttpTimeoutThreads(int httpTimeoutThreads) {
        this.httpTimeoutThreads = httpTimeoutThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttpTimeoutConcurrency() {
        return this.httpTimeoutConcurrency;
    }

    @Config(value="task.http-timeout-concurrency")
    @ConfigDescription(value="Number of thread pools to handle timeouts. Threads per pool is calculated by http-timeout-threads / http-timeout-concurrency")
    public TaskManagerConfig setHttpTimeoutConcurrency(int httpTimeoutConcurrency) {
        this.httpTimeoutConcurrency = httpTimeoutConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTaskNotificationThreads() {
        return this.taskNotificationThreads;
    }

    @Config(value="task.task-notification-threads")
    @ConfigDescription(value="Number of threads used for internal task event notifications")
    public TaskManagerConfig setTaskNotificationThreads(int taskNotificationThreads) {
        this.taskNotificationThreads = taskNotificationThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTaskYieldThreads() {
        return this.taskYieldThreads;
    }

    @Config(value="task.task-yield-threads")
    @ConfigDescription(value="Number of threads used for setting yield signals")
    public TaskManagerConfig setTaskYieldThreads(int taskYieldThreads) {
        this.taskYieldThreads = taskYieldThreads;
        return this;
    }

    @Deprecated
    public boolean isLegacyLifespanCompletionCondition() {
        return this.legacyLifespanCompletionCondition;
    }

    @Deprecated
    @Config(value="task.legacy-lifespan-completion-condition")
    public TaskManagerConfig setLegacyLifespanCompletionCondition(boolean legacyLifespanCompletionCondition) {
        this.legacyLifespanCompletionCondition = legacyLifespanCompletionCondition;
        return this;
    }

    @NotNull
    public TaskPriorityTracking getTaskPriorityTracking() {
        return this.taskPriorityTracking;
    }

    @Config(value="task.task-priority-tracking")
    public TaskManagerConfig setTaskPriorityTracking(TaskPriorityTracking taskPriorityTracking) {
        this.taskPriorityTracking = taskPriorityTracking;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getInterruptRunawaySplitsTimeout() {
        return this.interruptRunawaySplitsTimeout;
    }

    @Config(value="task.interrupt-runaway-splits-timeout")
    @ConfigDescription(value="Interrupt runaway split threads after this timeout if the task is stuck in certain allow listed places")
    public TaskManagerConfig setInterruptRunawaySplitsTimeout(Duration interruptRunawaySplitsTimeout) {
        this.interruptRunawaySplitsTimeout = interruptRunawaySplitsTimeout;
        return this;
    }

    public static enum TaskPriorityTracking {
        TASK_FAIR,
        QUERY_FAIR;

    }
}

