/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.SqlQueryExecution;
import com.facebook.presto.execution.resourceGroups.FifoQueue;
import com.facebook.presto.execution.resourceGroups.IndexedPriorityQueue;
import com.facebook.presto.execution.resourceGroups.QueryQueueFullException;
import com.facebook.presto.execution.resourceGroups.Queue;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.execution.resourceGroups.StochasticPriorityQueue;
import com.facebook.presto.execution.resourceGroups.TieredQueue;
import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.facebook.presto.execution.resourceGroups.WeightedFairQueue;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.spi.resourceGroups.ResourceGroupState;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class InternalResourceGroup
implements ResourceGroup {
    public static final int DEFAULT_WEIGHT = 1;
    private final InternalResourceGroup root;
    private final Optional<InternalResourceGroup> parent;
    private final ResourceGroupId id;
    private final BiConsumer<InternalResourceGroup, Boolean> jmxExportListener;
    private final Executor executor;
    private final boolean staticResourceGroup;
    private final Function<ResourceGroupId, Optional<ResourceGroupRuntimeInfo>> additionalRuntimeInfo;
    private final Predicate<InternalResourceGroup> shouldWaitForResourceManagerUpdate;
    private final InternalNodeManager nodeManager;
    @GuardedBy(value="root")
    private long softMemoryLimitBytes = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private int softConcurrencyLimit;
    @GuardedBy(value="root")
    private int workersPerQueryLimit;
    @GuardedBy(value="root")
    private int hardConcurrencyLimit;
    @GuardedBy(value="root")
    private int maxQueuedQueries;
    @GuardedBy(value="root")
    private long softCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long hardCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long cpuQuotaGenerationMillisPerSecond = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private int schedulingWeight = 1;
    @GuardedBy(value="root")
    private SchedulingPolicy schedulingPolicy = SchedulingPolicy.FAIR;
    @GuardedBy(value="root")
    private boolean jmxExport;
    @GuardedBy(value="root")
    private ResourceGroupQueryLimits perQueryLimits = ResourceGroupQueryLimits.NO_LIMITS;
    @GuardedBy(value="root")
    private final Map<String, InternalResourceGroup> subGroups = new HashMap<String, InternalResourceGroup>();
    @GuardedBy(value="root")
    private Queue<InternalResourceGroup> eligibleSubGroups = new FifoQueue<InternalResourceGroup>();
    @GuardedBy(value="root")
    private final Set<InternalResourceGroup> dirtySubGroups = new HashSet<InternalResourceGroup>();
    @GuardedBy(value="root")
    private TieredQueue<ManagedQueryExecution> queuedQueries = new TieredQueue(FifoQueue::new);
    @GuardedBy(value="root")
    private final Set<ManagedQueryExecution> runningQueries = new HashSet<ManagedQueryExecution>();
    @GuardedBy(value="root")
    private int descendantRunningQueries;
    @GuardedBy(value="root")
    private int descendantQueuedQueries;
    @GuardedBy(value="root")
    private long cachedMemoryUsageBytes;
    @GuardedBy(value="root")
    private long cpuUsageMillis;
    @GuardedBy(value="root")
    private long lastStartMillis;
    @GuardedBy(value="root")
    private final CounterStat timeBetweenStartsSec = new CounterStat();
    @GuardedBy(value="root")
    private AtomicLong lastRunningQueryStartTime = new AtomicLong(System.currentTimeMillis());
    @GuardedBy(value="root")
    private AtomicBoolean isDirty = new AtomicBoolean();

    protected InternalResourceGroup(Optional<InternalResourceGroup> parent, String name, BiConsumer<InternalResourceGroup, Boolean> jmxExportListener, Executor executor, boolean staticResourceGroup, Function<ResourceGroupId, Optional<ResourceGroupRuntimeInfo>> additionalRuntimeInfo, Predicate<InternalResourceGroup> shouldWaitForResourceManagerUpdate, InternalNodeManager nodeManager) {
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.jmxExportListener = Objects.requireNonNull(jmxExportListener, "jmxExportListener is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "node manager is null");
        Objects.requireNonNull(name, "name is null");
        if (parent.isPresent()) {
            this.id = new ResourceGroupId(parent.get().id, name);
            this.root = parent.get().root;
        } else {
            this.id = new ResourceGroupId(name);
            this.root = this;
        }
        this.staticResourceGroup = staticResourceGroup;
        this.additionalRuntimeInfo = Objects.requireNonNull(additionalRuntimeInfo, "additionalRuntimeInfo is null");
        this.shouldWaitForResourceManagerUpdate = Objects.requireNonNull(shouldWaitForResourceManagerUpdate, "shouldWaitForResourceManagerUpdate is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupInfo getResourceGroupInfo(boolean includeQueryInfo, boolean summarizeSubgroups, boolean includeStaticSubgroupsOnly) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new ResourceGroupInfo(this.id, this.getState(), this.schedulingPolicy, this.schedulingWeight, DataSize.succinctBytes((long)this.softMemoryLimitBytes), this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.cachedMemoryUsageBytes), this.getQueuedQueries(), this.getRunningQueries(), this.eligibleSubGroups.size(), (List)this.subGroups.values().stream().filter(group -> group.getRunningQueries() + group.getQueuedQueries() > 0).filter(group -> !includeStaticSubgroupsOnly || group.isStaticResourceGroup()).map(group -> summarizeSubgroups ? group.getSummaryInfo() : group.getResourceGroupInfo(includeQueryInfo, false, includeStaticSubgroupsOnly)).collect(ImmutableList.toImmutableList()), includeQueryInfo ? this.getAggregatedRunningQueriesInfo() : null, this.workersPerQueryLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupInfo getInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new ResourceGroupInfo(this.id, this.getState(), this.schedulingPolicy, this.schedulingWeight, DataSize.succinctBytes((long)this.softMemoryLimitBytes), this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.cachedMemoryUsageBytes), this.getQueuedQueries(), this.getRunningQueries(), this.eligibleSubGroups.size(), (List)this.subGroups.values().stream().filter(group -> group.getRunningQueries() + group.getQueuedQueries() > 0).map(InternalResourceGroup::getSummaryInfo).collect(ImmutableList.toImmutableList()), null, this.workersPerQueryLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceGroupInfo getSummaryInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new ResourceGroupInfo(this.id, this.getState(), this.schedulingPolicy, this.schedulingWeight, DataSize.succinctBytes((long)this.softMemoryLimitBytes), this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.cachedMemoryUsageBytes), this.getQueuedQueries(), this.getRunningQueries(), this.eligibleSubGroups.size(), null, null, this.workersPerQueryLimit);
        }
    }

    boolean isStaticResourceGroup() {
        return this.staticResourceGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceGroupState getState() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.canRunMore()) {
                return ResourceGroupState.CAN_RUN;
            }
            if (this.canQueueMore()) {
                return ResourceGroupState.CAN_QUEUE;
            }
            return ResourceGroupState.FULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryStateInfo> getAggregatedRunningQueriesInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.subGroups.isEmpty()) {
                return (List)this.runningQueries.stream().map(ManagedQueryExecution::getBasicQueryInfo).map(queryInfo -> QueryStateInfo.createQueryStateInfo(queryInfo)).collect(ImmutableList.toImmutableList());
            }
            return (List)this.subGroups.values().stream().map(InternalResourceGroup::getAggregatedRunningQueriesInfo).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceGroupInfo> getPathToRoot() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            ImmutableList.Builder builder = ImmutableList.builder();
            InternalResourceGroup group = this;
            while (group != null) {
                builder.add((Object)group.getInfo());
                group = group.parent.orElse(null);
            }
            return builder.build();
        }
    }

    public ResourceGroupId getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getRunningQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAggregatedRunningQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            int aggregatedRunningQueries = this.runningQueries.size() + this.descendantRunningQueries;
            Optional<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo = this.getAdditionalRuntimeInfo();
            if (resourceGroupRuntimeInfo.isPresent()) {
                aggregatedRunningQueries += resourceGroupRuntimeInfo.get().getRunningQueries() + resourceGroupRuntimeInfo.get().getDescendantRunningQueries();
            }
            return aggregatedRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.queuedQueries.size() + this.descendantQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getWaitingQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.subGroups.isEmpty()) {
                return this.queuedQueries.size();
            }
            int waitingQueuedQueries = 0;
            for (InternalResourceGroup subGroup : this.subGroups.values()) {
                if (!subGroup.canRunMore()) continue;
                waitingQueuedQueries += Math.min(subGroup.getQueuedQueries(), subGroup.getHardConcurrencyLimit() - subGroup.getRunningQueries());
            }
            return waitingQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSize getSoftMemoryLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new DataSize((double)this.softMemoryLimitBytes, DataSize.Unit.BYTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftMemoryLimit(DataSize limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.softMemoryLimitBytes = limit.toBytes();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getSoftCpuLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new Duration((double)this.softCpuLimitMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftCpuLimit(Duration limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (limit.toMillis() > this.hardCpuLimitMillis) {
                this.setHardCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.softCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getHardCpuLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new Duration((double)this.hardCpuLimitMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHardCpuLimit(Duration limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (limit.toMillis() < this.softCpuLimitMillis) {
                this.setSoftCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.hardCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuQuotaGenerationMillisPerSecond() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.cpuQuotaGenerationMillisPerSecond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCpuQuotaGenerationMillisPerSecond(long rate) {
        Preconditions.checkArgument((rate > 0L ? 1 : 0) != 0, (Object)"Cpu quota generation must be positive");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.cpuQuotaGenerationMillisPerSecond = rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkersPerQueryLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.workersPerQueryLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkersPerQueryLimit(int workersPerQueryLimit) {
        Preconditions.checkArgument((workersPerQueryLimit >= 0 ? 1 : 0) != 0, (Object)"workersPerQueryLimit is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.workersPerQueryLimit = workersPerQueryLimit;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSoftConcurrencyLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.softConcurrencyLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftConcurrencyLimit(int softConcurrencyLimit) {
        Preconditions.checkArgument((softConcurrencyLimit >= 0 ? 1 : 0) != 0, (Object)"softConcurrencyLimit is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.softConcurrencyLimit = softConcurrencyLimit;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getHardConcurrencyLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.hardConcurrencyLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public void setHardConcurrencyLimit(int hardConcurrencyLimit) {
        Preconditions.checkArgument((hardConcurrencyLimit >= 0 ? 1 : 0) != 0, (Object)"hardConcurrencyLimit is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.hardConcurrencyLimit = hardConcurrencyLimit;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getMaxQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public void setMaxQueuedQueries(int maxQueuedQueries) {
        Preconditions.checkArgument((maxQueuedQueries >= 0 ? 1 : 0) != 0, (Object)"maxQueuedQueries is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.maxQueuedQueries = maxQueuedQueries;
        }
    }

    @Managed
    @Nested
    public CounterStat getTimeBetweenStartsSec() {
        return this.timeBetweenStartsSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSchedulingWeight() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.schedulingWeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingWeight(int weight) {
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"weight must be positive");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.schedulingWeight = weight;
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SchedulingPolicy.WEIGHTED && this.parent.get().eligibleSubGroups.contains(this)) {
                this.parent.get().addOrUpdateSubGroup(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulingPolicy getSchedulingPolicy() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.schedulingPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingPolicy(SchedulingPolicy policy) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            TieredQueue<ManagedQueryExecution> queryQueue;
            FifoQueue<InternalResourceGroup> queue;
            if (policy == this.schedulingPolicy) {
                return;
            }
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SchedulingPolicy.QUERY_PRIORITY) {
                Preconditions.checkArgument((policy == SchedulingPolicy.QUERY_PRIORITY ? 1 : 0) != 0, (String)"Parent of %s uses query priority scheduling, so %s must also", (Object)this.id, (Object)this.id);
            }
            switch (policy) {
                case FAIR: {
                    queue = new FifoQueue();
                    queryQueue = new TieredQueue<ManagedQueryExecution>(FifoQueue::new);
                    break;
                }
                case WEIGHTED: {
                    queue = new StochasticPriorityQueue();
                    queryQueue = new TieredQueue(StochasticPriorityQueue::new);
                    break;
                }
                case WEIGHTED_FAIR: {
                    queue = new WeightedFairQueue();
                    queryQueue = new TieredQueue(IndexedPriorityQueue::new);
                    break;
                }
                case QUERY_PRIORITY: {
                    for (InternalResourceGroup group : this.subGroups.values()) {
                        group.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
                    }
                    queue = new IndexedPriorityQueue();
                    queryQueue = new TieredQueue(IndexedPriorityQueue::new);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported scheduling policy: " + policy);
                }
            }
            this.schedulingPolicy = policy;
            while (!this.eligibleSubGroups.isEmpty()) {
                InternalResourceGroup group = this.eligibleSubGroups.poll();
                this.addOrUpdateSubGroup(queue, group);
            }
            this.eligibleSubGroups = queue;
            while (!this.queuedQueries.isEmpty()) {
                ManagedQueryExecution query = this.queuedQueries.poll();
                queryQueue.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            }
            this.queuedQueries = queryQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJmxExport() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.jmxExport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJmxExport(boolean export) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.jmxExport = export;
        }
        this.jmxExportListener.accept(this, export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPerQueryLimits(ResourceGroupQueryLimits perQueryLimits) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.perQueryLimits = perQueryLimits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupQueryLimits getPerQueryLimits() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.perQueryLimits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalResourceGroup getOrCreateSubGroup(String name, boolean staticSegment) {
        Objects.requireNonNull(name, "name is null");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkArgument((this.runningQueries.isEmpty() && this.queuedQueries.isEmpty() ? 1 : 0) != 0, (String)"Cannot add sub group to %s while queries are running", (Object)this.id);
            if (this.subGroups.containsKey(name)) {
                return this.subGroups.get(name);
            }
            int subGroupSegmentIndex = this.id.getSegments().size();
            InternalResourceGroup subGroup = new InternalResourceGroup(Optional.of(this), name, this.jmxExportListener, this.executor, this.staticResourceGroup && staticSegment, this.additionalRuntimeInfo, this.shouldWaitForResourceManagerUpdate, this.nodeManager);
            if (this.schedulingPolicy == SchedulingPolicy.QUERY_PRIORITY) {
                subGroup.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
            }
            this.subGroups.put(name, subGroup);
            return subGroup;
        }
    }

    public int getRunningTaskCount() {
        if (this.subGroups().isEmpty()) {
            return this.runningQueries.stream().filter(SqlQueryExecution.class::isInstance).mapToInt(query -> ((SqlQueryExecution)((Object)query)).getRunningTaskCount()).sum();
        }
        int taskCount = 0;
        for (InternalResourceGroup subGroup : this.subGroups()) {
            taskCount += subGroup.getRunningTaskCount();
        }
        return taskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.isDirty.set(true);
            this.dirtySubGroups.addAll(this.subGroups());
            this.subGroups().forEach(InternalResourceGroup::setDirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ManagedQueryExecution query) {
        boolean isQueryQueueFull = false;
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.subGroups.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_RESOURCE_GROUP, String.format("Cannot add queries to %s. It is not a leaf group.", this.id));
            }
            InternalResourceGroup group = this;
            boolean canQueue = true;
            boolean canRun = true;
            while (true) {
                canQueue &= group.canQueueMore();
                canRun &= group.canRunMore();
                if (!group.parent.isPresent()) break;
                group = group.parent.get();
            }
            if (!canQueue && !canRun) {
                isQueryQueueFull = true;
            } else {
                query.setResourceGroupQueryLimits(this.perQueryLimits);
                if (canRun && this.queuedQueries.isEmpty()) {
                    this.startInBackground(query);
                } else {
                    this.enqueueQuery(query);
                }
                query.addStateChangeListener(state -> {
                    if (state.isDone()) {
                        this.queryFinished(query);
                    }
                });
            }
        }
        if (isQueryQueueFull) {
            query.fail((Throwable)((Object)new QueryQueueFullException(this.id)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueQuery(ManagedQueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to enqueue a query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            int priority = SystemSessionProperties.getQueryPriority(query.getSession());
            if (query.isRetry()) {
                this.queuedQueries.prioritize(query, priority);
            } else {
                this.queuedQueries.addOrUpdate(query, priority);
            }
            InternalResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantQueuedQueries;
                group = group.parent.get();
            }
            this.updateEligibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEligibility() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to update eligibility");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.parent.isPresent()) {
                return;
            }
            if (this.isEligibleToStartNext()) {
                this.parent.get().addOrUpdateSubGroup(this);
            } else if (this.queuedQueries.isEmpty() && this.eligibleSubGroups.isEmpty()) {
                this.parent.get().eligibleSubGroups.remove(this);
                this.lastStartMillis = 0L;
            }
            this.parent.get().updateEligibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInBackground(ManagedQueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to start a query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.runningQueries.add(query);
            InternalResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantRunningQueries;
                group.parent.get().dirtySubGroups.add(group);
                group = group.parent.get();
            }
            this.updateEligibility();
            this.executor.execute(query::startWaitingForResources);
            group = this;
            long lastRunningQueryStartTimeMillis = System.currentTimeMillis();
            this.lastRunningQueryStartTime.set(lastRunningQueryStartTimeMillis);
            while (group.parent.isPresent()) {
                group.parent.get().lastRunningQueryStartTime.set(lastRunningQueryStartTimeMillis);
                group = group.parent.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryFinished(ManagedQueryExecution query) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            InternalResourceGroup group;
            if (!this.runningQueries.contains(query) && !this.queuedQueries.contains(query)) {
                return;
            }
            if (!query.getErrorCode().isPresent() || query.getErrorCode().get().getType() == ErrorType.USER_ERROR) {
                group = this;
                while (group != null) {
                    group.cpuUsageMillis = LongMath.saturatedAdd((long)group.cpuUsageMillis, (long)query.getTotalCpuTime().toMillis());
                    group = group.parent.orElse(null);
                }
            }
            if (this.runningQueries.contains(query)) {
                this.runningQueries.remove(query);
                group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantRunningQueries;
                    group = group.parent.get();
                }
            } else {
                this.queuedQueries.remove(query);
                group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantQueuedQueries;
                    group = group.parent.get();
                }
            }
            this.updateEligibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRefreshStats() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to refresh stats");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.subGroups.isEmpty()) {
                this.cachedMemoryUsageBytes = 0L;
                for (ManagedQueryExecution query : this.runningQueries) {
                    this.cachedMemoryUsageBytes += query.getUserMemoryReservation().toBytes();
                }
                Optional<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo = this.getAdditionalRuntimeInfo();
                resourceGroupRuntimeInfo.ifPresent(groupRuntimeInfo -> this.cachedMemoryUsageBytes += groupRuntimeInfo.getMemoryUsageBytes());
            } else {
                Iterator<InternalResourceGroup> iterator = this.dirtySubGroups.iterator();
                while (iterator.hasNext()) {
                    InternalResourceGroup subGroup = iterator.next();
                    long oldMemoryUsageBytes = subGroup.cachedMemoryUsageBytes;
                    this.cachedMemoryUsageBytes -= oldMemoryUsageBytes;
                    subGroup.internalRefreshStats();
                    this.cachedMemoryUsageBytes += subGroup.cachedMemoryUsageBytes;
                    if (!subGroup.isDirty()) {
                        iterator.remove();
                    }
                    if (oldMemoryUsageBytes == subGroup.cachedMemoryUsageBytes && !subGroup.isDirty.get()) continue;
                    subGroup.updateEligibility();
                    subGroup.isDirty.set(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalGenerateCpuQuota(long elapsedSeconds) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to generate cpu quota");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            long newQuota = LongMath.saturatedMultiply((long)elapsedSeconds, (long)this.cpuQuotaGenerationMillisPerSecond);
            this.cpuUsageMillis = LongMath.saturatedSubtract((long)this.cpuUsageMillis, (long)newQuota);
            if (this.cpuUsageMillis < 0L || this.cpuUsageMillis == Long.MAX_VALUE) {
                this.cpuUsageMillis = 0L;
            }
            for (InternalResourceGroup group : this.subGroups.values()) {
                group.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to find next query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            ManagedQueryExecution query = this.queuedQueries.poll();
            if (query != null) {
                this.startInBackground(query);
                return true;
            }
            InternalResourceGroup subGroup = this.eligibleSubGroups.poll();
            if (subGroup == null) {
                return false;
            }
            boolean started = subGroup.internalStartNext();
            if (started) {
                long currentTime = System.currentTimeMillis();
                if (this.lastStartMillis != 0L) {
                    this.timeBetweenStartsSec.update(Math.max(0L, (currentTime - this.lastStartMillis) / 1000L));
                }
                this.lastStartMillis = currentTime;
                --this.descendantQueuedQueries;
                if (subGroup.isEligibleToStartNext()) {
                    this.addOrUpdateSubGroup(subGroup);
                }
            } else {
                this.addOrUpdateSubGroup(subGroup);
            }
            return started;
        }
    }

    private void addOrUpdateSubGroup(Queue<InternalResourceGroup> queue, InternalResourceGroup group) {
        if (this.schedulingPolicy == SchedulingPolicy.WEIGHTED_FAIR) {
            ((WeightedFairQueue)queue).addOrUpdate(group, new WeightedFairQueue.Usage(group.getSchedulingWeight(), group.getAggregatedRunningQueries()));
        } else {
            ((UpdateablePriorityQueue)queue).addOrUpdate(group, InternalResourceGroup.getSubGroupSchedulingPriority(this.schedulingPolicy, group));
        }
    }

    private void addOrUpdateSubGroup(InternalResourceGroup group) {
        this.addOrUpdateSubGroup(this.eligibleSubGroups, group);
    }

    private static long getSubGroupSchedulingPriority(SchedulingPolicy policy, InternalResourceGroup group) {
        if (policy == SchedulingPolicy.QUERY_PRIORITY) {
            return group.getHighestQueryPriority();
        }
        return group.computeSchedulingWeight();
    }

    private long computeSchedulingWeight() {
        if (this.getAggregatedRunningQueries() >= this.softConcurrencyLimit) {
            return this.schedulingWeight;
        }
        return Integer.MAX_VALUE * (long)this.schedulingWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries > 0 || this.isDirty.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEligibleToStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            return !this.queuedQueries.isEmpty() || !this.eligibleSubGroups.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHighestQueryPriority() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkState((boolean)(this.queuedQueries.getLowPriorityQueue() instanceof IndexedPriorityQueue), (Object)"Queued queries not ordered");
            if (this.queuedQueries.isEmpty()) {
                return 0;
            }
            return SystemSessionProperties.getQueryPriority(this.queuedQueries.peek().getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canQueueMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Optional<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo = this.getAdditionalRuntimeInfo();
            if (resourceGroupRuntimeInfo.isPresent()) {
                return this.descendantQueuedQueries + this.queuedQueries.size() + resourceGroupRuntimeInfo.get().getQueuedQueries() + resourceGroupRuntimeInfo.get().getDescendantQueuedQueries() < this.maxQueuedQueries;
            }
            return this.descendantQueuedQueries + this.queuedQueries.size() < this.maxQueuedQueries;
        }
    }

    private int getActiveWorkerCount() {
        AllNodes allNodes = this.nodeManager.getAllNodes();
        Sets.SetView activeWorkers = Sets.difference((Set)Sets.difference(allNodes.getActiveNodes(), allNodes.getActiveResourceManagers()), allNodes.getActiveCatalogServers());
        return activeWorkers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRunMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.cpuUsageMillis >= this.hardCpuLimitMillis) {
                return false;
            }
            if (this.shouldWaitForResourceManagerUpdate()) {
                return false;
            }
            if (((RootInternalResourceGroup)this.root).isTaskLimitExceeded()) {
                return false;
            }
            int hardConcurrencyLimit = this.getHardConcurrencyLimitBasedOnCpuUsage();
            int totalRunningQueries = this.runningQueries.size() + this.descendantRunningQueries;
            Optional<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo = this.getAdditionalRuntimeInfo();
            if (resourceGroupRuntimeInfo.isPresent()) {
                totalRunningQueries += resourceGroupRuntimeInfo.get().getRunningQueries() + resourceGroupRuntimeInfo.get().getDescendantRunningQueries();
            }
            int activeWorkerCount = this.getActiveWorkerCount();
            return totalRunningQueries < hardConcurrencyLimit && this.cachedMemoryUsageBytes <= this.softMemoryLimitBytes && totalRunningQueries * this.workersPerQueryLimit <= activeWorkerCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getHardConcurrencyLimitBasedOnCpuUsage() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            int hardConcurrencyLimit = this.hardConcurrencyLimit;
            if (this.cpuUsageMillis >= this.softCpuLimitMillis) {
                double penalty = (double)(this.cpuUsageMillis - this.softCpuLimitMillis) / (double)(this.hardCpuLimitMillis - this.softCpuLimitMillis);
                hardConcurrencyLimit = (int)Math.floor((double)hardConcurrencyLimit * (1.0 - penalty));
                hardConcurrencyLimit = Math.min(this.hardConcurrencyLimit - 1, hardConcurrencyLimit);
                hardConcurrencyLimit = Math.max(1, hardConcurrencyLimit);
            }
            return hardConcurrencyLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InternalResourceGroup> subGroups() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.subGroups.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastRunningQueryStartTime() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.lastRunningQueryStartTime.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldWaitForResourceManagerUpdate() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.shouldWaitForResourceManagerUpdate.test(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ResourceGroupRuntimeInfo> getAdditionalRuntimeInfo() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.additionalRuntimeInfo.apply(this.getId());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalResourceGroup)) {
            return false;
        }
        InternalResourceGroup that = (InternalResourceGroup)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @ThreadSafe
    public static final class RootInternalResourceGroup
    extends InternalResourceGroup {
        private AtomicBoolean taskLimitExceeded = new AtomicBoolean();

        public RootInternalResourceGroup(String name, BiConsumer<InternalResourceGroup, Boolean> jmxExportListener, Executor executor, Function<ResourceGroupId, Optional<ResourceGroupRuntimeInfo>> additionalRuntimeInfo, Predicate<InternalResourceGroup> shouldWaitForResourceManagerUpdate, InternalNodeManager nodeManager) {
            super(Optional.empty(), name, jmxExportListener, executor, true, additionalRuntimeInfo, shouldWaitForResourceManagerUpdate, nodeManager);
        }

        public synchronized void processQueuedQueries() {
            this.internalRefreshStats();
            while (this.internalStartNext()) {
            }
        }

        public synchronized void generateCpuQuota(long elapsedSeconds) {
            if (elapsedSeconds > 0L) {
                this.internalGenerateCpuQuota(elapsedSeconds);
            }
        }

        public void setTaskLimitExceeded(boolean exceeded) {
            this.taskLimitExceeded.set(exceeded);
        }

        private boolean isTaskLimitExceeded() {
            return this.taskLimitExceeded.get();
        }
    }
}

