/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionResult;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureBase;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.metadata.BuiltInFunctionHandle;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionInvokerProvider;
import com.facebook.presto.metadata.FunctionSignatureMatcher;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.SessionFunctionHandle;
import com.facebook.presto.metadata.SessionFunctionUtils;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerContext;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeCoercer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class FunctionAndTypeManager
implements FunctionMetadataManager,
TypeManager {
    private final TransactionManager transactionManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BuiltInTypeAndFunctionNamespaceManager builtInTypeAndFunctionNamespaceManager;
    private final FunctionInvokerProvider functionInvokerProvider;
    private final Map<String, FunctionNamespaceManagerFactory> functionNamespaceManagerFactories = new ConcurrentHashMap<String, FunctionNamespaceManagerFactory>();
    private final HandleResolver handleResolver;
    private final Map<String, FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManagers = new ConcurrentHashMap<String, FunctionNamespaceManager<? extends SqlFunction>>();
    private final FunctionSignatureMatcher functionSignatureMatcher;
    private final TypeCoercer typeCoercer;
    private final LoadingCache<FunctionResolutionCacheKey, FunctionHandle> functionCache;
    private final CacheStatsMBean cacheStatsMBean;

    @Inject
    public FunctionAndTypeManager(TransactionManager transactionManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig, HandleResolver handleResolver, Set<Type> types) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.builtInTypeAndFunctionNamespaceManager = new BuiltInTypeAndFunctionNamespaceManager(blockEncodingSerde, featuresConfig, types, this);
        this.functionNamespaceManagers.put(BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE.getCatalogName(), this.builtInTypeAndFunctionNamespaceManager);
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        transactionManager.registerFunctionNamespaceManager(BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE.getCatalogName(), this.builtInTypeAndFunctionNamespaceManager);
        this.functionCache = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> this.resolveBuiltInFunction(((FunctionResolutionCacheKey)key).functionName, TypeSignatureProvider.fromTypeSignatures((List)((FunctionResolutionCacheKey)key).parameterTypes))));
        this.cacheStatsMBean = new CacheStatsMBean(this.functionCache);
        this.functionSignatureMatcher = new FunctionSignatureMatcher(this);
        this.typeCoercer = new TypeCoercer(featuresConfig, this);
    }

    public static FunctionAndTypeManager createTestFunctionAndTypeManager() {
        return new FunctionAndTypeManager(InMemoryTransactionManager.createTestTransactionManager(), (BlockEncodingSerde)new BlockEncodingManager(), new FeaturesConfig(), new HandleResolver(), (Set<Type>)ImmutableSet.of());
    }

    public FunctionAndTypeResolver getFunctionAndTypeResolver() {
        return new FunctionAndTypeResolver(){

            public Type getType(TypeSignature signature) {
                return FunctionAndTypeManager.this.getType(signature);
            }

            public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
                return FunctionAndTypeManager.this.getParameterizedType(baseTypeName, typeParameters);
            }

            public boolean canCoerce(Type actualType, Type expectedType) {
                return FunctionAndTypeManager.this.canCoerce(actualType, expectedType);
            }

            public FunctionHandle resolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
                return FunctionAndTypeManager.this.resolveOperator(operatorType, argumentTypes);
            }

            public FunctionHandle lookupFunction(String functionName, List<TypeSignatureProvider> fromTypes) {
                return FunctionAndTypeManager.this.lookupFunction(functionName, fromTypes);
            }

            public FunctionHandle resolveFunction(Optional<Map<SqlFunctionId, SqlInvokedFunction>> sessionFunctions, Optional<TransactionId> transactionId, QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
                return FunctionAndTypeManager.this.resolveFunction(sessionFunctions, transactionId, functionName, parameterTypes);
            }

            public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
                return FunctionAndTypeManager.this.getFunctionMetadata(functionHandle);
            }

            public Collection<SqlFunction> listBuiltInFunctions() {
                return FunctionAndTypeManager.this.listBuiltInFunctions();
            }

            public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
                return FunctionAndTypeManager.this.getCommonSuperType(firstType, secondType);
            }

            public boolean isTypeOnlyCoercion(Type actualType, Type expectedType) {
                return FunctionAndTypeManager.this.isTypeOnlyCoercion(actualType, expectedType);
            }

            public FunctionHandle lookupCast(String castType, Type fromType, Type toType) {
                return FunctionAndTypeManager.this.lookupCast(CastType.valueOf(castType), fromType, toType);
            }
        };
    }

    @Managed
    @Nested
    public CacheStatsMBean getFunctionResolutionCacheStats() {
        return this.cacheStatsMBean;
    }

    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        Objects.requireNonNull(functionNamespaceManagerName, "functionNamespaceManagerName is null");
        FunctionNamespaceManagerFactory factory = this.functionNamespaceManagerFactories.get(functionNamespaceManagerName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"No factory for function namespace manager %s", (Object)functionNamespaceManagerName);
        FunctionNamespaceManager functionNamespaceManager = factory.create(catalogName, properties, new FunctionNamespaceManagerContext((TypeManager)this));
        functionNamespaceManager.setBlockEncodingSerde(this.blockEncodingSerde);
        this.transactionManager.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
        if (this.functionNamespaceManagers.putIfAbsent(catalogName, (FunctionNamespaceManager<? extends SqlFunction>)functionNamespaceManager) != null) {
            throw new IllegalArgumentException(String.format("Function namespace manager is already registered for catalog [%s]", catalogName));
        }
    }

    @VisibleForTesting
    public void addFunctionNamespace(String catalogName, FunctionNamespaceManager functionNamespaceManager) {
        this.transactionManager.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
        if (this.functionNamespaceManagers.putIfAbsent(catalogName, (FunctionNamespaceManager<? extends SqlFunction>)functionNamespaceManager) != null) {
            throw new IllegalArgumentException(String.format("Function namespace manager is already registered for catalog [%s]", catalogName));
        }
    }

    public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        if (functionHandle.getCatalogSchemaName().equals((Object)SessionFunctionHandle.SESSION_NAMESPACE)) {
            return ((SessionFunctionHandle)functionHandle).getFunctionMetadata();
        }
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getCatalogSchemaName());
        return functionNamespaceManager.get().getFunctionMetadata(functionHandle);
    }

    public Type getType(TypeSignature signature) {
        if (signature.getTypeSignatureBase().hasStandardType()) {
            if (signature.isDistinctType()) {
                return this.getDistinctType(((TypeSignatureParameter)signature.getParameters().get(0)).getDistinctTypeInfo());
            }
            Optional<Type> type = this.builtInTypeAndFunctionNamespaceManager.getType(signature.getStandardTypeSignature());
            if (type.isPresent()) {
                if (signature.getTypeSignatureBase().hasTypeName()) {
                    return new TypeWithName(signature.getTypeSignatureBase().getTypeName(), type.get());
                }
                return type.get();
            }
        }
        return this.getUserDefinedType(signature);
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        return this.getType(new TypeSignature(baseTypeName, typeParameters));
    }

    public boolean canCoerce(Type actualType, Type expectedType) {
        return this.typeCoercer.canCoerce(actualType, expectedType);
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public void addFunctionNamespaceFactory(FunctionNamespaceManagerFactory factory) {
        if (this.functionNamespaceManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
        this.handleResolver.addFunctionNamespace(factory.getName(), factory.getHandleResolver());
    }

    public void registerBuiltInFunctions(List<? extends SqlFunction> functions) {
        this.builtInTypeAndFunctionNamespaceManager.registerBuiltInFunctions(functions);
    }

    public List<SqlFunction> listFunctions(Session session, Optional<String> likePattern, Optional<String> escape) {
        ImmutableList.Builder functions = new ImmutableList.Builder();
        if (!SystemSessionProperties.isListBuiltInFunctionsOnly(session)) {
            functions.addAll(SessionFunctionUtils.listFunctions(session.getSessionFunctions()));
            functions.addAll((Iterable)this.functionNamespaceManagers.values().stream().flatMap(manager -> manager.listFunctions(likePattern, escape).stream()).collect(ImmutableList.toImmutableList()));
        } else {
            functions.addAll(this.listBuiltInFunctions());
        }
        return (List)functions.build().stream().filter(function -> function.getVisibility() == SqlFunctionVisibility.PUBLIC || function.getVisibility() == SqlFunctionVisibility.EXPERIMENTAL && SystemSessionProperties.isExperimentalFunctionsEnabled(session)).collect(ImmutableList.toImmutableList());
    }

    public Collection<SqlFunction> listBuiltInFunctions() {
        return this.builtInTypeAndFunctionNamespaceManager.listFunctions(Optional.empty(), Optional.empty());
    }

    public Collection<? extends SqlFunction> getFunctions(Session session, QualifiedObjectName functionName) {
        if (functionName.getCatalogSchemaName().equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE) && SessionFunctionUtils.listFunctionNames(session.getSessionFunctions()).contains(functionName.getObjectName())) {
            return SessionFunctionUtils.getFunctions(session.getSessionFunctions(), functionName);
        }
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName));
        }
        Optional<FunctionNamespaceTransactionHandle> transactionHandle = session.getTransactionId().map(id -> this.transactionManager.getFunctionNamespaceTransaction((TransactionId)id, functionName.getCatalogName()));
        return functionNamespaceManager.get().getFunctions(transactionHandle, functionName);
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(function.getSignature().getName().getCatalogSchemaName());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Cannot create function in function namespace: %s", function.getFunctionId().getFunctionName().getCatalogSchemaName()));
        }
        functionNamespaceManager.get().createFunction(function, replace);
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName));
        }
        functionNamespaceManager.get().alterFunction(functionName, parameterTypes, alterRoutineCharacteristics);
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName());
        if (functionNamespaceManager.isPresent()) {
            functionNamespaceManager.get().dropFunction(functionName, parameterTypes, exists);
        } else if (!exists) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName.getCatalogSchemaName()));
        }
    }

    public static QualifiedObjectName qualifyObjectName(QualifiedName name) {
        if (!name.getPrefix().isPresent()) {
            return QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name.getSuffix());
        }
        if (name.getOriginalParts().size() != 3) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Functions that are not temporary or builtin must be referenced by 'catalog.schema.function_name', found: %s", name));
        }
        return QualifiedObjectName.valueOf((String)((String)name.getParts().get(0)), (String)((String)name.getParts().get(1)), (String)((String)name.getParts().get(2)));
    }

    public FunctionHandle resolveFunction(Optional<Map<SqlFunctionId, SqlInvokedFunction>> sessionFunctions, Optional<TransactionId> transactionId, QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        if (functionName.getCatalogSchemaName().equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE)) {
            Collection<SqlFunction> candidates;
            Optional<Signature> match;
            if (sessionFunctions.isPresent() && (match = this.functionSignatureMatcher.match(candidates = SessionFunctionUtils.getFunctions(sessionFunctions.get(), functionName), parameterTypes, true)).isPresent()) {
                return SessionFunctionUtils.getFunctionHandle(sessionFunctions.get(), match.get());
            }
            if (parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency)) {
                return this.lookupCachedFunction(functionName, parameterTypes);
            }
        }
        return this.resolveFunctionInternal(transactionId, functionName, parameterTypes);
    }

    public void addType(Type type) {
        TypeSignatureBase typeSignatureBase = type.getTypeSignature().getTypeSignatureBase();
        Preconditions.checkArgument((boolean)typeSignatureBase.hasStandardType(), (Object)"Expect standard types");
        this.builtInTypeAndFunctionNamespaceManager.addType(type);
    }

    public void addParametricType(ParametricType parametricType) {
        TypeSignatureBase typeSignatureBase = parametricType.getTypeSignatureBase();
        Preconditions.checkArgument((boolean)typeSignatureBase.hasStandardType(), (Object)"Expect standard types");
        this.builtInTypeAndFunctionNamespaceManager.addParametricType(parametricType);
    }

    @VisibleForTesting
    public void addUserDefinedType(UserDefinedType userDefinedType) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(userDefinedType.getUserDefinedTypeName().getCatalogSchemaName());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for user defined type %", (Object)userDefinedType.getUserDefinedTypeName());
        functionNamespaceManager.get().addUserDefinedType(userDefinedType);
    }

    public List<Type> getTypes() {
        return this.builtInTypeAndFunctionNamespaceManager.getTypes();
    }

    public Collection<ParametricType> getParametricTypes() {
        return ImmutableList.copyOf(this.builtInTypeAndFunctionNamespaceManager.getParametricTypes());
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        return this.typeCoercer.getCommonSuperType(firstType, secondType);
    }

    public boolean isTypeOnlyCoercion(Type actualType, Type expectedType) {
        return this.typeCoercer.isTypeOnlyCoercion(actualType, expectedType);
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        return this.typeCoercer.coerceTypeBase(sourceType, resultTypeBase);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        if (functionHandle.getCatalogSchemaName().equals((Object)SessionFunctionHandle.SESSION_NAMESPACE)) {
            return ((SessionFunctionHandle)functionHandle).getScalarFunctionImplementation();
        }
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getCatalogSchemaName());
        return functionNamespaceManager.get().getScalarFunctionImplementation(functionHandle);
    }

    public AggregationFunctionImplementation getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getCatalogSchemaName());
        return functionNamespaceManager.get().getAggregateFunctionImplementation(functionHandle, (TypeManager)this);
    }

    public CompletableFuture<SqlFunctionResult> executeFunction(String source, FunctionHandle functionHandle, Page inputPage, List<Integer> channels) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkState((boolean)functionNamespaceManager.isPresent(), (Object)String.format("FunctionHandle %s should have a serving function namespace", functionHandle));
        return functionNamespaceManager.get().executeFunction(source, functionHandle, inputPage, channels, (TypeManager)this);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInTypeAndFunctionNamespaceManager.getWindowFunctionImplementation(functionHandle);
    }

    public JavaAggregationFunctionImplementation getJavaAggregateFunctionImplementation(FunctionHandle functionHandle) {
        AggregationFunctionImplementation implementation = this.getAggregateFunctionImplementation(functionHandle);
        Preconditions.checkArgument((boolean)(implementation instanceof JavaAggregationFunctionImplementation), (Object)String.format("Implementation of function %s is not a JavaAggregationFunctionImplementationAdapter", this.getFunctionMetadata(functionHandle).getName()));
        return (JavaAggregationFunctionImplementation)implementation;
    }

    public JavaScalarFunctionImplementation getJavaScalarFunctionImplementation(FunctionHandle functionHandle) {
        ScalarFunctionImplementation implementation = this.getScalarFunctionImplementation(functionHandle);
        Preconditions.checkArgument((boolean)(implementation instanceof JavaScalarFunctionImplementation), (Object)String.format("Implementation of function %s is not a JavaScalarFunctionImplementation", this.getFunctionMetadata(functionHandle).getName()));
        return (JavaScalarFunctionImplementation)implementation;
    }

    @VisibleForTesting
    public List<SqlFunction> listOperators() {
        Set operatorNames = (Set)Arrays.asList(OperatorType.values()).stream().map(OperatorType::getFunctionName).collect(ImmutableSet.toImmutableSet());
        return (List)this.builtInTypeAndFunctionNamespaceManager.listFunctions(Optional.empty(), Optional.empty()).stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableList.toImmutableList());
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
        try {
            return this.resolveFunction(Optional.empty(), Optional.empty(), operatorType.getFunctionName(), argumentTypes);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, (List)argumentTypes.stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList()));
            }
            throw e;
        }
    }

    public FunctionHandle lookupFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        QualifiedObjectName functionName = FunctionAndTypeManager.qualifyObjectName(QualifiedName.of((String)name));
        if (parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency)) {
            return this.lookupCachedFunction(functionName, parameterTypes);
        }
        Collection<SqlFunction> candidates = this.builtInTypeAndFunctionNamespaceManager.getFunctions(Optional.empty(), functionName);
        Optional<Signature> match = this.functionSignatureMatcher.match(candidates, parameterTypes, false);
        if (!match.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, FunctionSignatureMatcher.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, candidates));
        }
        return this.builtInTypeAndFunctionNamespaceManager.getFunctionHandle(Optional.empty(), match.get());
    }

    public FunctionHandle lookupCast(CastType castType, Type fromType, Type toType) {
        this.getCommonSuperType(fromType, toType);
        Signature signature = new Signature(castType.getCastName(), FunctionKind.SCALAR, Collections.emptyList(), Collections.emptyList(), toType.getTypeSignature(), Collections.singletonList(fromType.getTypeSignature()), false);
        try {
            this.builtInTypeAndFunctionNamespaceManager.getScalarFunctionImplementation(signature);
        }
        catch (PrestoException e) {
            if (castType.isOperatorType() && e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(CastType.toOperatorType(castType), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature()), toType.getTypeSignature());
            }
            throw e;
        }
        return this.builtInTypeAndFunctionNamespaceManager.getFunctionHandle(Optional.empty(), signature);
    }

    protected Type getType(UserDefinedType userDefinedType) {
        if (userDefinedType.isDistinctType()) {
            return this.getDistinctType(((TypeSignatureParameter)userDefinedType.getPhysicalTypeSignature().getParameters().get(0)).getDistinctTypeInfo());
        }
        return this.getType(new TypeSignature(userDefinedType));
    }

    private DistinctType getDistinctType(DistinctTypeInfo distinctTypeInfo) {
        return new DistinctType(distinctTypeInfo, this.getType(distinctTypeInfo.getBaseType()), name -> (DistinctType)this.getType(new TypeSignature(name)));
    }

    private Type getUserDefinedType(TypeSignature signature) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(signature.getTypeSignatureBase());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for type '%s'", (Object)signature.getBase());
        UserDefinedType userDefinedType = (UserDefinedType)functionNamespaceManager.get().getUserDefinedType(signature.getTypeSignatureBase().getTypeName()).orElseThrow(() -> new IllegalArgumentException("Unknown type " + signature));
        Preconditions.checkArgument((boolean)userDefinedType.getPhysicalTypeSignature().getTypeSignatureBase().hasStandardType(), (Object)"A UserDefinedType must be based on static types.");
        return this.getType(userDefinedType);
    }

    private FunctionHandle resolveFunctionInternal(Optional<TransactionId> transactionId, QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        FunctionNamespaceManager functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName()).orElse(null);
        if (functionNamespaceManager == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, FunctionSignatureMatcher.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, (Collection<? extends SqlFunction>)ImmutableList.of()));
        }
        Optional<FunctionNamespaceTransactionHandle> transactionHandle = transactionId.map(id -> this.transactionManager.getFunctionNamespaceTransaction((TransactionId)id, functionName.getCatalogName()));
        if (functionNamespaceManager.canResolveFunction()) {
            return functionNamespaceManager.resolveFunction(transactionHandle, functionName, (List)parameterTypes.stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList()));
        }
        Collection candidates = functionNamespaceManager.getFunctions(transactionHandle, functionName);
        Optional<Signature> match = this.functionSignatureMatcher.match(candidates, parameterTypes, true);
        if (match.isPresent()) {
            return functionNamespaceManager.getFunctionHandle(transactionHandle, match.get());
        }
        if (functionName.getObjectName().startsWith("$literal$")) {
            String typeName = functionName.getObjectName().substring("$literal$".length());
            Type type = this.getType(TypeSignature.parseTypeSignature((String)typeName));
            Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", parameterTypes);
            return new BuiltInFunctionHandle(LiteralEncoder.getMagicLiteralFunctionSignature(type));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, FunctionSignatureMatcher.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, candidates));
    }

    private FunctionHandle resolveBuiltInFunction(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        Preconditions.checkArgument((boolean)functionName.getCatalogSchemaName().equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE), (Object)"Expect built-in functions");
        Preconditions.checkArgument((boolean)parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency), (Object)"Expect parameter types not to have dependency");
        return this.resolveFunctionInternal(Optional.empty(), functionName, parameterTypes);
    }

    private FunctionHandle lookupCachedFunction(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        try {
            return (FunctionHandle)this.functionCache.getUnchecked((Object)new FunctionResolutionCacheKey(functionName, parameterTypes));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof PrestoException) {
                throw (PrestoException)e.getCause();
            }
            throw e;
        }
    }

    private Optional<FunctionNamespaceManager<? extends SqlFunction>> getServingFunctionNamespaceManager(CatalogSchemaName functionNamespace) {
        return Optional.ofNullable(this.functionNamespaceManagers.get(functionNamespace.getCatalogName()));
    }

    private Optional<FunctionNamespaceManager<? extends SqlFunction>> getServingFunctionNamespaceManager(TypeSignatureBase typeSignatureBase) {
        return Optional.ofNullable(this.functionNamespaceManagers.get(typeSignatureBase.getTypeName().getCatalogName()));
    }

    private static class FunctionResolutionCacheKey {
        private final QualifiedObjectName functionName;
        private final List<TypeSignature> parameterTypes;

        private FunctionResolutionCacheKey(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
            Preconditions.checkArgument((boolean)parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency), (Object)"Only type signatures without dependency can be cached");
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.parameterTypes = (List)Objects.requireNonNull(parameterTypes, "parameterTypes is null").stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList());
        }

        public int hashCode() {
            return Objects.hash(this.functionName, this.parameterTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionResolutionCacheKey other = (FunctionResolutionCacheKey)obj;
            return Objects.equals(this.functionName, other.functionName) && Objects.equals(this.parameterTypes, other.parameterTypes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("parameterTypes", this.parameterTypes).toString();
        }
    }
}

